/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.ButtonDate;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelection;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.SingleDate;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PanelDate
extends JPanel {
    private final DateSelection dateSelection;
    private final int month;
    private final int year;

    public PanelDate(DateSelection dateSelection, int month, int year) {
        this.dateSelection = dateSelection;
        this.month = month;
        this.year = year;
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"background:null");
        this.setLayout((LayoutManager)new MigLayout("wrap 7,insets 3,gap 1,al center center", "fill", "[fill]10[fill][fill]"));
        this.load();
    }

    protected void load() {
        this.removeAll();
        this.createDateHeader();
        int col = 7;
        int row = 6;
        int t = 42;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.year);
        calendar.set(2, this.month);
        calendar.set(5, 1);
        int startDay = calendar.get(7) - 1;
        calendar.add(5, -startDay);
        int rowIndex = 0;
        for (int i = 1; i <= 42; ++i) {
            SingleDate singleDate = new SingleDate(calendar);
            boolean selectable = this.dateSelection.getDateSelectionAble() == null || this.dateSelection.getDateSelectionAble().isDateSelectedAble(singleDate.toLocalDate());
            boolean enable = calendar.get(2) == this.month && calendar.get(1) == this.year;
            JButton button = this.createButton(new SingleDate(calendar), enable, rowIndex);
            if (!selectable) {
                button.setEnabled(false);
            }
            this.add((Component)button);
            calendar.add(5, 1);
            if (rowIndex == 6) {
                rowIndex = 0;
                continue;
            }
            ++rowIndex;
        }
        this.checkSelection();
    }

    protected void createDateHeader() {
        String[] weekdays;
        for (String week : weekdays = DateFormatSymbols.getInstance().getShortWeekdays()) {
            if (week.isEmpty()) continue;
            this.add((Component)this.createLabel(week));
        }
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text, 0);
        label.putClientProperty("FlatLaf.style", "[light]foreground:lighten($Label.foreground,30%);[dark]foreground:darken($Label.foreground,30%)");
        return label;
    }

    protected JButton createButton(SingleDate date, boolean enable, int rowIndex) {
        ButtonDate button = new ButtonDate(this.dateSelection, date, enable, rowIndex);
        if (button.isDateSelected()) {
            button.setSelected(true);
        }
        return button;
    }

    protected void checkSelection() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component com = this.getComponent(i);
            if (!(com instanceof ButtonDate)) continue;
            ButtonDate buttonDate = (ButtonDate)com;
            if (this.dateSelection.dateSelectionMode == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
                buttonDate.setSelected(buttonDate.getDate().same(this.dateSelection.getDate()));
                continue;
            }
            buttonDate.setSelected(buttonDate.getDate().same(this.dateSelection.getDate()) || buttonDate.getDate().same(this.dateSelection.getToDate()));
        }
    }
}

