/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.ButtonMonthYear;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelection;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelYear;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PanelYear
extends JPanel {
    public static final int YEAR_CELL = 28;
    private final EventYearChanged yearChanged;
    private final DateSelection dateSelection;
    private final int year;

    public PanelYear(EventYearChanged yearChanged, DateSelection dateSelection, int year) {
        this.yearChanged = yearChanged;
        this.dateSelection = dateSelection;
        this.year = year;
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"background:null");
        this.setLayout((LayoutManager)new MigLayout("wrap 4,insets 3,fillx,gap 3,al center center", "fill,sg main", "fill"));
        int count = 28;
        for (int i = 0; i < count; ++i) {
            int y = this.getStartYear(this.year) + i;
            ButtonMonthYear button = new ButtonMonthYear(this.dateSelection, y, true);
            button.setText(y + "");
            if (this.checkSelected(y)) {
                button.setSelected(true);
            }
            button.addActionListener(e -> this.yearChanged.yearSelected(y));
            this.add((Component)button);
        }
        this.checkSelection();
    }

    private int getStartYear(int year) {
        int initYear = 1900;
        int currentYear = year;
        int yearsPerPage = 28;
        int yearsPassed = currentYear - initYear;
        int pages = yearsPassed / yearsPerPage;
        int startingYearOnPage = initYear + pages * yearsPerPage;
        return startingYearOnPage;
    }

    protected boolean checkSelected(int year) {
        if (this.dateSelection.dateSelectionMode == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
            return this.dateSelection.getDate() != null && year == this.dateSelection.getDate().getYear();
        }
        return this.dateSelection.getDate() != null && year == this.dateSelection.getDate().getYear() || this.dateSelection.getToDate() != null && year == this.dateSelection.getToDate().getYear();
    }

    protected void checkSelection() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component com = this.getComponent(i);
            if (!(com instanceof ButtonMonthYear)) continue;
            ButtonMonthYear button = (ButtonMonthYear)com;
            button.setSelected(this.checkSelected(button.getValue()));
        }
    }

    public int getYear() {
        return this.year;
    }
}

