/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.time;

import br.com.tracker.dfeconverter.view.components.datetime.component.time.Header;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;

public class Header
extends JPanel {
    private MigLayout layout;
    private final EventHeaderChanged headerChanged;
    private final DecimalFormat format = new DecimalFormat("00");
    private boolean isAm;
    private JToggleButton buttonHour;
    public JToggleButton buttonMinute;
    public JToolBar amPmToolBar;
    public ButtonGroup group;
    public JToggleButton buttonAm;
    private JToggleButton buttonPm;

    public void setOrientation(int orientation) {
        String c = orientation == 1 ? "pos b1.x2+rel 0.5al n n" : "pos 0.5al b1.y2+rel n n";
        this.amPmToolBar.setOrientation(orientation);
        this.layout.setComponentConstraints((Component)this.amPmToolBar, (Object)c);
    }

    public void setHour(int hour) {
        this.buttonHour.setText(this.format.format(hour));
        if (this.amPmToolBar.isVisible() && !this.buttonAm.isSelected() && !this.buttonPm.isSelected()) {
            this.buttonAm.setSelected(true);
            this.setAm(true);
        }
    }

    public void setMinute(int minute) {
        this.buttonMinute.setText(this.format.format(minute));
    }

    public void setAm(boolean isAm) {
        this.isAm = isAm;
        if (isAm) {
            this.buttonAm.setSelected(true);
        } else {
            this.buttonPm.setSelected(true);
        }
    }

    public void clearTime() {
        this.group.clearSelection();
        this.buttonHour.setText("--");
        this.buttonMinute.setText("--");
        this.buttonHour.setSelected(true);
    }

    public boolean isAm() {
        return this.isAm;
    }

    public void setHourSelect(boolean isHour) {
        if (isHour) {
            this.buttonHour.setSelected(true);
        } else {
            this.buttonMinute.setSelected(true);
        }
    }

    public void setUse24hour(boolean use24hour) {
        this.amPmToolBar.setVisible(!use24hour);
    }

    public Header(EventHeaderChanged headerChanged) {
        this.headerChanged = headerChanged;
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"background:$Component.accentColor");
        this.layout = new MigLayout("fill,insets 10", "center");
        this.setLayout((LayoutManager)this.layout);
        this.add((Component)this.createToolBar(), (Object)"id b1");
        this.add((Component)this.createAmPm(), (Object)"pos b1.x2+rel 0.5al n n");
    }

    protected JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("FlatLaf.style", "background:null;hoverButtonGroupBackground:null");
        this.buttonHour = this.createButton();
        this.buttonMinute = this.createButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.buttonHour);
        group.add(this.buttonMinute);
        this.buttonHour.setSelected(true);
        this.buttonHour.addActionListener(e -> this.headerChanged.hourMinuteChanged(true));
        this.buttonMinute.addActionListener(e -> this.headerChanged.hourMinuteChanged(false));
        toolBar.add(this.buttonHour);
        toolBar.add(this.createSplit());
        toolBar.add(this.buttonMinute);
        return toolBar;
    }

    protected JToggleButton createButton() {
        JToggleButton button = new JToggleButton("--");
        button.putClientProperty("FlatLaf.style", "font:+15;toolbar.margin:3,5,3,5;foreground:contrast($Component.accentColor,$ToggleButton.background,#fff);background:null;toolbar.hoverBackground:null");
        return button;
    }

    protected JToggleButton createAmPmButton(String text) {
        JToggleButton button = new JToggleButton(text);
        button.addActionListener(e -> {
            boolean am = text.equals("AM");
            if (this.isAm != am) {
                this.isAm = am;
                this.headerChanged.amPmChanged(am);
            }
        });
        button.putClientProperty("FlatLaf.style", "font:+1;foreground:contrast($Component.accentColor,$ToggleButton.background,#fff);background:null;toolbar.hoverBackground:null");
        return button;
    }

    protected JLabel createSplit() {
        JLabel label = new JLabel(":");
        label.putClientProperty("FlatLaf.style", "font:+10;foreground:contrast($Component.accentColor,$Label.background,#fff)");
        return label;
    }

    protected JToolBar createAmPm() {
        this.amPmToolBar = new JToolBar();
        this.amPmToolBar.setOrientation(1);
        this.amPmToolBar.putClientProperty("FlatLaf.style", "background:null;hoverButtonGroupBackground:null");
        this.group = new ButtonGroup();
        this.buttonAm = this.createAmPmButton("AM");
        this.buttonPm = this.createAmPmButton("PM");
        this.group.add(this.buttonAm);
        this.group.add(this.buttonPm);
        this.amPmToolBar.add(this.buttonAm);
        this.amPmToolBar.add(this.buttonPm);
        return this.amPmToolBar;
    }
}

