/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.time;

import br.com.tracker.dfeconverter.view.components.datetime.component.time.Header;
import br.com.tracker.dfeconverter.view.components.datetime.component.time.PanelClock;
import br.com.tracker.dfeconverter.view.components.datetime.component.time.TimeEvent;
import br.com.tracker.dfeconverter.view.components.datetime.component.time.TimeSelectionListener;
import br.com.tracker.dfeconverter.view.components.datetime.util.InputUtils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Component;
import java.awt.LayoutManager;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class TimePicker
extends JPanel {
    private final DateTimeFormatter format12h = DateTimeFormatter.ofPattern("hh:mm a");
    private final DateTimeFormatter format24h = DateTimeFormatter.ofPattern("HH:mm");
    private final List<TimeSelectionListener> events = new ArrayList();
    private TimeSelectionListener timeSelectionListener;
    private InputUtils.ValueCallback valueCallback;
    private JFormattedTextField editor;
    private JPopupMenu popupMenu;
    private MigLayout layout;
    private int orientation = 1;
    private Header header;
    private PanelClock panelClock;

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            String c = orientation == 1 ? "wrap," : "";
            this.layout.setLayoutConstraints((Object)(c + "fill,insets 3"));
            this.orientation = orientation;
            this.header.setOrientation(orientation);
            this.revalidate();
        }
    }

    public void setEditor(JFormattedTextField editor) {
        if (this.editor != null) {
            this.uninstallEditor(this.editor);
        }
        if (editor != null) {
            this.installEditor(editor);
        }
        this.editor = editor;
    }

    public boolean is24HourView() {
        return this.panelClock.isUse24hour();
    }

    public void set24HourView(boolean hour24) {
        if (this.panelClock.isUse24hour() != hour24) {
            this.panelClock.setUse24hour(hour24, this.header.isAm());
            this.header.setUse24hour(hour24);
            if (this.editor != null) {
                InputUtils.useTimeInput((JFormattedTextField)this.editor, (boolean)hour24, (InputUtils.ValueCallback)this.getValueCallback());
                this.runEventTimeChanged();
            }
        }
    }

    public void showPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.putClientProperty("FlatLaf.style", "borderInsets:1,1,1,1");
            this.popupMenu.add((Component)this);
        }
        SwingUtilities.updateComponentTreeUI(this.popupMenu);
        this.popupMenu.show(this.editor, 0, this.editor.getHeight());
    }

    public void closePopup() {
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
            this.repaint();
        }
    }

    public TimePicker() {
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"[light]background:darken($Panel.background,2%);[dark]background:lighten($Panel.background,2%);");
        this.layout = new MigLayout("wrap,fill,insets 3", "fill", "fill");
        this.setLayout((LayoutManager)this.layout);
        this.header = new Header(this.getEventHeader());
        this.panelClock = new PanelClock(this.getEventClock());
        this.add((Component)this.header, (Object)"width 120:120");
        this.add((Component)this.panelClock, (Object)"width 230:230, height 230:230");
    }

    public void now() {
        this.setSelectedTime(LocalTime.now());
    }

    public void setSelectedTime(LocalTime time) {
        int hour = time.getHour();
        int minute = time.getMinute();
        this.panelClock.setMinute(minute);
        this.panelClock.setHourAndFix(hour);
        this.header.setAm(hour < 12);
    }

    public void clearSelectedTime() {
        this.panelClock.setMinute(-1);
        this.panelClock.setHour(-1);
        this.panelClock.setHourSelectionView(true);
        this.header.clearTime();
    }

    public boolean isTimeSelected() {
        return this.panelClock.getHour() != -1 && this.panelClock.getMinute() != -1;
    }

    public LocalTime getSelectedTime() {
        int hour = this.panelClock.getHour();
        int minute = this.panelClock.getMinute();
        if (!this.isTimeSelected()) {
            return null;
        }
        if (this.panelClock.isUse24hour()) {
            return LocalTime.of(hour, minute);
        }
        if (this.header.isAm()) {
            if (hour == 12) {
                hour = 0;
            }
        } else if (hour < 12) {
            hour += 12;
        }
        return LocalTime.of(hour, minute);
    }

    public String getSelectedTimeAsString() {
        if (this.isTimeSelected()) {
            if (this.panelClock.isUse24hour()) {
                return this.format24h.format(this.getSelectedTime());
            }
            return this.format12h.format(this.getSelectedTime());
        }
        return null;
    }

    public void addTimeSelectionListener(TimeSelectionListener event) {
        this.events.add(event);
    }

    public void removeTimeSelectionListener(TimeSelectionListener event) {
        if (this.events != null) {
            this.events.remove(event);
        }
    }

    public void removeAllTimeSelectionListener() {
        if (this.events != null) {
            this.events.clear();
        }
    }

    private void installEditor(JFormattedTextField editor) {
        JToolBar toolBar = new JToolBar();
        JButton button = new JButton((Icon)new FlatSVGIcon("datetime/icon/clock.svg", 0.8f));
        toolBar.add(button);
        button.addActionListener(e -> this.showPopup());
        editor.putClientProperty("JTextField.trailingComponent", toolBar);
        this.addTimeSelectionListener(this.getTimeSelectionListener());
        InputUtils.useTimeInput((JFormattedTextField)editor, (boolean)this.panelClock.isUse24hour(), (InputUtils.ValueCallback)this.getValueCallback());
    }

    private void uninstallEditor(JFormattedTextField editor) {
        if (editor != null) {
            editor.setFormatterFactory(null);
            editor.putClientProperty("JTextField.trailingComponent", null);
            if (this.timeSelectionListener != null) {
                this.removeTimeSelectionListener(this.timeSelectionListener);
            }
        }
    }

    private InputUtils.ValueCallback getValueCallback() {
        if (this.valueCallback == null) {
            this.valueCallback = value -> {
                LocalTime time;
                if (value == null && this.isTimeSelected()) {
                    this.clearSelectedTime();
                } else if (value != null && !value.equals(this.getSelectedTimeAsString()) && (time = InputUtils.stringToTime((boolean)this.panelClock.isUse24hour(), (String)value.toString())) != null) {
                    this.setSelectedTime(time);
                }
            };
        }
        return this.valueCallback;
    }

    private TimeSelectionListener getTimeSelectionListener() {
        if (this.timeSelectionListener == null) {
            this.timeSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.timeSelectionListener;
    }

    private void runEventTimeChanged() {
        SwingUtilities.invokeLater(() -> {
            for (TimeSelectionListener event : this.events) {
                event.timeSelected(new TimeEvent((Object)this));
            }
        });
    }

    private Header.EventHeaderChanged getEventHeader() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private PanelClock.EventClockChanged getEventClock() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ PanelClock access$000(TimePicker x0) {
        return x0.panelClock;
    }

    static /* synthetic */ DateTimeFormatter access$100(TimePicker x0) {
        return x0.format24h;
    }

    static /* synthetic */ DateTimeFormatter access$200(TimePicker x0) {
        return x0.format12h;
    }

    static /* synthetic */ JFormattedTextField access$300(TimePicker x0) {
        return x0.editor;
    }

    static /* synthetic */ void access$400(TimePicker x0) {
        x0.runEventTimeChanged();
    }

    static /* synthetic */ Header access$500(TimePicker x0) {
        return x0.header;
    }
}

