/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.util;

import br.com.tracker.dfeconverter.view.components.datetime.util.InputUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputUtils
extends MaskFormatter {
    private static Map<Component, PropertyChangeListener> inputMap;

    public static LocalTime stringToTime(boolean use24h, String value) {
        try {
            if (use24h) {
                DateTimeFormatter format24h = DateTimeFormatter.ofPattern("HH:mm");
                return LocalTime.from(format24h.parse(value));
            }
            DateTimeFormatter format12h = DateTimeFormatter.ofPattern("hh:mm a");
            return LocalTime.from(format12h.parse(value.toUpperCase()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDate stringToDate(DateTimeFormatter format, String value) {
        try {
            return LocalDate.from(format.parse(value));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDate[] stringToDate(DateTimeFormatter format, String separator, String value) {
        try {
            String[] dates = value.split(separator);
            LocalDate from = LocalDate.from(format.parse(dates[0]));
            LocalDate to = LocalDate.from(format.parse(dates[1]));
            return new LocalDate[]{from, to};
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void useTimeInput(JFormattedTextField txt, boolean use24h, ValueCallback callback) {
        try {
            InputUtils.removePropertyChange((JFormattedTextField)txt);
            txt.putClientProperty("JTextField.showClearButton", true);
            txt.putClientProperty("JTextField.clearCallback", o -> {
                txt.setValue(null);
                callback.valueChanged(null);
            });
            TimeInputFormat mask = new TimeInputFormat(use24h ? "##:##" : "##:## ??", use24h);
            mask.setCommitsOnValidEdit(true);
            mask.setPlaceholderCharacter('-');
            DefaultFormatterFactory df = new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)mask);
            txt.setFormatterFactory(df);
            PropertyChangeListener propertyChangeListener = evt -> callback.valueChanged(txt.getValue());
            txt.addPropertyChangeListener("value", propertyChangeListener);
            InputUtils.putPropertyChange((JFormattedTextField)txt, (PropertyChangeListener)propertyChangeListener);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void useDateInput(JFormattedTextField txt, boolean between, String separator, ValueCallback callback) {
        try {
            InputUtils.removePropertyChange((JFormattedTextField)txt);
            txt.putClientProperty("JTextField.showClearButton", true);
            txt.putClientProperty("JTextField.clearCallback", o -> {
                txt.setValue(null);
                callback.valueChanged(null);
            });
            DateInputFormat mask = new DateInputFormat(between ? "##/##/####" + separator + "##/##/####" : "##/##/####", between, separator);
            mask.setCommitsOnValidEdit(true);
            mask.setPlaceholderCharacter('-');
            DefaultFormatterFactory df = new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)mask);
            txt.setFormatterFactory(df);
            PropertyChangeListener propertyChangeListener = evt -> callback.valueChanged(txt.getValue());
            txt.addPropertyChangeListener("value", propertyChangeListener);
            InputUtils.putPropertyChange((JFormattedTextField)txt, (PropertyChangeListener)propertyChangeListener);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void putPropertyChange(JFormattedTextField txt, PropertyChangeListener events) {
        if (inputMap == null) {
            inputMap = new HashMap();
        }
        inputMap.put(txt, events);
    }

    private static void removePropertyChange(JFormattedTextField txt) {
        if (inputMap == null) {
            return;
        }
        PropertyChangeListener event = (PropertyChangeListener)inputMap.get(txt);
        if (event != null) {
            txt.removePropertyChangeListener("value", event);
        }
    }
}

