/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.filechooser.api;

import br.com.tracker.dfeconverter.view.components.filechooser.api.JnaFileChooser;
import br.com.tracker.dfeconverter.view.components.filechooser.api.WindowsFileChooser;
import br.com.tracker.dfeconverter.view.components.filechooser.api.WindowsFolderBrowser;
import com.sun.jna.Platform;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JnaFileChooser {
    protected File[] selectedFiles;
    protected File currentDirectory;
    protected ArrayList<String[]> filters = new ArrayList();
    protected boolean multiSelectionEnabled = false;
    protected Mode mode = Mode.Files;
    protected String defaultFile = "";
    protected String dialogTitle = "";
    protected String openButtonText = "";
    protected String saveButtonText = "";

    public JnaFileChooser() {
        this.selectedFiles = new File[]{null};
    }

    public JnaFileChooser(File currentDirectory) {
        this();
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        }
    }

    public JnaFileChooser(String currentDirectoryPath) {
        this(currentDirectoryPath != null ? new File(currentDirectoryPath) : null);
    }

    public boolean showOpenDialog(JInternalFrame parent) {
        JFrame parentFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, parent);
        return this.showDialog((Window)parentFrame, Action.Open);
    }

    public boolean showOpenDialog(Window parent) {
        return this.showDialog(parent, Action.Open);
    }

    public boolean showSaveDialog(JInternalFrame parent) {
        JFrame parentFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, parent);
        return this.showDialog((Window)parentFrame, Action.Save);
    }

    public boolean showSaveDialog(Window parent) {
        return this.showDialog(parent, Action.Save);
    }

    private boolean showDialog(Window parent, Action action) {
        if (!(!Platform.isWindows() || this.mode == Mode.FilesAndDirectories || this.multiSelectionEnabled && this.mode == Mode.Files || this.multiSelectionEnabled)) {
            if (this.mode == Mode.Files) {
                return this.showWindowsFileChooser(parent, action);
            }
            if (this.mode == Mode.Directories) {
                return this.showWindowsFolderBrowser(parent);
            }
        }
        return this.showSwingFileChooser(parent, action);
    }

    private boolean showSwingFileChooser(Window parent, Action action) {
        JFileChooser fc = new JFileChooser(this.currentDirectory);
        fc.setMultiSelectionEnabled(this.multiSelectionEnabled);
        fc.setFileSelectionMode(this.mode.getJFileChooserValue());
        if (!this.defaultFile.isEmpty() & action == Action.Save) {
            File fsel = new File(this.defaultFile);
            fc.setSelectedFile(fsel);
        }
        if (!this.dialogTitle.isEmpty()) {
            fc.setDialogTitle(this.dialogTitle);
        }
        if (action == Action.Open & !this.openButtonText.isEmpty()) {
            fc.setApproveButtonText(this.openButtonText);
        } else if (action == Action.Save & !this.saveButtonText.isEmpty()) {
            fc.setApproveButtonText(this.saveButtonText);
        }
        if (this.filters.size() > 0) {
            boolean useAcceptAllFilter = false;
            for (String[] spec : this.filters) {
                if (spec[1].equals("*")) {
                    useAcceptAllFilter = true;
                    continue;
                }
                fc.addChoosableFileFilter(new FileNameExtensionFilter(spec[0], Arrays.copyOfRange(spec, 1, spec.length)));
            }
            fc.setAcceptAllFileFilterUsed(useAcceptAllFilter);
        }
        int result = -1;
        result = action == Action.Open ? fc.showOpenDialog(parent) : (this.saveButtonText.isEmpty() ? fc.showSaveDialog(parent) : fc.showDialog(parent, null));
        if (result == 0) {
            File[] fileArray;
            if (this.multiSelectionEnabled) {
                fileArray = fc.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = fc.getSelectedFile();
            }
            this.selectedFiles = fileArray;
            this.currentDirectory = fc.getCurrentDirectory();
            return true;
        }
        return false;
    }

    private boolean showWindowsFileChooser(Window parent, Action action) {
        boolean result;
        WindowsFileChooser fc = new WindowsFileChooser(this.currentDirectory);
        fc.setFilters(this.filters);
        if (!this.defaultFile.isEmpty()) {
            fc.setDefaultFilename(this.defaultFile);
        }
        if (!this.dialogTitle.isEmpty()) {
            fc.setTitle(this.dialogTitle);
        }
        if (result = fc.showDialog(parent, action == Action.Open)) {
            this.selectedFiles = new File[]{fc.getSelectedFile()};
            this.currentDirectory = fc.getCurrentDirectory();
        }
        return result;
    }

    private boolean showWindowsFolderBrowser(Window parent) {
        File file;
        WindowsFolderBrowser fb = new WindowsFolderBrowser();
        if (!this.dialogTitle.isEmpty()) {
            fb.setTitle(this.dialogTitle);
        }
        if ((file = fb.showDialog(parent)) != null) {
            this.selectedFiles = new File[]{file};
            this.currentDirectory = file.getParentFile() != null ? file.getParentFile() : file;
            return true;
        }
        return false;
    }

    public void addFilter(String name, String ... filter) {
        if (filter.length < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder descriptionFilter = new StringBuilder();
        descriptionFilter.append(name);
        String extensions = Arrays.asList(filter).stream().map(f -> "." + f).collect(Collectors.joining(",", " (", ")"));
        descriptionFilter.append(extensions);
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(descriptionFilter.toString());
        Collections.addAll(parts, filter);
        this.filters.add(parts.toArray(new String[parts.size()]));
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setCurrentDirectory(String currentDirectoryPath) {
        this.currentDirectory = currentDirectoryPath != null ? new File(currentDirectoryPath) : null;
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.multiSelectionEnabled = enabled;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setDefaultFileName(String dfile) {
        this.defaultFile = dfile;
    }

    public void setTitle(String title) {
        this.dialogTitle = title;
    }

    public void setOpenButtonText(String buttonText) {
        this.openButtonText = buttonText;
    }

    public void setSaveButtonText(String buttonText) {
        this.saveButtonText = buttonText;
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public File getSelectedFile() {
        return this.selectedFiles[0];
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }
}

