/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.filechooser.api;

import br.com.tracker.dfeconverter.view.components.filechooser.win32.Comdlg32;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.WString;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class WindowsFileChooser {
    protected File selectedFile;
    protected File currentDirectory;
    protected ArrayList<String[]> filters = new ArrayList();
    protected String defaultFilename = "";
    protected String dialogTitle = "";

    public WindowsFileChooser() {
    }

    public WindowsFileChooser(File currentDirectory) {
        if (currentDirectory != null) {
            this.currentDirectory = currentDirectory.isDirectory() ? currentDirectory : currentDirectory.getParentFile();
        }
    }

    public WindowsFileChooser(String currentDirectoryPath) {
        this(currentDirectoryPath != null ? new File(currentDirectoryPath) : null);
    }

    void setFilters(ArrayList<String[]> filters) {
        this.filters = filters;
    }

    public void addFilter(String name, String ... filter) {
        if (filter.length < 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(name);
        Collections.addAll(parts, filter);
        this.filters.add(parts.toArray(new String[parts.size()]));
    }

    public void setTitle(String title) {
        this.dialogTitle = title;
    }

    public boolean showOpenDialog(Window parent) {
        return this.showDialog(parent, true);
    }

    public boolean showSaveDialog(Window parent) {
        return this.showDialog(parent, false);
    }

    boolean showDialog(Window parent, boolean open) {
        boolean approved;
        Comdlg32.OpenFileName params = new Comdlg32.OpenFileName();
        params.Flags = 0x88000C;
        params.hwndOwner = parent == null ? null : Native.getWindowPointer((Window)parent);
        int bufferLength = 260;
        int bufferSize = 1041;
        params.lpstrFile = new Memory(1041L);
        if (!this.defaultFilename.isEmpty()) {
            params.lpstrFile.setWideString(0L, this.defaultFilename);
        } else {
            params.lpstrFile.clear(1041L);
        }
        if (!this.dialogTitle.isEmpty()) {
            params.lpstrTitle = new WString(this.dialogTitle);
        }
        params.nMaxFile = 260;
        if (this.currentDirectory != null) {
            params.lpstrInitialDir = new WString(this.currentDirectory.getAbsolutePath());
        }
        if (this.filters.size() > 0) {
            params.lpstrFilter = new WString(this.buildFilterString());
            params.nFilterIndex = 1;
        }
        boolean bl = approved = open ? Comdlg32.GetOpenFileNameW((Comdlg32.OpenFileName)params) : Comdlg32.GetSaveFileNameW((Comdlg32.OpenFileName)params);
        if (approved) {
            File dir;
            String filePath = params.lpstrFile.getWideString(0L);
            this.selectedFile = new File(filePath);
            this.currentDirectory = dir = this.selectedFile.getParentFile();
        } else {
            int errCode = Comdlg32.CommDlgExtendedError();
            if (errCode != 0) {
                throw new RuntimeException("GetOpenFileName failed with error " + errCode);
            }
        }
        return approved;
    }

    private String buildFilterString() {
        StringBuilder filterStr = new StringBuilder();
        for (String[] spec : this.filters) {
            String label = spec[0];
            filterStr.append(label);
            filterStr.append('\u0000');
            for (int i = 1; i < spec.length; ++i) {
                filterStr.append("*.");
                filterStr.append(spec[i]);
                filterStr.append(';');
            }
            filterStr.deleteCharAt(filterStr.length() - 1);
            filterStr.append('\u0000');
        }
        filterStr.append('\u0000');
        return filterStr.toString();
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setDefaultFilename(String defaultFilename) {
        this.defaultFilename = defaultFilename;
    }
}

