/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.label;

import br.com.tracker.dfeconverter.view.util.TrackerUtil;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ELabel
extends JLabel {
    private String svgIconPath;
    private String svgIconScale = "md";
    private String svgIconColor;

    public ELabel() {
        this(null);
    }

    public ELabel(String text) {
        super(text);
        super.setPreferredSize(new Dimension(100, 30));
        this.setarIcone();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setarIcone();
    }

    public void setSvgIconScale(String svgIconScale) {
        this.svgIconScale = svgIconScale;
        this.setarIcone();
    }

    public String getSvgIconScale() {
        return this.svgIconScale;
    }

    public void setSvgIconPath(String svgIconPath) {
        this.svgIconPath = svgIconPath;
        this.setarIcone();
    }

    private void setarIcone() {
        if (this.svgIconPath != null && !this.svgIconPath.isEmpty()) {
            Color color = this.getForeground();
            if (this.svgIconColor != null && !this.svgIconColor.isEmpty()) {
                color = FlatUIUtils.getUIColor((String)this.svgIconColor, (Color)this.getForeground());
            }
            float scale = this.getScale(this.svgIconScale);
            Icon icon = TrackerUtil.createIcon((String)this.svgIconPath, (Color)color, (float)scale);
            this.setIcon(icon);
        }
    }

    private float getScale(String scale) {
        switch (scale.toLowerCase()) {
            case "lg": {
                return 1.5f;
            }
            case "sm": {
                return 0.85f;
            }
            case "xs": {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    public String getSvgIconColor() {
        return this.svgIconColor;
    }

    public void setSvgIconColor(String svgIconColor) {
        this.svgIconColor = svgIconColor;
    }
}

