/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.label;

import br.com.tracker.dfeconverter.model.enums.StatusEvento;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelStatus
extends JPanel {
    private JLabel label;
    private int gap = 6;

    public LabelStatus() {
        this(null);
    }

    public LabelStatus(StatusEvento status) {
        this.setLayout((LayoutManager)new BorderLayout());
        this.setBackground(FlatUIUtils.getUIColor((String)"PanelBackgroundColor", (Color)Color.CYAN));
        this.label = new JLabel();
        this.label.setHorizontalAlignment(0);
        this.label.setOpaque(false);
        this.add((Component)this.label, (Object)"Center");
        this.setStatus(status);
    }

    public void setStatus(StatusEvento status) {
        if (status != null) {
            this.label.setText(status.getDescricao().toUpperCase());
            this.label.putClientProperty("FlatLaf.styleClass", "status-" + status.name());
            this.putClientProperty((Object)"FlatLaf.styleClass", (Object)("status-" + status.name()));
            this.adjustSize();
        }
    }

    private void adjustSize() {
        FontMetrics fontMetrics = this.label.getFontMetrics(this.label.getFont());
        int textWidth = fontMetrics.stringWidth(this.label.getText());
        int panelWidth = textWidth + 2 * this.gap;
        Dimension newSize = new Dimension(panelWidth, this.getPreferredSize().height);
        this.setPreferredSize(newSize);
        this.setMinimumSize(newSize);
        this.setMaximumSize(newSize);
        this.revalidate();
        this.repaint();
    }
}

