/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.spinner;

import br.com.tracker.dfeconverter.view.components.spinner.render.RingSpinner;
import br.com.tracker.dfeconverter.view.components.spinner.render.SpinnerRender;
import com.formdev.flatlaf.ui.FlatProgressBarUI;
import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JProgressBar;

public class SpinnerProgressUI
extends FlatProgressBarUI {
    protected SpinnerRender render;
    private PropertyChangeListener propertyChangeListener;
    private float lastAnimator;
    private float animateFrame;
    private boolean moreAnimation;

    protected void installDefaults() {
        super.installDefaults();
        this.render = new RingSpinner(4);
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = evt -> {
            if (this.render.isPaintComplete()) {
                String name;
                switch (name = evt.getPropertyName()) {
                    case "indeterminate": {
                        this.checkIndeterminate(evt);
                    }
                }
            }
        };
        this.progressBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void checkIndeterminate(PropertyChangeEvent evt) {
        boolean oldValue = (Boolean)evt.getOldValue();
        boolean newValue = (Boolean)evt.getNewValue();
        if (oldValue && !newValue) {
            this.moreAnimation = true;
            Animator animator = new Animator(350, (Animator.TimingTarget)new /* Unavailable Anonymous Inner Class!! */);
            animator.start();
        }
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.render = null;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    private double getPercentOf(double val) {
        long span = this.progressBar.getMaximum() - this.progressBar.getMinimum();
        double currentValue = val;
        double pc = (currentValue - (double)this.progressBar.getMinimum()) / (double)span;
        return pc;
    }

    public Dimension getPreferredSize(JComponent c) {
        int max;
        Dimension size = UIScale.scale((Dimension)new Dimension(30, 30));
        Insets border = this.progressBar.getInsets();
        int renderInsets = this.render.getInsets() * 2;
        if (this.progressBar.isStringPainted()) {
            int stringHeight;
            String progString;
            FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
            int stringWidth = fontSizer.stringWidth(progString = NumberFormat.getPercentInstance().format(this.getPercentOf((double)this.progressBar.getMaximum())));
            if (stringWidth > size.width) {
                size.width = stringWidth;
            }
            if ((stringHeight = fontSizer.getHeight() + fontSizer.getDescent()) > size.height) {
                size.height = stringHeight;
            }
        }
        size.width += renderInsets + border.left + border.right;
        size.height += renderInsets + border.top + border.bottom;
        size.width = max = Math.max(size.width, size.height);
        size.height = max;
        return size;
    }

    public void paint(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                float f = this.getAnimation();
                this.render.paintIndeterminate(g2, (Component)c, this.boxRect, f);
            }
        } else if (this.moreAnimation) {
            this.render.paintCompleteIndeterminate(g2, (Component)c, this.getBox(), this.lastAnimator, this.animateFrame, (float)this.progressBar.getPercentComplete());
        } else {
            Rectangle rec = this.getBox(new Rectangle(b.left, b.top, barRectWidth, barRectHeight));
            this.render.paintDeterminate(g2, (Component)c, rec, (float)this.progressBar.getPercentComplete());
        }
        if (this.render.isDisplayStringAble() && this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, 0, b);
        }
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        Point renderLocation = this.getStringPlacement((Graphics)g2, progressString, x, y, width, height);
        g2.setColor(this.getSelectionBackground());
        g2.drawString(progressString, renderLocation.x, renderLocation.y);
    }

    private float getAnimation() {
        float animate;
        int index = super.getAnimationIndex();
        this.lastAnimator = animate = (float)index / (float)this.getFrameCount();
        return animate;
    }

    protected Rectangle getBox(Rectangle r) {
        if (r == null) {
            return null;
        }
        Insets insets = this.progressBar.getInsets();
        int width = this.progressBar.getWidth() - (insets.right + insets.left);
        int height = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int size = Math.min(width, height);
        int x = insets.left + (width - size) / 2;
        int y = insets.top + (height - size) / 2;
        r.setBounds(x, y, size, size);
        return r;
    }

    protected Rectangle getBox() {
        Insets insets = this.progressBar.getInsets();
        int width = this.progressBar.getWidth() - (insets.right + insets.left);
        int height = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int size = Math.min(width, height);
        int x = insets.left + (width - size) / 2;
        int y = insets.top + (height - size) / 2;
        return new Rectangle(x, y, width, height);
    }

    static /* synthetic */ boolean access$002(SpinnerProgressUI x0, boolean x1) {
        x0.moreAnimation = x1;
        return x0.moreAnimation;
    }

    static /* synthetic */ float access$102(SpinnerProgressUI x0, float x1) {
        x0.animateFrame = x1;
        return x0.animateFrame;
    }

    static /* synthetic */ JProgressBar access$200(SpinnerProgressUI x0) {
        return x0.progressBar;
    }
}

