/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.spinner.render;

import br.com.tracker.dfeconverter.view.components.spinner.render.SpinnerRender;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public class RingSpinner
implements SpinnerRender {
    private final int size;

    public RingSpinner(int size) {
        this.size = size;
    }

    public boolean isDisplayStringAble() {
        return true;
    }

    public boolean isPaintComplete() {
        return true;
    }

    public void paintCompleteIndeterminate(Graphics2D g2, Component component, Rectangle rec, float last, float f, float p) {
        g2.setColor(component.getBackground());
        g2.fill(this.createShape(rec, 0.0, 360.0));
        double startAngle = 90.0f - p * 360.0f;
        double extent = p * 360.0f;
        Shape shape = this.createShape(rec, startAngle, extent);
        g2.setColor(component.getForeground());
        g2.fill(shape);
    }

    public void paintIndeterminate(Graphics2D g2, Component component, Rectangle rec, float f) {
        g2.setColor(component.getBackground());
        g2.fill(this.createShape(rec, 0.0, 360.0));
        double startAngle = 90.0f - f * 360.0f;
        double extent = 90.0;
        Shape shape = this.createShape(rec, startAngle, extent);
        g2.setColor(component.getForeground());
        g2.fill(shape);
    }

    public void paintDeterminate(Graphics2D g2, Component component, Rectangle rec, float p) {
        g2.setColor(component.getBackground());
        g2.fill(this.createShape(rec, 0.0, 360.0));
        double startAngle = 90.0f - p * 360.0f;
        double extent = p * 360.0f;
        Shape shape = this.createShape(rec, startAngle, extent);
        g2.setColor(component.getForeground());
        g2.fill(shape);
    }

    public int getInsets() {
        return UIScale.scale((int)(this.size + 5));
    }

    private Shape createShape(Rectangle rec, double start, double extent) {
        Area area = new Area(new Arc2D.Double(rec.x, rec.y, rec.width, rec.height, start, extent, 2));
        float lineWidth = UIScale.scale((int)this.size);
        float x = (float)rec.x + lineWidth;
        float y = (float)rec.y + lineWidth;
        float width = (float)rec.width - lineWidth * 2.0f;
        float height = (float)rec.height - lineWidth * 2.0f;
        area.subtract(new Area(new Arc2D.Double(x, y, width, height, 0.0, 360.0, 2)));
        return area;
    }

    private Point2D getPoint(float f) {
        double a = 50.0;
        double b = 360.0 - a;
        double start = (double)f * a;
        double end = (double)f * b;
        return new Point2D.Double(start, end);
    }
}

