/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.tooltip;

import br.com.tracker.dfeconverter.view.components.tooltip.Tooltip;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class Tooltip
extends JPanel {
    private JPanel popup;
    private int position;
    private JComponent component;
    private boolean onPressedShowing = false;
    private JLabel jlMessage;

    public static Tooltip build(String message, JComponent component) {
        Tooltip pm = new Tooltip(message, component);
        return pm;
    }

    public static Tooltip build(String message, int position, JComponent component) {
        Tooltip pm = new Tooltip(message, position, component);
        return pm;
    }

    public static Tooltip build(String message, int position, JComponent component, boolean showMoveOrPressed) {
        Tooltip pm = new Tooltip(message, position, component, showMoveOrPressed);
        return pm;
    }

    public Tooltip(String message, JComponent component) {
        this(message, 4, component, true);
    }

    public Tooltip(String message, int position, JComponent component) {
        this(message, position, component, true);
    }

    public Tooltip(String message, int position, JComponent component, boolean showMoveOrPressed) {
        this.initComponents();
        this.component = component;
        this.position = position;
        if (showMoveOrPressed) {
            this.component.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.component.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.jlMessage.setText("<html>" + message + "</html>");
        this.jlMessage.setFont(new Font("Segoe UI", 0, 12));
        this.jlMessage.setForeground(FlatUIUtils.getUIColor((String)"Tooltip.foreground", (Color)Color.WHITE));
        this.setBackground(FlatUIUtils.getUIColor((String)"Tooltip.background", (Color)Color.RED));
        this.setOpaque(false);
        this.updateBalloonBorder();
    }

    public void setText(String message) {
        this.jlMessage.setText("<html>" + message + "</html>");
    }

    public void setPosition(int position) {
        this.position = position;
        this.updateBalloonBorder();
        this.revalidate();
        this.repaint();
    }

    void showPopup() {
        this.updateBalloonBorder();
        this.revalidate();
        this.repaint();
        JRootPane rootPane = SwingUtilities.getRootPane(this.component);
        if (rootPane == null) {
            return;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        this.popup = new /* Unavailable Anonymous Inner Class!! */;
        this.popup.setOpaque(false);
        this.popup.add((Component)this);
        Point pt = SwingUtilities.convertPoint(this.component, 0, 0, layeredPane);
        int x = pt.x;
        int y = pt.y;
        Dimension size = this.popup.getPreferredSize();
        int gap = UIScale.scale((int)6);
        switch (this.position) {
            case 2: {
                x -= size.width + gap;
                break;
            }
            case 1: {
                y -= size.height + gap;
                break;
            }
            case 4: {
                x += this.component.getWidth() + gap;
                break;
            }
            case 3: {
                y += this.component.getHeight() + gap;
            }
        }
        this.popup.setBounds(x, y, size.width, size.height);
        layeredPane.add((Component)this.popup, JLayeredPane.POPUP_LAYER);
        layeredPane.repaint();
    }

    void hidePopup() {
        Container parent;
        if (this.popup != null && (parent = this.popup.getParent()) != null) {
            parent.remove(this.popup);
            parent.repaint(this.popup.getX(), this.popup.getY(), this.popup.getWidth(), this.popup.getHeight());
        }
    }

    private void initComponents() {
        this.jlMessage = new JLabel();
        this.setBackground(new Color(242, 242, 242));
        this.setLayout((LayoutManager)new BorderLayout());
        this.jlMessage.setForeground(UIManager.getColor("Panel.foreground"));
        this.jlMessage.setText("popover message");
        this.jlMessage.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.jlMessage, (Object)"Center");
    }

    public void setMessageForeground(Color fg) {
        if (fg != null) {
            this.jlMessage.setForeground(fg);
        }
    }

    private void updateBalloonBorder() {
        int direction;
        switch (this.position) {
            case 2: {
                direction = 4;
                break;
            }
            case 1: {
                direction = 3;
                break;
            }
            case 4: {
                direction = 2;
                break;
            }
            case 3: {
                direction = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setBorder((Border)new BalloonBorder(direction, FlatUIUtils.getUIColor((String)"Tooltip.background", (Color)Color.gray)));
    }

    static /* synthetic */ boolean access$000(Tooltip x0) {
        return x0.onPressedShowing;
    }

    static /* synthetic */ boolean access$002(Tooltip x0, boolean x1) {
        x0.onPressedShowing = x1;
        return x0.onPressedShowing;
    }
}

