/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.forms;

import br.com.tracker.dfeconverter.model.dto.evento.EventoDTO;
import br.com.tracker.dfeconverter.view.components.label.LabelStatus;
import br.com.tracker.dfeconverter.view.forms.EventoPainel;
import br.com.tracker.dfeconverter.view.util.TrackerUtil;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.time.LocalDateTime;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public final class EventoPainel
extends JPanel {
    private JTextArea tpArquivo;
    private LabelStatus jlStatus;
    private JLabel jlDataEvento;

    public EventoPainel(EventoDTO eventoDto) {
        this.setOpaque(false);
        this.setLayout((LayoutManager)new BorderLayout());
        this.initComponents(eventoDto);
    }

    private void initComponents(EventoDTO eventoDto) {
        JPanel shadowPanel = new JPanel(new BorderLayout());
        shadowPanel.setOpaque(false);
        shadowPanel.setBorder((Border)new DropShadowBorder(10, 0.5f, Color.BLACK));
        shadowPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        RoundedPanel contentPanel = new RoundedPanel(this, null);
        contentPanel.setLayout((LayoutManager)new MigLayout("insets 5, gap 10", "[grow][grow]", "[]5[]"));
        contentPanel.setOpaque(false);
        contentPanel.setBackground(FlatUIUtils.getUIColor((String)"PanelBackgroundColor", (Color)Color.CYAN));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tpArquivo = new JTextArea();
        this.tpArquivo.setEditable(false);
        this.tpArquivo.setLineWrap(true);
        this.tpArquivo.setWrapStyleWord(false);
        this.tpArquivo.setText(StringUtils.abbreviate((String)eventoDto.getDescricao(), (int)115));
        this.tpArquivo.setOpaque(false);
        this.tpArquivo.setFont(new Font("Segoe UI", 0, 14));
        this.tpArquivo.putClientProperty("FlatLaf.style", "border:2,0,2,0");
        this.jlStatus = new LabelStatus(eventoDto.getStatus());
        this.jlDataEvento = new JLabel();
        this.jlDataEvento.setFont(new Font("Segoe UI", 0, 14));
        this.jlDataEvento.setHorizontalAlignment(4);
        this.jlDataEvento.setText(TrackerUtil.asLocalDateTime((LocalDateTime)LocalDateTime.now()));
        contentPanel.add((Component)this.tpArquivo, "span, growx, wrap");
        contentPanel.add((Component)this.jlDataEvento, "split 2");
        contentPanel.add((Component)this.jlStatus, "gapleft 6, align left");
        int textHeight = this.calculateTextHeight(this.tpArquivo);
        Dimension size = new Dimension(410, textHeight);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        contentPanel.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        shadowPanel.add((Component)contentPanel, "Center");
        this.add((Component)shadowPanel, (Object)"Center");
    }

    private int calculateTextHeight(JTextArea textArea) {
        FontMetrics fontMetrics = textArea.getFontMetrics(textArea.getFont());
        int lineHeight = fontMetrics.getHeight();
        int textLength = textArea.getText().length();
        int lines = textLength / 35;
        lines = lines == 0 ? 1 : lines;
        int panelHeight = 80 + lineHeight * lines;
        return panelHeight > 120 ? 120 : panelHeight;
    }
}

