/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.forms;

import br.com.tracker.dfeconverter.SpringContext;
import br.com.tracker.dfeconverter.model.dto.evento.EventoDTO;
import br.com.tracker.dfeconverter.model.enums.StatusEvento;
import br.com.tracker.dfeconverter.service.ViewService;
import br.com.tracker.dfeconverter.view.components.button.ButtonPesquisar;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.renderer.EventosCellRenderer;
import br.com.tracker.dfeconverter.view.components.spinner.SpinnerProgress;
import br.com.tracker.dfeconverter.view.util.TrackerUtil;
import com.towel.el.annotation.AnnotationResolver;
import com.towel.swing.table.ObjectTableModel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eventos
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(Eventos.class);
    private static Eventos eventos;
    private final ViewService viewService;
    private SwingWorker<List<EventoDTO>, Void> worker;
    AnnotationResolver resolverEventos = new AnnotationResolver(EventoDTO.class);
    final ObjectTableModel<EventoDTO> tableModelEventos = new ObjectTableModel(this.resolverEventos, "dataEvento:Data do Evento,status:Status,descricao:Descri\u00e7\u00e3o");
    private DatePicker dpPeriodoDataEvento;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private ButtonPesquisar jbBuscar;
    private JComboBox<String> jcbStatus;
    private JFormattedTextField jftfPeriodoDataEvento;
    private JPanel jpFiltroEventos;
    private JPanel jpFundoEventos;
    private JPanel jpProgresso;
    private JTable jtEventos;
    private JTextField jtfDescricao;
    private SpinnerProgress spProgresso;

    public static Eventos getInstance() {
        if (eventos == null) {
            eventos = new Eventos();
        }
        return eventos;
    }

    public Eventos() {
        this.initComponents();
        super.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        Image imagem = Toolkit.getDefaultToolkit().createImage(Eventos.class.getClassLoader().getResource("icons/tracker-icon.png"));
        super.setIconImage(imagem);
        this.viewService = (ViewService)SpringContext.getBean(ViewService.class);
        this.setTitle(this.viewService.getAppInfo());
        TrackerUtil.findComponents((Container)this.getRootPane().getContentPane(), JComponent.class).forEach(component -> component.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */));
        this.jtEventos.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jbBuscar.addActionListener(evt -> this.listarEventos());
        LocalDate hoje = LocalDate.now();
        this.dpPeriodoDataEvento.setSelectedDateRange(hoje, hoje);
        this.preencherStatus();
        this.jtEventos.setModel((TableModel)this.tableModelEventos);
        EventosCellRenderer cellRenderer = new EventosCellRenderer();
        this.jtEventos.setDefaultRenderer(Object.class, (TableCellRenderer)cellRenderer);
        IntStream.range(0, this.tableModelEventos.getColumnCount()).forEach(columnIndex -> this.jtEventos.getColumnModel().getColumn(columnIndex).setCellRenderer((TableCellRenderer)cellRenderer));
        this.configurarColunas();
        this.listarEventos();
    }

    private void configurarColunas() {
        this.jtEventos.getColumnModel().getColumn(0).setMinWidth(150);
        this.jtEventos.getColumnModel().getColumn(0).setMaxWidth(150);
        this.jtEventos.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.jtEventos.getColumnModel().getColumn(1).setMinWidth(200);
        this.jtEventos.getColumnModel().getColumn(1).setMaxWidth(200);
        this.jtEventos.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jtEventos.getColumnModel().getColumn(2).setMinWidth(200);
        this.jtEventos.getColumnModel().getColumn(2).setMaxWidth(8000);
        this.jtEventos.getColumnModel().getColumn(2).setPreferredWidth(600);
    }

    private void preencherStatus() {
        this.jcbStatus.removeAllItems();
        this.jcbStatus.addItem("-");
        for (StatusEvento status : StatusEvento.values()) {
            this.jcbStatus.addItem(status.getDescricao());
        }
    }

    private void setProgresso(boolean visivel) {
        CardLayout cl = (CardLayout)this.jpFundoEventos.getLayout();
        cl.show(this.jpFundoEventos, visivel ? "progresso" : "tabela");
    }

    private void initComponents() {
        this.dpPeriodoDataEvento = new DatePicker();
        this.jpFiltroEventos = new JPanel();
        this.jftfPeriodoDataEvento = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jcbStatus = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jtfDescricao = new JTextField();
        this.jLabel3 = new JLabel();
        this.jbBuscar = new ButtonPesquisar();
        this.jpFundoEventos = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jtEventos = new JTable();
        this.jpProgresso = new JPanel();
        this.spProgresso = new SpinnerProgress();
        this.dpPeriodoDataEvento.setCloseAfterSelected(true);
        this.dpPeriodoDataEvento.setDateSelectionMode(DatePicker.DateSelectionMode.BETWEEN_DATE_SELECTED);
        this.dpPeriodoDataEvento.setEditor(this.jftfPeriodoDataEvento);
        this.dpPeriodoDataEvento.setUsePanelOption(true);
        this.setDefaultCloseOperation(2);
        this.setTitle("DF-e Converter - Eventos");
        this.setMinimumSize(new Dimension(887, 438));
        this.setPreferredSize(new Dimension(887, 438));
        this.jpFiltroEventos.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jpFiltroEventos.setPreferredSize(new Dimension(70, 80));
        this.jftfPeriodoDataEvento.setPreferredSize(new Dimension(200, 35));
        this.jLabel1.setText("Periodo Data Evento:");
        this.jcbStatus.setPreferredSize(new Dimension(76, 35));
        this.jLabel2.setText("Status:");
        this.jtfDescricao.setPreferredSize(new Dimension(68, 35));
        this.jLabel3.setText("Descri\u00e7\u00e3o:");
        this.jbBuscar.setText("Buscar (F5)");
        this.jbBuscar.setPreferredSize(new Dimension(140, 35));
        GroupLayout jpFiltroEventosLayout = new GroupLayout(this.jpFiltroEventos);
        this.jpFiltroEventos.setLayout(jpFiltroEventosLayout);
        jpFiltroEventosLayout.setHorizontalGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFiltroEventosLayout.createSequentialGroup().addContainerGap().addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jftfPeriodoDataEvento, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFiltroEventosLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jtfDescricao, -1, 318, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jcbStatus, -2, 175, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jbBuscar, -2, -1, -2).addContainerGap()));
        jpFiltroEventosLayout.setVerticalGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpFiltroEventosLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jftfPeriodoDataEvento, -2, -1, -2).addComponent(this.jcbStatus, -2, -1, -2).addComponent(this.jtfDescricao, -2, -1, -2).addComponent((Component)this.jbBuscar, -2, -1, -2))));
        this.getContentPane().add((Component)this.jpFiltroEventos, "North");
        this.jpFundoEventos.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.jpFundoEventos.setLayout(new CardLayout());
        this.jtEventos.setAutoResizeMode(0);
        this.jtEventos.setSelectionMode(0);
        this.jtEventos.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jtEventos);
        this.jpFundoEventos.add((Component)this.jScrollPane1, "tabela");
        this.jpProgresso.setLayout(new GridBagLayout());
        this.spProgresso.setIndeterminate(true);
        this.jpProgresso.add((Component)this.spProgresso, new GridBagConstraints());
        this.jpFundoEventos.add((Component)this.jpProgresso, "progresso");
        this.getContentPane().add((Component)this.jpFundoEventos, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void listarEventos() {
        this.setProgresso(true);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.worker = new /* Unavailable Anonymous Inner Class!! */;
        this.worker.execute();
    }

    static /* synthetic */ Eventos access$002(Eventos x0) {
        eventos = x0;
        return eventos;
    }

    static /* synthetic */ JTable access$100(Eventos x0) {
        return x0.jtEventos;
    }

    static /* synthetic */ DatePicker access$200(Eventos x0) {
        return x0.dpPeriodoDataEvento;
    }

    static /* synthetic */ JTextField access$300(Eventos x0) {
        return x0.jtfDescricao;
    }

    static /* synthetic */ JComboBox access$400(Eventos x0) {
        return x0.jcbStatus;
    }

    static /* synthetic */ ViewService access$500(Eventos x0) {
        return x0.viewService;
    }

    static /* synthetic */ Logger access$600() {
        return log;
    }

    static /* synthetic */ void access$700(Eventos x0, boolean x1) {
        x0.setProgresso(x1);
    }
}

