/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.forms;

import br.com.tracker.dfeconverter.view.components.button.ButtonAdicionar;
import br.com.tracker.dfeconverter.view.components.button.ButtonFechar;
import br.com.tracker.dfeconverter.view.components.button.ButtonRemover;
import br.com.tracker.dfeconverter.view.components.button.ButtonSalvar;
import br.com.tracker.dfeconverter.view.components.filechooser.api.JnaFileChooser;
import br.com.tracker.dfeconverter.view.components.renderer.ListStripedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileSystemView;

public class ListaPastasSincronizar
extends JDialog {
    private final DefaultListModel<String> listaPastasModel;
    private String retornoPastas;
    private JScrollPane jScrollPane1;
    private ButtonAdicionar jbAdicionar;
    private ButtonFechar jbFechar;
    private ButtonRemover jbRemover;
    private ButtonSalvar jbSalvar;
    private JList<String> jlPastasSincronizar;
    private JPanel jpFundoAcoes;
    private JPanel jpFundoPastas;

    public ListaPastasSincronizar(Frame parent, boolean modal, String pastas) {
        super(parent, modal);
        this.initComponents();
        this.retornoPastas = pastas;
        this.listaPastasModel = new DefaultListModel();
        this.jlPastasSincronizar.setModel(this.listaPastasModel);
        this.jlPastasSincronizar.setCellRenderer(new ListStripedCellRenderer());
        if (pastas != null && !"".equals(pastas.trim())) {
            this.listaPastasModel.clear();
            Arrays.asList(pastas.split(";")).forEach(this.listaPastasModel::addElement);
            if (this.listaPastasModel.size() > 0) {
                this.jlPastasSincronizar.setSelectedIndex(0);
            }
        }
    }

    public static ListaPastasSincronizar monta(Frame parent, String pastas) {
        return new ListaPastasSincronizar(parent, true, pastas);
    }

    public String get() {
        this.setVisible(true);
        return this.retornoPastas;
    }

    private void initComponents() {
        this.jpFundoPastas = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jlPastasSincronizar = new JList();
        this.jpFundoAcoes = new JPanel();
        this.jbSalvar = new ButtonSalvar();
        this.jbFechar = new ButtonFechar();
        this.jbRemover = new ButtonRemover();
        this.jbAdicionar = new ButtonAdicionar();
        this.setDefaultCloseOperation(2);
        this.setTitle("DF-e Converter - Lista de Pastas");
        this.setMinimumSize(new Dimension(500, 230));
        this.setPreferredSize(new Dimension(609, 350));
        this.jpFundoPastas.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jpFundoPastas.setLayout(new BorderLayout());
        this.jlPastasSincronizar.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jlPastasSincronizar);
        this.jpFundoPastas.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jpFundoPastas, "Center");
        this.jpFundoAcoes.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
        this.jpFundoAcoes.setPreferredSize(new Dimension(150, 150));
        this.jbSalvar.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jbFechar.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jbRemover.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jbAdicionar.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        GroupLayout jpFundoAcoesLayout = new GroupLayout(this.jpFundoAcoes);
        this.jpFundoAcoes.setLayout(jpFundoAcoesLayout);
        jpFundoAcoesLayout.setHorizontalGroup(jpFundoAcoesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFundoAcoesLayout.createSequentialGroup().addGroup(jpFundoAcoesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jbSalvar, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jbRemover, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jbFechar, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jpFundoAcoesLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent((Component)this.jbAdicionar, -2, -1, -2))).addContainerGap()));
        jpFundoAcoesLayout.setVerticalGroup(jpFundoAcoesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFundoAcoesLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jbSalvar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jbFechar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 193, Short.MAX_VALUE).addComponent((Component)this.jbAdicionar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jbRemover, -2, -1, -2).addContainerGap()));
        this.getContentPane().add((Component)this.jpFundoAcoes, "East");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void jbSalvarActionPerformed(ActionEvent evt) {
        this.retornoPastas = IntStream.range(0, this.listaPastasModel.size()).mapToObj(this.listaPastasModel::getElementAt).distinct().collect(Collectors.joining(";"));
        this.dispose();
    }

    private void jbFecharActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jbRemoverActionPerformed(ActionEvent evt) {
        int selecionado = this.jlPastasSincronizar.getSelectedIndex();
        if (selecionado != -1) {
            boolean aindaTem;
            this.listaPastasModel.remove(selecionado);
            int registros = this.listaPastasModel.size();
            int indiceAcima = selecionado - 1;
            boolean bl = aindaTem = indiceAcima >= 0 && registros > 0;
            if (indiceAcima >= 0) {
                this.jlPastasSincronizar.setSelectedIndex(indiceAcima);
            } else if (indiceAcima < 0 && aindaTem) {
                this.jlPastasSincronizar.setSelectedIndex(selecionado);
            }
        }
    }

    private void jbAdicionarActionPerformed(ActionEvent evt) {
        JnaFileChooser fileChooser = new JnaFileChooser();
        fileChooser.setMode(JnaFileChooser.Mode.Directories);
        fileChooser.setCurrentDirectory(FileSystemView.getFileSystemView().getHomeDirectory().toString());
        if (fileChooser.showOpenDialog((Window)this)) {
            File diretorio = fileChooser.getSelectedFile();
            this.listaPastasModel.addElement(diretorio.toString());
        }
    }

    static /* synthetic */ void access$000(ListaPastasSincronizar x0, ActionEvent x1) {
        x0.jbSalvarActionPerformed(x1);
    }

    static /* synthetic */ void access$100(ListaPastasSincronizar x0, ActionEvent x1) {
        x0.jbFecharActionPerformed(x1);
    }

    static /* synthetic */ void access$200(ListaPastasSincronizar x0, ActionEvent x1) {
        x0.jbRemoverActionPerformed(x1);
    }

    static /* synthetic */ void access$300(ListaPastasSincronizar x0, ActionEvent x1) {
        x0.jbAdicionarActionPerformed(x1);
    }
}

