/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.util;

import br.com.tracker.dfeconverter.view.util.TableColumnAdjuster;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableColumnAdjuster
implements PropertyChangeListener,
TableModelListener {
    private JTable table;
    private final int spacing;
    private boolean isColumnHeaderIncluded;
    private boolean isColumnDataIncluded;
    private boolean isOnlyAdjustLarger;
    private boolean isDynamicAdjustment;
    private Map<TableColumn, Integer> columnSizes = new HashMap();
    private final Preferences prefs;

    public TableColumnAdjuster(JTable table) {
        this(table, 6);
    }

    public TableColumnAdjuster(JTable table, int spacing) {
        this.table = table;
        this.spacing = spacing;
        this.prefs = table.getName() != null ? Preferences.userRoot().node("/info/evoluti/erp/tablecolumns/" + table.getName().toLowerCase()) : Preferences.userNodeForPackage(TableColumnAdjuster.class);
        this.isColumnHeaderIncluded = true;
        this.isColumnDataIncluded = true;
        this.isOnlyAdjustLarger = false;
        this.isDynamicAdjustment = false;
        this.installActions();
        this.installColumnWidthListener();
    }

    private String getPreferencesKeyForColumn(String columnName) {
        String normalized = Normalizer.normalize(columnName, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        String sanitized = normalized.replaceAll("[^\\p{IsAlphabetic}\\p{IsDigit}]", "_").replaceAll("_+", "_").replaceAll("^_|_$", "");
        return sanitized.toLowerCase();
    }

    public void adjustColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.adjustColumn(i);
        }
    }

    public void adjustColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        int columnHeaderWidth = this.getColumnHeaderWidth(column);
        int columnDataWidth = this.getColumnDataWidth(column);
        int preferredWidth = Math.max(columnHeaderWidth, columnDataWidth);
        String columnName = tableColumn.getHeaderValue().toString();
        String key = this.getPreferencesKeyForColumn(columnName);
        int savedWidth = this.prefs.getInt(key, -1);
        if (savedWidth != -1) {
            preferredWidth = savedWidth;
        }
        this.updateTableColumn(column, preferredWidth);
    }

    public void adjustColumn(String columnName) {
        TableColumn column = this.getColumnByName(columnName);
        if (column == null) {
            return;
        }
        int columnIndex = this.table.convertColumnIndexToView(column.getModelIndex());
        this.adjustColumn(columnIndex);
    }

    public void adjustColumn(String columnName, int preferredWidth) {
        TableColumn column = this.getColumnByName(columnName);
        if (column == null) {
            return;
        }
        int savedWidth = this.prefs.getInt(this.getPreferencesKeyForColumn(columnName), preferredWidth);
        if (savedWidth != -1) {
            preferredWidth = savedWidth;
        }
        int columnIndex = this.table.convertColumnIndexToView(column.getModelIndex());
        this.updateTableColumn(columnIndex, preferredWidth);
    }

    private int getColumnHeaderWidth(int column) {
        if (!this.isColumnHeaderIncluded) {
            return 0;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component c = renderer.getTableCellRendererComponent(this.table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    private int getColumnDataWidth(int column) {
        if (!this.isColumnDataIncluded) {
            return 0;
        }
        int preferredWidth = 0;
        int maxWidth = this.table.getColumnModel().getColumn(column).getMaxWidth();
        for (int row = 0; row < this.table.getRowCount() && (preferredWidth = Math.max(preferredWidth, this.getCellDataWidth(row, column))) < maxWidth; ++row) {
        }
        return preferredWidth;
    }

    private int getCellDataWidth(int row, int column) {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(row, column);
        Component c = this.table.prepareRenderer(cellRenderer, row, column);
        int width = c.getPreferredSize().width + this.table.getIntercellSpacing().width;
        return width;
    }

    private void updateTableColumn(int column, int width) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        if (this.isOnlyAdjustLarger) {
            width = Math.max(width, tableColumn.getPreferredWidth());
        }
        this.columnSizes.put(tableColumn, tableColumn.getWidth());
        this.table.getTableHeader().setResizingColumn(tableColumn);
        tableColumn.setWidth(width);
        tableColumn.setPreferredWidth(width);
        String columnName = tableColumn.getHeaderValue().toString();
        this.prefs.putInt(this.getPreferencesKeyForColumn(columnName), width);
    }

    public void restoreColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.restoreColumn(i);
        }
    }

    private void restoreColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Integer width = (Integer)this.columnSizes.get(tableColumn);
        if (width != null) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(width);
        }
    }

    public void setColumnHeaderIncluded(boolean isColumnHeaderIncluded) {
        this.isColumnHeaderIncluded = isColumnHeaderIncluded;
    }

    public void setColumnDataIncluded(boolean isColumnDataIncluded) {
        this.isColumnDataIncluded = isColumnDataIncluded;
    }

    public void setOnlyAdjustLarger(boolean isOnlyAdjustLarger) {
        this.isOnlyAdjustLarger = isOnlyAdjustLarger;
    }

    public void setDynamicAdjustment(boolean isDynamicAdjustment) {
        if (this.isDynamicAdjustment != isDynamicAdjustment) {
            if (isDynamicAdjustment) {
                this.table.addPropertyChangeListener((PropertyChangeListener)this);
                this.table.getModel().addTableModelListener((TableModelListener)this);
            } else {
                this.table.removePropertyChangeListener((PropertyChangeListener)this);
                this.table.getModel().removeTableModelListener((TableModelListener)this);
            }
        }
        this.isDynamicAdjustment = isDynamicAdjustment;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("model".equals(e.getPropertyName())) {
            TableModel model = (TableModel)e.getOldValue();
            model.removeTableModelListener((TableModelListener)this);
            model = (TableModel)e.getNewValue();
            model.addTableModelListener((TableModelListener)this);
            this.adjustColumns();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    private void installActions() {
        this.installColumnAction(true, true, "adjustColumn", "control ADD");
        this.installColumnAction(false, true, "adjustColumns", "control shift ADD");
        this.installColumnAction(true, false, "restoreColumn", "control SUBTRACT");
        this.installColumnAction(false, false, "restoreColumns", "control shift SUBTRACT");
        this.installToggleAction(true, false, "toggleDynamic", "control MULTIPLY");
        this.installToggleAction(false, true, "toggleLarger", "control DIVIDE");
    }

    private void installColumnAction(boolean isSelectedColumn, boolean isAdjust, String key, String keyStroke) {
        ColumnAction action = new ColumnAction(this, isSelectedColumn, isAdjust);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, (Action)action);
    }

    private void installToggleAction(boolean isToggleDynamic, boolean isToggleLarger, String key, String keyStroke) {
        ToggleAction action = new ToggleAction(this, isToggleDynamic, isToggleLarger);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, (Action)action);
    }

    private TableColumn getColumnByName(String columnName) {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            if (!columnName.equals(column.getHeaderValue().toString())) continue;
            return column;
        }
        return null;
    }

    private void installColumnWidthListener() {
        this.table.getColumnModel().addColumnModelListener((TableColumnModelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ JTable access$000(TableColumnAdjuster x0) {
        return x0.table;
    }

    static /* synthetic */ void access$100(TableColumnAdjuster x0, int x1) {
        x0.restoreColumn(x1);
    }

    static /* synthetic */ boolean access$200(TableColumnAdjuster x0) {
        return x0.isDynamicAdjustment;
    }

    static /* synthetic */ boolean access$300(TableColumnAdjuster x0) {
        return x0.isOnlyAdjustLarger;
    }

    static /* synthetic */ Map access$400(TableColumnAdjuster x0) {
        return x0.columnSizes;
    }

    static /* synthetic */ String access$500(TableColumnAdjuster x0, String x1) {
        return x0.getPreferencesKeyForColumn(x1);
    }

    static /* synthetic */ Preferences access$600(TableColumnAdjuster x0) {
        return x0.prefs;
    }
}

