/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.FloatArrayCache;
import sun.java2d.marlin.Helpers;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.RendererContext;

final class Dasher
implements PathConsumer2D,
MarlinConst {
    static final int REC_LIMIT = 4;
    static final float ERR = 0.01f;
    static final float MIN_T_INC = 0.0625f;
    private PathConsumer2D out;
    private float[] dash;
    private int dashLen;
    private float startPhase;
    private boolean startDashOn;
    private int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private float phase;
    private float sx;
    private float sy;
    private float x0;
    private float y0;
    private final float[] curCurvepts;
    final RendererContext rdrCtx;
    boolean recycleDashes;
    final FloatArrayCache.Reference dashes_ref;
    final FloatArrayCache.Reference firstSegmentsBuffer_ref;
    private float[] firstSegmentsBuffer;
    private int firstSegidx;
    private final LengthIterator li = new LengthIterator();

    Dasher(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.dashes_ref = rendererContext.newDirtyFloatArrayRef(256);
        this.firstSegmentsBuffer_ref = rendererContext.newDirtyFloatArrayRef(256);
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.initial;
        this.curCurvepts = new float[16];
    }

    Dasher init(PathConsumer2D pathConsumer2D, float[] fArray, int n, float f, boolean bl) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("phase < 0 !");
        }
        this.out = pathConsumer2D;
        int n2 = 0;
        this.dashOn = true;
        while (true) {
            float f2;
            float f3 = fArray[n2];
            if (!(f >= f2)) break;
            f -= f3;
            n2 = (n2 + 1) % n;
            this.dashOn = !this.dashOn;
        }
        this.dash = fArray;
        this.dashLen = n;
        this.startPhase = this.phase = f;
        this.startDashOn = this.dashOn;
        this.startIdx = n2;
        this.starting = true;
        this.needsMoveTo = false;
        this.firstSegidx = 0;
        this.recycleDashes = bl;
        return this;
    }

    void dispose() {
        if (this.recycleDashes) {
            this.dash = this.dashes_ref.putArray(this.dash);
        }
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.putArray(this.firstSegmentsBuffer);
    }

    @Override
    public void moveTo(float f, float f2) {
        if (this.firstSegidx > 0) {
            this.out.moveTo(this.sx, this.sy);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.sx = this.x0 = f;
        this.sy = this.y0 = f2;
        this.starting = true;
    }

    private void emitSeg(float[] fArray, int n, int n2) {
        switch (n2) {
            case 8: {
                this.out.curveTo(fArray[n + 0], fArray[n + 1], fArray[n + 2], fArray[n + 3], fArray[n + 4], fArray[n + 5]);
                return;
            }
            case 6: {
                this.out.quadTo(fArray[n + 0], fArray[n + 1], fArray[n + 2], fArray[n + 3]);
                return;
            }
            case 4: {
                this.out.lineTo(fArray[n], fArray[n + 1]);
                return;
            }
        }
    }

    private void emitFirstSegments() {
        int n;
        float[] fArray = this.firstSegmentsBuffer;
        for (int i = 0; i < this.firstSegidx; i += n - 1) {
            n = (int)fArray[i];
            this.emitSeg(fArray, i + 1, n);
        }
        this.firstSegidx = 0;
    }

    private void goTo(float[] fArray, int n, int n2) {
        float f = fArray[n + n2 - 4];
        float f2 = fArray[n + n2 - 3];
        if (this.dashOn) {
            if (this.starting) {
                int n3 = this.firstSegidx;
                int n4 = n2 - 2 + 1;
                float[] fArray2 = this.firstSegmentsBuffer;
                if (n3 + n4 > fArray2.length) {
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_array_dasher_firstSegmentsBuffer.add(n3 + n4);
                    }
                    this.firstSegmentsBuffer = fArray2 = this.firstSegmentsBuffer_ref.widenArray(fArray2, n3, n3 + n4);
                }
                fArray2[n3++] = n2;
                System.arraycopy(fArray, n, fArray2, n3, --n4);
                this.firstSegidx = n3 += n4;
            } else {
                if (this.needsMoveTo) {
                    this.out.moveTo(this.x0, this.y0);
                    this.needsMoveTo = false;
                }
                this.emitSeg(fArray, n, n2);
            }
        } else {
            this.starting = false;
            this.needsMoveTo = true;
        }
        this.x0 = f;
        this.y0 = f2;
    }

    @Override
    public void lineTo(float f, float f2) {
        float f3 = f - this.x0;
        float f4 = f2 - this.y0;
        float f5 = f3 * f3 + f4 * f4;
        if (f5 == 0.0f) {
            return;
        }
        f5 = (float)Math.sqrt(f5);
        float f6 = f3 / f5;
        float f7 = f4 / f5;
        float[] fArray = this.curCurvepts;
        float[] fArray2 = this.dash;
        while (true) {
            float f8;
            if (f5 <= (f8 = fArray2[this.idx] - this.phase)) {
                fArray[0] = f;
                fArray[1] = f2;
                this.goTo(fArray, 0, 4);
                this.phase += f5;
                if (f5 == f8) {
                    this.phase = 0.0f;
                    this.idx = (this.idx + 1) % this.dashLen;
                    this.dashOn = !this.dashOn;
                }
                return;
            }
            float f9 = fArray2[this.idx] * f6;
            float f10 = fArray2[this.idx] * f7;
            if (this.phase == 0.0f) {
                fArray[0] = this.x0 + f9;
                fArray[1] = this.y0 + f10;
            } else {
                float f11 = f8 / fArray2[this.idx];
                fArray[0] = this.x0 + f11 * f9;
                fArray[1] = this.y0 + f11 * f10;
            }
            this.goTo(fArray, 0, 4);
            f5 -= f8;
            this.idx = (this.idx + 1) % this.dashLen;
            this.dashOn = !this.dashOn;
            this.phase = 0.0f;
        }
    }

    private void somethingTo(int n) {
        if (Dasher.pointCurve(this.curCurvepts, n)) {
            return;
        }
        this.li.initializeIterationOnCurve(this.curCurvepts, n);
        int n2 = 0;
        float f = 0.0f;
        float f2 = this.dash[this.idx] - this.phase;
        while (true) {
            float f3;
            float f4 = this.li.next(f2);
            if (!(f3 < 1.0f)) break;
            if (f4 != 0.0f) {
                Helpers.subdivideAt((f4 - f) / (1.0f - f), this.curCurvepts, n2, this.curCurvepts, 0, this.curCurvepts, n, n);
                f = f4;
                this.goTo(this.curCurvepts, 2, n);
                n2 = n;
            }
            this.idx = (this.idx + 1) % this.dashLen;
            this.dashOn = !this.dashOn;
            this.phase = 0.0f;
            f2 = this.dash[this.idx];
        }
        this.goTo(this.curCurvepts, n2 + 2, n);
        this.phase += this.li.lastSegLen();
        if (this.phase >= this.dash[this.idx]) {
            this.phase = 0.0f;
            this.idx = (this.idx + 1) % this.dashLen;
            this.dashOn = !this.dashOn;
        }
        this.li.reset();
    }

    private static boolean pointCurve(float[] fArray, int n) {
        for (int i = 2; i < n; ++i) {
            if (fArray[i] == fArray[i - 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = this.curCurvepts;
        fArray[0] = this.x0;
        fArray[1] = this.y0;
        fArray[2] = f;
        fArray[3] = f2;
        fArray[4] = f3;
        fArray[5] = f4;
        fArray[6] = f5;
        fArray[7] = f6;
        this.somethingTo(8);
    }

    @Override
    public void quadTo(float f, float f2, float f3, float f4) {
        float[] fArray = this.curCurvepts;
        fArray[0] = this.x0;
        fArray[1] = this.y0;
        fArray[2] = f;
        fArray[3] = f2;
        fArray[4] = f3;
        fArray[5] = f4;
        this.somethingTo(6);
    }

    @Override
    public void closePath() {
        this.lineTo(this.sx, this.sy);
        if (this.firstSegidx > 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx, this.sy);
            }
            this.emitFirstSegments();
        }
        this.moveTo(this.sx, this.sy);
    }

    @Override
    public void pathDone() {
        if (this.firstSegidx > 0) {
            this.out.moveTo(this.sx, this.sy);
            this.emitFirstSegments();
        }
        this.out.pathDone();
        this.dispose();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Dasher does not use a native consumer");
    }

    static final class LengthIterator {
        private final float[][] recCurveStack;
        private final Side[] sides;
        private int curveType;
        private float nextT;
        private float lenAtNextT;
        private float lastT;
        private float lenAtLastT;
        private float lenAtLastSplit;
        private float lastSegLen;
        private int recLevel;
        private boolean done = true;
        private final float[] curLeafCtrlPolyLengths = new float[3];
        private int cachedHaveLowAcceleration = -1;
        private final float[] nextRoots = new float[4];
        private final float[] flatLeafCoefCache = new float[]{0.0f, 0.0f, -1.0f, 0.0f};

        LengthIterator() {
            this.recCurveStack = new float[5][8];
            this.sides = new Side[4];
            this.nextT = Float.MAX_VALUE;
            this.lenAtNextT = Float.MAX_VALUE;
            this.lenAtLastSplit = Float.MIN_VALUE;
            this.recLevel = Integer.MIN_VALUE;
            this.lastSegLen = Float.MAX_VALUE;
        }

        void reset() {
        }

        void initializeIterationOnCurve(float[] fArray, int n) {
            System.arraycopy(fArray, 0, this.recCurveStack[0], 0, 8);
            this.curveType = n;
            this.recLevel = 0;
            this.lastT = 0.0f;
            this.lenAtLastT = 0.0f;
            this.nextT = 0.0f;
            this.lenAtNextT = 0.0f;
            this.goLeft();
            this.lenAtLastSplit = 0.0f;
            if (this.recLevel > 0) {
                this.sides[0] = Side.LEFT;
                this.done = false;
            } else {
                this.sides[0] = Side.RIGHT;
                this.done = true;
            }
            this.lastSegLen = 0.0f;
        }

        private boolean haveLowAcceleration(float f) {
            if (this.cachedHaveLowAcceleration == -1) {
                float f2;
                float f3;
                float f4 = this.curLeafCtrlPolyLengths[0];
                float f5 = this.curLeafCtrlPolyLengths[1];
                if (!Helpers.within(f4, f5, f * f5)) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                if (!(this.curveType != 8 || Helpers.within(f5, f3 = this.curLeafCtrlPolyLengths[2], f2 = f * f3) && Helpers.within(f4, f3, f2))) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                this.cachedHaveLowAcceleration = 1;
                return true;
            }
            return this.cachedHaveLowAcceleration == 1;
        }

        float next(float f) {
            float f2 = this.lenAtLastSplit + f;
            while (this.lenAtNextT < f2) {
                if (this.done) {
                    this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                    return 1.0f;
                }
                this.goToNextLeaf();
            }
            this.lenAtLastSplit = f2;
            float f3 = this.lenAtNextT - this.lenAtLastT;
            float f4 = (f2 - this.lenAtLastT) / f3;
            if (!this.haveLowAcceleration(0.05f)) {
                float f5;
                int n;
                float f6;
                float f7;
                float f8;
                float[] fArray = this.flatLeafCoefCache;
                if (fArray[2] < 0.0f) {
                    f8 = 0.0f + this.curLeafCtrlPolyLengths[0];
                    f7 = f8 + this.curLeafCtrlPolyLengths[1];
                    if (this.curveType == 8) {
                        f6 = f7 + this.curLeafCtrlPolyLengths[2];
                        fArray[0] = 3.0f * (f8 - f7) + f6;
                        fArray[1] = 3.0f * (f7 - 2.0f * f8);
                        fArray[2] = 3.0f * f8;
                        fArray[3] = -f6;
                    } else if (this.curveType == 6) {
                        fArray[0] = 0.0f;
                        fArray[1] = f7 - 2.0f * f8;
                        fArray[2] = 2.0f * f8;
                        fArray[3] = -f7;
                    }
                }
                if ((n = Helpers.cubicRootsInAB(f8 = fArray[0], f7 = fArray[1], f6 = fArray[2], f5 = f4 * fArray[3], this.nextRoots, 0, 0.0f, 1.0f)) == 1 && !Float.isNaN(this.nextRoots[0])) {
                    f4 = this.nextRoots[0];
                }
            }
            if ((f4 = f4 * (this.nextT - this.lastT) + this.lastT) >= 1.0f) {
                f4 = 1.0f;
                this.done = true;
            }
            this.lastSegLen = f;
            return f4;
        }

        float lastSegLen() {
            return this.lastSegLen;
        }

        private void goToNextLeaf() {
            int n = this.recLevel;
            Side[] sideArray = this.sides;
            --n;
            while (sideArray[n] == Side.RIGHT) {
                if (n == 0) {
                    this.recLevel = 0;
                    this.done = true;
                    return;
                }
                --n;
            }
            sideArray[n] = Side.RIGHT;
            System.arraycopy(this.recCurveStack[n], 0, this.recCurveStack[n + 1], 0, 8);
            this.recLevel = ++n;
            this.goLeft();
        }

        private void goLeft() {
            float f = this.onLeaf();
            if (f >= 0.0f) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (float)(1 << 4 - this.recLevel) * 0.0625f;
                this.lenAtNextT += f;
                this.flatLeafCoefCache[2] = -1.0f;
                this.cachedHaveLowAcceleration = -1;
            } else {
                Helpers.subdivide(this.recCurveStack[this.recLevel], 0, this.recCurveStack[this.recLevel + 1], 0, this.recCurveStack[this.recLevel], 0, this.curveType);
                this.sides[this.recLevel] = Side.LEFT;
                ++this.recLevel;
                this.goLeft();
            }
        }

        private float onLeaf() {
            float[] fArray = this.recCurveStack[this.recLevel];
            float f = 0.0f;
            float f2 = fArray[0];
            float f3 = fArray[1];
            for (int i = 2; i < this.curveType; i += 2) {
                float f4 = fArray[i];
                float f5 = fArray[i + 1];
                float f6 = Helpers.linelen(f2, f3, f4, f5);
                f += f6;
                this.curLeafCtrlPolyLengths[i / 2 - 1] = f6;
                f2 = f4;
                f3 = f5;
            }
            float f7 = Helpers.linelen(fArray[0], fArray[1], fArray[this.curveType - 2], fArray[this.curveType - 1]);
            if (f - f7 < 0.01f || this.recLevel == 4) {
                return (f + f7) / 2.0f;
            }
            return -1.0f;
        }

        private static enum Side {
            LEFT,
            RIGHT;

        }
    }
}

