/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.clisitef.tef;

import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.swconsultoria.clisitef.exception.TefException;
import br.com.swconsultoria.clisitef.util.Util;

public class ConfiguracoesTef {
    private static JCliSiTefI cliSiTef;
    private static String codigoLoja;
    private static String enderecoServidor;
    private static String numeroTerminal;
    private static String paramAdicionais;

    public static void configuraTef(String codigoLoja, String enderecoServidor, String numeroTerminal, String paramAdicionais) {
        ConfiguracoesTef.codigoLoja = codigoLoja;
        ConfiguracoesTef.enderecoServidor = enderecoServidor;
        ConfiguracoesTef.numeroTerminal = numeroTerminal;
        ConfiguracoesTef.paramAdicionais = paramAdicionais;
    }

    public static JCliSiTefI getInstancia() throws TefException {
        if (Util.isEmpty(cliSiTef)) {
            ConfiguracoesTef.inicializaConfiguracaoTef();
        }
        return cliSiTef;
    }

    private static void inicializaConfiguracaoTef() throws TefException {
        ConfiguracoesTef.validaVariaveis();
        try {
            int retorno;
            cliSiTef = new JCliSiTefI();
            cliSiTef.setCodigoLoja(codigoLoja);
            cliSiTef.setEnderecoSiTef(enderecoServidor);
            cliSiTef.setNumeroTerminal(numeroTerminal);
            if (!Util.isEmpty(paramAdicionais)) {
                cliSiTef.setParametrosAdicionais(paramAdicionais);
                retorno = cliSiTef.configuraIntSiTefInterativoEx();
            } else {
                retorno = cliSiTef.configuraIntSiTefInterativo();
            }
            ConfiguracoesTef.validaRetorno(retorno);
        }
        catch (TefException e) {
            throw new TefException("Erro ao Configurar Sitef: " + e.getMessage());
        }
    }

    private static void validaVariaveis() throws TefException {
        if (Util.isEmpty(codigoLoja) || Util.isEmpty(enderecoServidor) || Util.isEmpty(numeroTerminal)) {
            throw new TefException("Vari\u00e1veis de configura\u00e7\u00e3o n\u00e3o inicializadas.");
        }
    }

    private static void validaRetorno(int retorno) throws TefException {
        String msg = "";
        switch (retorno) {
            case 0: {
                return;
            }
            case 1: {
                msg = "Endere\u00e7o IP inv\u00e1lido ou n\u00e3o resolvido";
                break;
            }
            case 2: {
                msg = "C\u00f3digo da loja inv\u00e1lido";
                break;
            }
            case 3: {
                msg = "C\u00f3digo de terminal inv\u00e1lido";
                break;
            }
            case 6: {
                msg = "Erro na inicializa\u00e7\u00e3o do Tcp/Ip";
                break;
            }
            case 7: {
                msg = "Falta de mem\u00f3ria";
                break;
            }
            case 8: {
                msg = "N\u00e3o encontrou a CliSiTef ou ela est\u00e1 com problemas";
                break;
            }
            case 9: {
                msg = "Configura\u00e7\u00e3o de servidores SiTef foi excedida.";
                break;
            }
            case 10: {
                msg = "Erro de acesso na pasta CliSiTef (poss\u00edvel falta de permiss\u00e3o para escrita)";
                break;
            }
            case 11: {
                msg = "Dados inv\u00e1lidos passados pela automa\u00e7\u00e3o.";
                break;
            }
            case 12: {
                msg = "Modo seguro n\u00e3o ativo (poss\u00edvel falta de configura\u00e7\u00e3o no servidor SiTef do arquivo .cha).";
                break;
            }
            case 13: {
                msg = "Caminho DLL inv\u00e1lido (o caminho completo das bibliotecas est\u00e1 muito grande).";
            }
        }
        throw new TefException(msg);
    }
}

