/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.clisitef.tef;

import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.swconsultoria.clisitef.dom.RetornoSitef;
import br.com.swconsultoria.clisitef.enums.Funcoes;
import br.com.swconsultoria.clisitef.exception.TefException;
import br.com.swconsultoria.clisitef.tef.ConfiguracoesTef;
import br.com.swconsultoria.clisitef.util.RetornoUtil;
import br.com.swconsultoria.clisitef.util.Util;

public class TransacaoTef {
    private static int status;

    public static RetornoSitef inicializaTefInterativo(Funcoes funcao, String valor, String numeroCuponFiscal, String dataFiscal, String horario, String operador, String parametrosAdicionais, String produtos) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            cliSiTefI.setModalidade(funcao.getCodigo());
            cliSiTefI.setValor(valor);
            cliSiTefI.setNumeroCuponFiscal(numeroCuponFiscal);
            cliSiTefI.setDataFiscal(dataFiscal);
            cliSiTefI.setHorario(horario);
            cliSiTefI.setOperador(operador);
            cliSiTefI.setParametrosAdicionais(parametrosAdicionais);
            if (!Util.isEmpty(produtos)) {
                cliSiTefI.setProdutos(produtos);
                status = cliSiTefI.iniciaFuncaoSiTefInterativo();
            } else {
                status = cliSiTefI.iniciaFuncaoSiTefInterativo();
            }
            if (RetornoUtil.continua(status)) {
                cliSiTefI.setBuffer("");
                cliSiTefI.setContinuaNavegacao(0);
                return TransacaoTef.continuaTefInterativo();
            }
        }
        catch (TefException e) {
            throw new TefException("Erro ao Iniciar fun\u00e7\u00e3o Sitef: " + e.getMessage());
        }
        return null;
    }

    public static int transacoesPendentes(String data, String numeroCupom) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            return cliSiTefI.obtemQuantidadeTransacoesPendentes(data, numeroCupom);
        }
        catch (TefException e) {
            throw new TefException("Erro ao obter transa\u00e7\u00f5es pendentes: " + e.getMessage());
        }
    }

    public static void finalizaTefInterativo(boolean confirma, String cupom, String data, String horario, String params) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            short confirmaShort = confirma ? (short)1 : 0;
            int resultado = cliSiTefI.finalizaFuncaoSiTefInterativo(confirmaShort, cupom, data, horario, params);
            if (resultado != 0) {
                throw new TefException(RetornoUtil.validaErro(resultado));
            }
        }
        catch (TefException e) {
            throw new TefException("Erro ao Finalizar fun\u00e7\u00e3o Sitef: " + e.getMessage());
        }
    }

    public static void enviaValorBuffer(String buffer) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            cliSiTefI.setBuffer(buffer);
        }
        catch (TefException e) {
            throw new TefException("Erro ao setar Buffer: " + e.getMessage());
        }
    }

    public static void continuaNavegacao(int valor) throws TefException {
        try {
            JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
            cliSiTefI.setContinuaNavegacao(valor);
        }
        catch (TefException e) {
            throw new TefException("Erro ao continuar Navegacao: " + e.getMessage());
        }
    }

    public static RetornoSitef continuaTefInterativo() throws TefException {
        JCliSiTefI cliSiTefI = ConfiguracoesTef.getInstancia();
        status = cliSiTefI.continuaFuncaoSiTefInterativo();
        if (RetornoUtil.continua(status)) {
            cliSiTefI.setContinuaNavegacao(0);
            return RetornoUtil.getRetorno(cliSiTefI);
        }
        RetornoSitef retornoSitef = new RetornoSitef();
        retornoSitef.setContinua(false);
        return retornoSitef;
    }
}

