/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.clisitef.util;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    private static final String CHARSET_UFT_8 = "UTF-8";

    private Util() {
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() == 0;
        }
        String s = String.valueOf(obj).trim();
        return s.length() == 0 || s.equalsIgnoreCase("null");
    }

    public static String valorOuVazioSeNull(String valor) {
        if (valor == null) {
            return "";
        }
        return valor;
    }

    public static Integer valorOuZeroSeNull(Integer valor) {
        if (Util.isEmpty(valor)) {
            return new Integer(0);
        }
        return valor;
    }

    public static String completarAEsquerda(String value, char c, int size) {
        String result = value;
        while (result.length() <= size) {
            result = c + result;
        }
        return result;
    }

    public static String completarComZerosAEsquerda(String value, int length) {
        int tam = value.length();
        String result = value;
        for (int i = tam; i < length; ++i) {
            result = "0" + result;
        }
        return result;
    }

    public static String completarZerosADireita(int num, int tam) {
        return String.format("%-" + tam + "s", num).replace(' ', '0');
    }

    public static String removerZerosAEsquerda(String valor) {
        try {
            long parse = Long.parseLong(valor);
            return Long.toString(parse);
        }
        catch (NumberFormatException e) {
            return "0";
        }
    }

    public static String formatarCPFCNPJ(String dado) {
        try {
            if (dado.length() < 12) {
                Pattern pattern = Pattern.compile("(\\d{3})(\\d{3})(\\d{3})(\\d{2})");
                Matcher matcher = pattern.matcher(dado);
                if (matcher.matches()) {
                    dado = matcher.replaceAll("$1.$2.$3-$4");
                }
            } else {
                Pattern pattern = Pattern.compile("(\\d{2})(\\d{3})(\\d{3})(\\d{4})(\\d{2})");
                Matcher matcher = pattern.matcher(dado);
                if (matcher.matches()) {
                    dado = matcher.replaceAll("$1.$2.$3/$4-$5");
                }
            }
            return dado;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatarTelefone(String tel) {
        if (tel.length() < 10) {
            return tel;
        }
        String dig = tel.substring(0, 2);
        String num = tel.substring(2, tel.length());
        String numFormat = "";
        numFormat = num.length() > 8 ? num.substring(0, 5) + "-" + num.substring(5, 9) : num.substring(0, 4) + "-" + num.substring(4, 8);
        numFormat = "(" + dig + ")" + numFormat;
        return numFormat;
    }

    public static String formatarCep(String dado) {
        try {
            long cep = Long.parseLong(dado);
            long cep1 = cep / 1000L;
            long cep2 = cep % 1000L;
            return String.format("%05d-%03d", cep1, cep2);
        }
        catch (Exception e) {
            return dado;
        }
    }

    public static String completarBytesString(String dado, int tamanho, boolean reduzirTamanho) {
        int stringLength = dado.length();
        if (stringLength > tamanho) {
            if (reduzirTamanho) {
                return dado.substring(0, tamanho);
            }
            return dado;
        }
        StringBuilder sb = new StringBuilder(dado);
        for (int i = stringLength; i < tamanho; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String completarBytesAEsquerda(String dado, int tamanho) {
        int stringLength = dado.length();
        if (stringLength > tamanho) {
            return dado;
        }
        StringBuilder bytes = new StringBuilder();
        for (int i = stringLength; i < tamanho; ++i) {
            bytes.append(" ");
        }
        return bytes.append(dado).toString();
    }

    public static String abreviarNome(String nome) {
        List<String> conjuncao = Arrays.asList("de", "da", "do", "das", "dos");
        StringTokenizer st = new StringTokenizer(nome, " ");
        StringBuilder nomeAbreviado = new StringBuilder();
        int i = 1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (i == 1) {
                nomeAbreviado.append(token.toUpperCase());
            } else if (conjuncao.indexOf(token.toLowerCase()) == -1) {
                nomeAbreviado.append(" ");
                nomeAbreviado.append(token.substring(0, 1).toUpperCase());
            }
            ++i;
        }
        return nomeAbreviado.toString();
    }

    public static String limitarTamanhoString(String valor, int limite) {
        if (valor.length() <= limite) {
            return valor;
        }
        return valor.substring(0, limite);
    }

    public static String removerEspacoEmBranco(String s) {
        StringTokenizer st = new StringTokenizer(s.trim(), " ");
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getIpLocalhost() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    private static String getValorCriptografado(String valor, String algoritmo) {
        try {
            if (Util.isEmpty(algoritmo)) {
                throw new IllegalArgumentException("O algoritimo n\u00e3o foi especificado.");
            }
            if (Util.isEmpty(valor)) {
                return "";
            }
            MessageDigest messageDigest = MessageDigest.getInstance(algoritmo);
            byte[] digest = messageDigest.digest(valor.getBytes(CHARSET_UFT_8));
            BigInteger hash = new BigInteger(1, digest);
            String crypto = hash.toString(16);
            if (crypto.length() % 2 != 0) {
                crypto = "0" + crypto;
            }
            return crypto;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Falha ao Criptografar o valor: " + valor + " em " + algoritmo + ".", e);
        }
    }

    public static String getValorCriptografadoMD5(String valor) {
        return Util.getValorCriptografado(valor, "MD5");
    }

    public static String getValorCriptografadoSHA1(String valor) {
        return Util.getValorCriptografado(valor, "SHA1");
    }
}

