/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jsr353;

import com.owlike.genson.ext.jsr353.JSR353Bundle;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

class GensonJsonObject
implements JsonObject {
    private final Map<String, JsonValue> values;

    GensonJsonObject(Map<String, JsonValue> values) {
        this.values = values;
    }

    public JsonArray getJsonArray(String name) {
        return (JsonArray)JsonArray.class.cast(this.values.get(name));
    }

    public JsonObject getJsonObject(String name) {
        return (JsonObject)JsonObject.class.cast(this.values.get(name));
    }

    public JsonNumber getJsonNumber(String name) {
        return (JsonNumber)JsonNumber.class.cast(this.values.get(name));
    }

    public JsonString getJsonString(String name) {
        return (JsonString)JsonString.class.cast(this.values.get(name));
    }

    public String getString(String name) {
        return this.getJsonString(name).getString();
    }

    public String getString(String name, String defaultValue) {
        return this.isNull(name) ? defaultValue : this.getString(name);
    }

    public int getInt(String name) {
        return this.getJsonNumber(name).intValue();
    }

    public int getInt(String name, int defaultValue) {
        return this.isNull(name) ? defaultValue : this.getInt(name);
    }

    public boolean getBoolean(String name) {
        JsonValue value = this.values.get(name);
        if (JsonValue.TRUE.equals(value)) {
            return true;
        }
        if (JsonValue.FALSE.equals(value)) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.isNull(name) ? defaultValue : this.getBoolean(name);
    }

    public boolean isNull(String name) {
        JsonValue value = this.values.get(name);
        return JsonValue.NULL.equals(value) || value == null;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    public JsonValue get(Object key) {
        return this.values.get(key);
    }

    public JsonValue put(String key, JsonValue value) {
        return this.values.put(key, value);
    }

    public JsonValue remove(Object key) {
        return this.values.remove(key);
    }

    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        this.values.putAll(m);
    }

    public void clear() {
        this.values.clear();
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public Collection<JsonValue> values() {
        return this.values.values();
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.values.entrySet();
    }

    public JsonValue getOrDefault(Object key, JsonValue defaultValue) {
        return this.values.getOrDefault(key, defaultValue);
    }

    public void forEach(BiConsumer<? super String, ? super JsonValue> action) {
        this.values.forEach(action);
    }

    public void replaceAll(BiFunction<? super String, ? super JsonValue, ? extends JsonValue> function) {
        this.values.replaceAll(function);
    }

    public JsonValue putIfAbsent(String key, JsonValue value) {
        return this.values.putIfAbsent(key, value);
    }

    public boolean remove(Object key, Object value) {
        return this.values.remove(key, value);
    }

    public boolean replace(String key, JsonValue oldValue, JsonValue newValue) {
        return this.values.replace(key, oldValue, newValue);
    }

    public JsonValue replace(String key, JsonValue value) {
        return this.values.replace(key, value);
    }

    public JsonValue computeIfAbsent(String key, Function<? super String, ? extends JsonValue> mappingFunction) {
        return this.values.computeIfAbsent(key, mappingFunction);
    }

    public JsonValue computeIfPresent(String key, BiFunction<? super String, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.values.computeIfPresent(key, remappingFunction);
    }

    public JsonValue compute(String key, BiFunction<? super String, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.values.compute(key, remappingFunction);
    }

    public JsonValue merge(String key, JsonValue value, BiFunction<? super JsonValue, ? super JsonValue, ? extends JsonValue> remappingFunction) {
        return this.values.merge(key, value, remappingFunction);
    }

    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return JSR353Bundle.toString((JsonValue)this);
    }
}

