/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import java.lang.reflect.Member;

public final class VisibilityFilter {
    private static final int JAVA_MODIFIERS = 4095;
    public static final VisibilityFilter ABSTRACT = new VisibilityFilter(1024);
    public static final VisibilityFilter PRIVATE = new VisibilityFilter(128, 256, 8);
    public static final VisibilityFilter ALL = new VisibilityFilter(new int[0]);
    public static final VisibilityFilter NONE = new VisibilityFilter(4095);
    public static final VisibilityFilter PROTECTED = new VisibilityFilter(128, 256, 8, 2);
    public static final VisibilityFilter PACKAGE_PUBLIC = new VisibilityFilter(128, 256, 8, 2, 4);
    private int filter = 0;

    public VisibilityFilter(int ... modifier) {
        for (int m : modifier) {
            if ((m & 0xFFF) == 0) {
                throw new IllegalArgumentException("One of the modifiers is not a standard java modifier.");
            }
            this.filter |= m;
        }
    }

    public final boolean isVisible(Member member) {
        return this.isVisible(member.getModifiers());
    }

    public final boolean isVisible(int modifiers) {
        return (modifiers & this.filter) == 0;
    }
}

