/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.certificado;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import lombok.Generated;

class AliasKeyManager
implements X509KeyManager {
    @Generated
    private static final Logger log = Logger.getLogger(AliasKeyManager.class.getName());
    private KeyStore ks;
    private String alias;
    private String password;

    @Override
    public String chooseClientAlias(String[] str, Principal[] principal, Socket socket) {
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String str, Principal[] principal, Socket socket) {
        return this.alias;
    }

    @Override
    public String[] getClientAliases(String str, Principal[] principal) {
        return new String[]{this.alias};
    }

    @Override
    public String[] getServerAliases(String str, Principal[] principal) {
        return new String[]{this.alias};
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certificates = this.ks.getCertificateChain(alias);
            X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
            System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
            return x509Certificates;
        }
        catch (KeyStoreException e) {
            log.severe("N\u00e3o foi poss\u00edvel carregar o keystore para o alias:" + alias);
            return new X509Certificate[0];
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.ks.getKey(alias, this.password == null ? null : this.password.toCharArray());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
    }

    @Generated
    public AliasKeyManager(KeyStore ks, String alias, String password) {
        this.ks = ks;
        this.alias = alias;
        this.password = password;
    }
}

