/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.certificado;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.KeyStoreService;
import br.com.swconsultoria.certificado.SocketFactoryDinamico;
import br.com.swconsultoria.certificado.TipoCertificadoEnum;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.certificado.util.DocumentoUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class CertificadoService {
    @Generated
    private static final Logger log = Logger.getLogger(CertificadoService.class.getName());
    private static final String SENHA_NAO_PODE_SER_NULA = "Senha n\u00e3o pode ser nula.";
    private static final String CERTIFICADO_NAO_PODE_SER_NULO = "Certificado n\u00e3o pode ser nulo.";
    private static final String ERRO_AO_CARREGAR_INFORMACOES_DO_CERTIFICADO = "Erro ao carregar informa\u00e7\u00f5es do certificado:";
    private static boolean cacertProprio;

    private CertificadoService() {
    }

    public static void inicializaCertificado(Certificado certificado) throws CertificadoException {
        cacertProprio = true;
        CertificadoService.inicializaCertificado(certificado, CertificadoService.class.getResourceAsStream("/cacert"));
    }

    public static void inicializaCertificado(Certificado certificado, InputStream cacert) throws CertificadoException {
        if (certificado == null) {
            throw new IllegalArgumentException(CERTIFICADO_NAO_PODE_SER_NULO);
        }
        if (!certificado.isModoMultithreading()) {
            Protocol.registerProtocol((String)"https", (Protocol)CertificadoService.getProtocoloCertificado(certificado, cacert));
        }
        log.info(String.format("JAVA-CERTIFICADO | Samuel Oliveira | samuel@swconsultoria.com.br | VERSAO=%s | DATA_VERSAO=%s | CNPJ/CPF=%s | VENCIMENTO=%s | ALIAS=%s | TIPO=%s | CAMINHO=%s | CACERT=%s | SSL=%s | Multithreading=%s", "3.12", "06/07/2025", certificado.getCnpjCpf(), certificado.getDataHoraVencimento(), certificado.getNome().toUpperCase(), certificado.getTipoCertificado().toString(), certificado.getArquivo(), cacertProprio ? "Default" : "Customizado", certificado.getSslProtocol(), certificado.isModoMultithreading()));
    }

    public static Certificado certificadoPfxBytes(byte[] certificadoBytes, String senha) throws CertificadoException {
        Certificado certificado = new Certificado();
        try {
            certificado.setArquivoBytes(Optional.ofNullable(certificadoBytes).orElseThrow(() -> new IllegalArgumentException(CERTIFICADO_NAO_PODE_SER_NULO)));
            certificado.setSenha(Optional.ofNullable(senha).orElseThrow(() -> new IllegalArgumentException(SENHA_NAO_PODE_SER_NULA)));
            certificado.setTipoCertificado(TipoCertificadoEnum.ARQUIVO_BYTES);
            CertificadoService.setDadosCertificado(certificado, null);
        }
        catch (KeyStoreException e) {
            throw new CertificadoException(ERRO_AO_CARREGAR_INFORMACOES_DO_CERTIFICADO + e.getMessage(), e);
        }
        return certificado;
    }

    private static void setDadosCertificado(Certificado certificado, KeyStore keyStore) throws CertificadoException, KeyStoreException {
        if (keyStore == null) {
            keyStore = CertificadoService.getKeyStore(certificado);
            Enumeration<String> aliasEnum = keyStore.aliases();
            String aliasKey = aliasEnum.nextElement();
            certificado.setNome(aliasKey);
        }
        X509Certificate certificate = CertificadoService.getCertificate(certificado, keyStore);
        certificado.setCnpjCpf(Optional.ofNullable(certificate.getExtensionValue("2.5.29.17")).flatMap(DocumentoUtil::getDocumentoFromCertificado).orElse(""));
        Date dataValidade = CertificadoService.dataValidade(certificate);
        certificado.setVencimento(dataValidade.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        certificado.setDataHoraVencimento(dataValidade.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        certificado.setDiasRestantes(CertificadoService.diasRestantes(certificado));
        certificado.setValido(CertificadoService.valido(certificado));
        certificado.setNumeroSerie(certificate.getSerialNumber());
    }

    public static Certificado certificadoPfx(String caminhoCertificado, String senha) throws CertificadoException, FileNotFoundException {
        if (!Files.exists(Paths.get(Optional.ofNullable(caminhoCertificado).orElseThrow(() -> new IllegalArgumentException("Caminho do Certificado n\u00e3o pode ser nulo.")), new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Arquivo " + caminhoCertificado + " n\u00e3o existe");
        }
        Certificado certificado = new Certificado();
        try {
            certificado.setArquivo(caminhoCertificado);
            certificado.setSenha(Optional.ofNullable(senha).orElseThrow(() -> new IllegalArgumentException(SENHA_NAO_PODE_SER_NULA)));
            certificado.setTipoCertificado(TipoCertificadoEnum.ARQUIVO);
            CertificadoService.setDadosCertificado(certificado, null);
        }
        catch (KeyStoreException e) {
            throw new CertificadoException(ERRO_AO_CARREGAR_INFORMACOES_DO_CERTIFICADO + e.getMessage(), e);
        }
        return certificado;
    }

    public static Certificado certificadoA3(String senha, Provider provider) throws CertificadoException {
        try {
            Certificado certificado = new Certificado();
            certificado.setTipoCertificado(TipoCertificadoEnum.TOKEN_A3);
            certificado.setSenha(Optional.ofNullable(senha).orElseThrow(() -> new IllegalArgumentException(SENHA_NAO_PODE_SER_NULA)));
            certificado.setProvider(Optional.ofNullable(provider).orElseThrow(() -> new IllegalArgumentException("Provider n\u00e3o pode ser nulo.")));
            CertificadoService.setDadosCertificado(certificado, null);
            return certificado;
        }
        catch (Exception e) {
            throw new CertificadoException(ERRO_AO_CARREGAR_INFORMACOES_DO_CERTIFICADO + e.getMessage(), e);
        }
    }

    public static List<Certificado> listaCertificadosWindows(boolean listarVencidos) throws CertificadoException {
        return CertificadoService.listaCertificadosRepositorio(TipoCertificadoEnum.REPOSITORIO_WINDOWS, listarVencidos);
    }

    public static List<Certificado> listaCertificadosMac(boolean listarVencidos) throws CertificadoException {
        return CertificadoService.listaCertificadosRepositorio(TipoCertificadoEnum.REPOSITORIO_MAC, listarVencidos);
    }

    public static List<Certificado> listaCertificadosWindows() throws CertificadoException {
        return CertificadoService.listaCertificadosRepositorio(TipoCertificadoEnum.REPOSITORIO_WINDOWS, true);
    }

    public static List<Certificado> listaCertificadosMac() throws CertificadoException {
        return CertificadoService.listaCertificadosRepositorio(TipoCertificadoEnum.REPOSITORIO_MAC, true);
    }

    private static List<Certificado> listaCertificadosRepositorio(TipoCertificadoEnum tipo, boolean listarVencidos) throws CertificadoException {
        ArrayList<Certificado> listaCert = new ArrayList<Certificado>();
        Certificado cert = new Certificado();
        cert.setTipoCertificado(tipo);
        try {
            KeyStore ks = CertificadoService.getKeyStore(cert);
            Enumeration<String> aliasEnum = ks.aliases();
            while (aliasEnum.hasMoreElements()) {
                String aliasKey = aliasEnum.nextElement();
                if (aliasKey == null) continue;
                Certificado certificado = new Certificado();
                certificado.setTipoCertificado(tipo);
                certificado.setNome(aliasKey);
                CertificadoService.setDadosCertificado(certificado, ks);
                if (listarVencidos) {
                    listaCert.add(certificado);
                    continue;
                }
                if (!certificado.isValido()) continue;
                listaCert.add(certificado);
            }
        }
        catch (KeyStoreException ex) {
            throw new CertificadoException("Erro ao Carregar Certificados:" + ex.getMessage(), ex);
        }
        return listaCert;
    }

    public static List<String> listaAliasCertificadosA3(String senha, Provider provider) throws CertificadoException {
        try {
            ArrayList<String> listaCert = new ArrayList<String>(20);
            Certificado certificado = new Certificado();
            certificado.setTipoCertificado(TipoCertificadoEnum.TOKEN_A3);
            certificado.setSenha(Optional.ofNullable(senha).orElseThrow(() -> new IllegalArgumentException(SENHA_NAO_PODE_SER_NULA)));
            certificado.setProvider(Optional.ofNullable(provider).orElseThrow(() -> new IllegalArgumentException("Provider n\u00e3o pode ser nulo.")));
            Enumeration<String> aliasEnum = CertificadoService.getKeyStore(certificado).aliases();
            while (aliasEnum.hasMoreElements()) {
                String aliasKey = aliasEnum.nextElement();
                if (aliasKey == null) continue;
                listaCert.add(aliasKey);
            }
            return listaCert;
        }
        catch (KeyStoreException ex) {
            throw new CertificadoException("Erro ao Carregar Certificados A3:" + ex.getMessage(), ex);
        }
    }

    private static Date dataValidade(X509Certificate certificate) {
        return Optional.ofNullable(certificate.getNotAfter()).orElse(Date.from(LocalDate.of(2020, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant()));
    }

    private static Long diasRestantes(Certificado certificado) {
        return LocalDate.now().until(certificado.getVencimento(), ChronoUnit.DAYS);
    }

    private static boolean valido(Certificado certificado) {
        return LocalDate.now().isBefore(certificado.getVencimento());
    }

    public static X509Certificate getCertificate(Certificado certificado, KeyStore keystore) throws CertificadoException {
        try {
            return (X509Certificate)keystore.getCertificate(certificado.getNome());
        }
        catch (KeyStoreException e) {
            throw new CertificadoException("Erro Ao pegar X509Certificate: " + e.getMessage(), e);
        }
    }

    public static KeyStore getKeyStore(Certificado certificado) throws CertificadoException {
        try {
            switch (certificado.getTipoCertificado()) {
                case REPOSITORIO_WINDOWS: {
                    return KeyStoreService.getKeyStoreRepositorioWindows();
                }
                case REPOSITORIO_MAC: {
                    return KeyStoreService.getKeyStoreRepositorioMac();
                }
                case ARQUIVO: {
                    return KeyStoreService.getKeyStoreArquivo(certificado);
                }
                case ARQUIVO_BYTES: {
                    return KeyStoreService.getKeyStoreArquivoByte(certificado.getArquivoBytes(), certificado);
                }
                case TOKEN_A3: {
                    return KeyStoreService.getKeyStoreA3(certificado);
                }
            }
            throw new CertificadoException("Tipo de certificado n\u00e3o Configurado: " + (Object)((Object)certificado.getTipoCertificado()));
        }
        catch (Exception e) {
            if (Optional.ofNullable(e.getMessage()).orElse("").startsWith("keystore password was incorrect")) {
                throw new CertificadoException("Senha do Certificado inv\u00e1lida.");
            }
            throw new CertificadoException("Erro Ao pegar KeyStore: " + e.getMessage(), e);
        }
    }

    public static Certificado getCertificadoByCnpjCpf(String cnpjCpf) throws CertificadoException {
        return CertificadoService.listaCertificadosWindows().stream().filter(cert -> Optional.ofNullable(cert.getCnpjCpf()).orElse("").startsWith(cnpjCpf)).findFirst().orElseThrow(() -> new CertificadoException("Certificado n\u00e3o encontrado com CNPJ/CPF : " + cnpjCpf));
    }

    private static Protocol getProtocoloCertificado(Certificado certificado, InputStream cacert) throws CertificadoException {
        try {
            KeyStore keyStore = CertificadoService.getKeyStore(Optional.ofNullable(certificado).orElseThrow(() -> new IllegalArgumentException(CERTIFICADO_NAO_PODE_SER_NULO)));
            SocketFactoryDinamico socketFactory = new SocketFactoryDinamico(keyStore, certificado.getNome(), certificado.getSenha(), Optional.ofNullable(cacert).orElseThrow(() -> new IllegalArgumentException("Cacert n\u00e3o pode ser nulo.")), certificado.getSslProtocol());
            return new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new CertificadoException(e.getMessage(), e);
        }
    }

    public static HttpClient getHttpsClient(Certificado certificado, String url) throws CertificadoException {
        return CertificadoService.getHttpsClient(certificado, url, CertificadoService.class.getResourceAsStream("/cacert"));
    }

    public static HttpClient getHttpsClient(Certificado certificado, String url, InputStream cacert) throws CertificadoException {
        Protocol protocol = CertificadoService.getProtocoloCertificado(certificado, cacert);
        HttpClient httpclient = new HttpClient();
        httpclient.getHostConfiguration().setHost(url, 443, protocol);
        return httpclient;
    }
}

