/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.certificado.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CacertUtil {
    private static final int TIMEOUT_WS = 30;
    private static final int PORTA = 443;
    private static final String DESTINO_CACERT = "cacert";
    private static final String PASTA_JAVA = "C:/Program Files/Java/jdk1.8.0_301";
    private static final String SENHA_PADRAO_CACERT = "changeit";

    public static void main(String[] args) {
        try {
            List<String> lista = CacertUtil.listaPadraoWebService();
            char[] senha = SENHA_PADRAO_CACERT.toCharArray();
            File arquivoCacert = new File("C:/Program Files/Java/jdk1.8.0_301/jre/lib/security/cacerts");
            InputStream in = Files.newInputStream(arquivoCacert.toPath(), new OpenOption[0]);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, senha);
            in.close();
            lista.forEach(endereco -> CacertUtil.get(endereco, ks));
            OutputStream out = Files.newOutputStream(Paths.get(DESTINO_CACERT, new String[0]), new OpenOption[0]);
            ks.store(out, senha);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void get(String host, KeyStore ks) {
        try {
            System.out.println("Info: Capturando ca: " + host);
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(host, 443);
            socket.setSoTimeout(30000);
            try {
                socket.startHandshake();
                socket.close();
            }
            catch (SSLHandshakeException sSLHandshakeException) {
            }
            catch (SSLException e) {
                System.err.println("Erro: " + host + "| " + e.toString());
            }
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                System.err.println("Erro: | N\u00e3o pode obter cadeia de certificados: " + host);
            } else {
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                for (int i = 0; i < chain.length; ++i) {
                    X509Certificate cert = chain[i];
                    sha1.update(cert.getEncoded());
                    md5.update(cert.getEncoded());
                    String alias = host + "-" + i;
                    ks.setCertificateEntry(alias, cert);
                }
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException e) {
            System.err.println("Erro: " + host + "| " + e.toString());
        }
    }

    private static List<String> listaPadraoWebService() {
        ArrayList<String> listaWebServices = new ArrayList<String>();
        listaWebServices.add("homnfe.sefaz.am.gov.br");
        listaWebServices.add("hnfe.sefaz.ba.gov.br");
        listaWebServices.add("nfeh.sefaz.ce.gov.br");
        listaWebServices.add("app.sefaz.es.gov.br");
        listaWebServices.add("homolog.sefaz.go.gov.br");
        listaWebServices.add("sistemas.sefaz.ma.gov.br");
        listaWebServices.add("hnfe.fazenda.mg.gov.br");
        listaWebServices.add("hom.nfe.sefaz.ms.gov.br");
        listaWebServices.add("homologacao.sefaz.mt.gov.br");
        listaWebServices.add("nfehomolog.sefaz.pe.gov.br");
        listaWebServices.add("homologacao.nfe.sefa.pr.gov.br");
        listaWebServices.add("nfe-homologacao.sefazrs.rs.gov.br");
        listaWebServices.add("cad.sefazrs.rs.gov.br");
        listaWebServices.add("homologacao.nfe.fazenda.sp.gov.br");
        listaWebServices.add("hom.sefazvirtual.fazenda.gov.br");
        listaWebServices.add("nfe-homologacao.svrs.rs.gov.br");
        listaWebServices.add("cad.svrs.rs.gov.br");
        listaWebServices.add("hom.svc.fazenda.gov.br");
        listaWebServices.add("hom.nfe.fazenda.gov.br");
        listaWebServices.add("nfe.sefaz.am.gov.br");
        listaWebServices.add("nfe.sefaz.ba.gov.br");
        listaWebServices.add("nfe.sefaz.ce.gov.br");
        listaWebServices.add("nfe.sefaz.go.gov.br");
        listaWebServices.add("nfe.fazenda.mg.gov.br");
        listaWebServices.add("nfe.sefaz.ms.gov.br");
        listaWebServices.add("nfe.sefaz.mt.gov.br");
        listaWebServices.add("nfe.sefaz.pe.gov.br");
        listaWebServices.add("nfe.sefa.pr.gov.br");
        listaWebServices.add("nfe.sefazrs.rs.gov.br");
        listaWebServices.add("nfe.fazenda.sp.gov.br");
        listaWebServices.add("www.sefazvirtual.fazenda.gov.br");
        listaWebServices.add("nfe.svrs.rs.gov.br");
        listaWebServices.add("www.svc.fazenda.gov.br");
        listaWebServices.add("www.nfe.fazenda.gov.br");
        listaWebServices.add("www1.nfe.fazenda.gov.br");
        listaWebServices.add("homnfce.sefaz.am.gov.br");
        listaWebServices.add("nfceh.sefaz.ce.gov.br");
        listaWebServices.add("hom.nfce.sefaz.ms.gov.br");
        listaWebServices.add("hnfce.fazenda.mg.gov.br");
        listaWebServices.add("nfcehomolog.sefaz.pe.gov.br");
        listaWebServices.add("homologacao.nfce.sefa.pr.gov.br");
        listaWebServices.add("nfce-homologacao.sefazrs.rs.gov.br");
        listaWebServices.add("homologacao.nfce.fazenda.sp.gov.br");
        listaWebServices.add("nfce-homologacao.svrs.rs.gov.br");
        listaWebServices.add("nfce.sefaz.am.gov.br");
        listaWebServices.add("nfce.sefaz.ms.gov.br");
        listaWebServices.add("nfce.fazenda.mg.gov.br");
        listaWebServices.add("nfce.sefaz.mt.gov.br");
        listaWebServices.add("nfce.sefaz.pe.gov.br");
        listaWebServices.add("nfce.sefa.pr.gov.br");
        listaWebServices.add("nfce.sefazrs.rs.gov.br");
        listaWebServices.add("nfce.fazenda.sp.gov.br");
        listaWebServices.add("nfce.svrs.rs.gov.br");
        listaWebServices.add("hcte.fazenda.mg.gov.br");
        listaWebServices.add("homologacao.cte.ms.gov.br");
        listaWebServices.add("homologacao.cte.fazenda.pr.gov.br");
        listaWebServices.add("cte-homologacao.svrs.rs.gov.br");
        listaWebServices.add("hom1.cte.fazenda.gov.br");
        listaWebServices.add("cte.fazenda.mg.gov.br");
        listaWebServices.add("producao.cte.ms.gov.br");
        listaWebServices.add("cte.sefaz.mt.gov.br");
        listaWebServices.add("cte.fazenda.pr.gov.br");
        listaWebServices.add("cte.svrs.rs.gov.br");
        listaWebServices.add("www1.cte.fazenda.gov.br");
        listaWebServices.add("mdfe-homologacao.svrs.rs.gov.br");
        listaWebServices.add("mdfe.svrs.rs.gov.br");
        listaWebServices.add("webservices.producaorestrita.esocial.gov.br");
        listaWebServices.add("webservices.download.esocial.gov.br");
        listaWebServices.add("webservices.consulta.esocial.gov.br");
        listaWebServices.add("webservices.envio.esocial.gov.br");
        listaWebServices.add("preprodefdreinf.receita.fazenda.gov.br");
        listaWebServices.add("reinf.receita.fazenda.gov.br");
        listaWebServices.add("wshomo.pelotas.rs.gov.br");
        listaWebServices.add("ws.pelotas.rs.gov.br");
        listaWebServices.add("wshomo.pelotas.rs.gov.br");
        listaWebServices.add("ws.pelotas.rs.gov.br");
        listaWebServices.add("tributacao.vilavelha.es.gov.br");
        listaWebServices.add("serra.es.gov.br");
        listaWebServices.add("isscuritiba.curitiba.pr.gov.br");
        return listaWebServices;
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

