/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.Evento;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.EventosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema.envcce.TEnvEvento;
import br.com.swconsultoria.nfe.schema.envcce.TEvento;
import br.com.swconsultoria.nfe.schema.envcce.TProcEvento;
import br.com.swconsultoria.nfe.schema.envcce.TRetEnvEvento;
import br.com.swconsultoria.nfe.util.ChaveUtil;
import br.com.swconsultoria.nfe.util.ConfiguracoesUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CartaCorrecaoUtil {
    private CartaCorrecaoUtil() {
    }

    public static TEnvEvento montaCCe(Evento cce, ConfiguracoesNfe configuracao) throws NfeException {
        return CartaCorrecaoUtil.montaCCe(Collections.singletonList(cce), configuracao);
    }

    public static TEnvEvento montaCCe(List<Evento> listaCCe, ConfiguracoesNfe configuracao) throws NfeException {
        if (listaCCe.size() > 20) {
            throw new NfeException("Podem ser enviados no m\u00e1ximo 20 eventos no Lote.");
        }
        TEnvEvento envEvento = new TEnvEvento();
        envEvento.setVersao("1.00");
        envEvento.setIdLote("1");
        listaCCe.forEach(cce -> {
            String id = "ID" + EventosEnum.CCE.getCodigo() + cce.getChave() + ChaveUtil.completarComZerosAEsquerda(String.valueOf(cce.getSequencia()), 2);
            TEvento evento = new TEvento();
            evento.setVersao("1.00");
            TEvento.InfEvento infEvento = new TEvento.InfEvento();
            infEvento.setId(id);
            infEvento.setCOrgao(configuracao.getEstado().getCodigoUF());
            infEvento.setTpAmb(configuracao.getAmbiente().getCodigo());
            infEvento.setCPF(cce.getCpf());
            infEvento.setCNPJ(cce.getCnpj());
            infEvento.setChNFe(cce.getChave());
            infEvento.setDhEvento(XmlNfeUtil.dataNfe(cce.getDataEvento(), configuracao.getZoneId()));
            infEvento.setTpEvento(EventosEnum.CCE.getCodigo());
            infEvento.setNSeqEvento(String.valueOf(cce.getSequencia()));
            infEvento.setVerEvento("1.00");
            TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
            detEvento.setVersao("1.00");
            detEvento.setDescEvento("Carta de Correcao");
            detEvento.setXCorrecao(cce.getMotivo());
            detEvento.setXCondUso("A Carta de Correcao e disciplinada pelo paragrafo 1o-A do art. 7o do Convenio S/N, de 15 de dezembro de 1970 e pode ser utilizada para regularizacao de erro ocorrido na emissao de documento fiscal, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da operacao ou da prestacao; II - a correcao de dados cadastrais que implique mudanca do remetente ou do destinatario; III - a data de emissao ou de saida.");
            infEvento.setDetEvento(detEvento);
            evento.setInfEvento(infEvento);
            envEvento.getEvento().add(evento);
        });
        return envEvento;
    }

    public static String criaProcEventoCCe(ConfiguracoesNfe config, TEnvEvento enviEvento, TRetEnvEvento retorno) throws JAXBException, NfeException {
        String xml = XmlNfeUtil.objectToXml(enviEvento, config.getEncode());
        xml = xml.replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "").replace("<evento v", "<evento xmlns=\"http://www.portalfiscal.inf.br/nfe\" v");
        String assinado = Assinar.assinaNfe(ConfiguracoesUtil.iniciaConfiguracoes(config), xml, AssinaturaEnum.EVENTO);
        TProcEvento procEvento = new TProcEvento();
        procEvento.setEvento(XmlNfeUtil.xmlToObject(assinado, TEnvEvento.class).getEvento().get(0));
        procEvento.setRetEvento(retorno.getRetEvento().get(0));
        procEvento.setVersao("1.00");
        return XmlNfeUtil.objectToXml(procEvento, config.getEncode());
    }
}

