/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.ConsultaTributacao;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dto.ClassificacaoTributariaDTO;
import br.com.swconsultoria.nfe.dto.CstDTO;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TCIBS;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TIBSCBSMonoTot;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TRed;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TTribNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TTribRegular;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.XmlImpostoUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.xml.bind.JAXBElement;
import lombok.NonNull;

public class IbsCbsUtil {
    private static final String TOTAL_BC_IBS_CBS = "TOTAL_BC_IBS_CBS";
    private static final String TOTAL_IBS_UF = "TOTAL_IBS_UF";
    private static final String TOTAL_IBS_MUN = "TOTAL_IBS_MUN";
    private static final String TOTAL_CBS = "TOTAL_CBS";
    private static final BigDecimal CEM = BigDecimal.valueOf(100L);
    private static final int SCALE_5 = 5;
    private final List<CstDTO> listaCstIbsCbs;
    private final DocumentoEnum documento;
    private final Map<String, BigDecimal> mapTotais = new HashMap<String, BigDecimal>();
    private ClassificacaoTributariaDTO classTribIbsCbs;
    private CstDTO cstIbsCbs;
    private ClassificacaoTributariaDTO classTribIbsCbsTribRegular;
    private CstDTO cstIbsCbsTribRegular;
    private BigDecimal pAliqIbsUf = new BigDecimal("0.1");
    private BigDecimal pAliqIbsMun = BigDecimal.ZERO;
    private BigDecimal pAliqCbs = new BigDecimal("0.9");
    private BigDecimal baseCalculo = BigDecimal.ZERO;

    public void setpAliqIbsUf(BigDecimal pAliqIbsUf) {
        this.pAliqIbsUf = pAliqIbsUf;
    }

    public void setpAliqIbsMun(BigDecimal pAliqIbsMun) {
        this.pAliqIbsMun = pAliqIbsMun;
    }

    public void setpAliqCbs(BigDecimal pAliqCbs) {
        this.pAliqCbs = pAliqCbs;
    }

    public IbsCbsUtil(@NonNull List<CstDTO> listaCstIbsCbs, @NonNull DocumentoEnum documento) {
        if (listaCstIbsCbs == null) {
            throw new NullPointerException("listaCstIbsCbs is marked non-null but is null");
        }
        if (documento == null) {
            throw new NullPointerException("documento is marked non-null but is null");
        }
        this.listaCstIbsCbs = listaCstIbsCbs;
        this.documento = documento;
        this.inicializarTotais();
    }

    public IbsCbsUtil(@NonNull String json, @NonNull DocumentoEnum documento) throws NfeException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (documento == null) {
            throw new NullPointerException("documento is marked non-null but is null");
        }
        this.listaCstIbsCbs = ConsultaTributacao.convertJsonToObject(json, new TypeReference<List<CstDTO>>(){});
        this.documento = documento;
        this.inicializarTotais();
    }

    private void inicializarTotais() {
        this.mapTotais.put(TOTAL_BC_IBS_CBS, BigDecimal.ZERO);
        this.mapTotais.put(TOTAL_IBS_UF, BigDecimal.ZERO);
        this.mapTotais.put(TOTAL_IBS_MUN, BigDecimal.ZERO);
        this.mapTotais.put(TOTAL_CBS, BigDecimal.ZERO);
    }

    public TTribNFe montaImpostosDet(String cclassTrib, TNFe.InfNFe.Det det) throws NfeException {
        return this.montaImpostosDet(cclassTrib, det, null);
    }

    public TTribNFe montaImpostosDet(String cclassTrib, TNFe.InfNFe.Det det, String cclassTribRegular) throws NfeException {
        this.filtraCClasstrib(cclassTrib, cclassTribRegular);
        this.validaClassTrib(cclassTrib);
        this.calcularBaseCalculoIBSCBS(det);
        TTribNFe ibsCbs = new TTribNFe();
        ibsCbs.setCST(this.cstIbsCbs.getCst());
        ibsCbs.setCClassTrib(this.classTribIbsCbs.getCClassTrib());
        if (this.deveMontarGrupoIBSCBS()) {
            ibsCbs.setGIBSCBS(this.montarGrupoIBSCBS());
        }
        return ibsCbs;
    }

    private boolean deveMontarGrupoIBSCBS() {
        return Boolean.TRUE.equals(this.cstIbsCbs.getIndIBSCBS()) && (this.cstIbsCbs.getIndIBSCBSMono() != false || this.cstIbsCbs.getIndDif() != false || this.cstIbsCbs.getIndTransfCred() != false || this.classTribIbsCbs.getIndRedutorBC() != false);
    }

    private TCIBS montarGrupoIBSCBS() {
        TCIBS gIBSCBS = new TCIBS();
        gIBSCBS.setVBC(ObjetoUtil.getValor2Casas(this.baseCalculo));
        TCIBS.GIBSUF gIBSUF = this.criarGIBSUF();
        TCIBS.GIBSMun gIBSMun = this.criarGIBSMun();
        TCIBS.GCBS gCBS = this.criarGCBS();
        gIBSCBS.setGIBSUF(gIBSUF);
        gIBSCBS.setGIBSMun(gIBSMun);
        gIBSCBS.setGCBS(gCBS);
        gIBSCBS.setVIBS(ObjetoUtil.getValor2Casas(new BigDecimal(gIBSUF.getVIBSUF()).add(new BigDecimal(gIBSMun.getVIBSMun()))));
        if (Boolean.TRUE.equals(this.classTribIbsCbs.getIndTribRegular())) {
            gIBSCBS.setGTribRegular(this.criarGTribRegular());
        }
        this.atualizarTotais(gIBSUF, gIBSMun, gCBS);
        return gIBSCBS;
    }

    private void atualizarTotais(TCIBS.GIBSUF gIBSUF, TCIBS.GIBSMun gIBSMun, TCIBS.GCBS gCBS) {
        this.mapTotais.merge(TOTAL_BC_IBS_CBS, this.baseCalculo, BigDecimal::add);
        this.mapTotais.merge(TOTAL_IBS_UF, new BigDecimal(gIBSUF.getVIBSUF()), BigDecimal::add);
        this.mapTotais.merge(TOTAL_IBS_MUN, new BigDecimal(gIBSMun.getVIBSMun()), BigDecimal::add);
        this.mapTotais.merge(TOTAL_CBS, new BigDecimal(gCBS.getVCBS()), BigDecimal::add);
    }

    private void filtraCClasstrib(String cclassTrib, String cclassTribRegular) {
        this.buscarCstEClassificacao(cclassTrib).ifPresent(entry -> {
            this.cstIbsCbs = (CstDTO)entry.getKey();
            this.classTribIbsCbs = (ClassificacaoTributariaDTO)entry.getValue();
        });
        if (cclassTribRegular != null && !cclassTribRegular.isEmpty()) {
            this.buscarCstEClassificacao(cclassTribRegular).ifPresent(entry -> {
                this.cstIbsCbsTribRegular = (CstDTO)entry.getKey();
                this.classTribIbsCbsTribRegular = (ClassificacaoTributariaDTO)entry.getValue();
            });
        }
    }

    private Optional<AbstractMap.SimpleEntry<CstDTO, ClassificacaoTributariaDTO>> buscarCstEClassificacao(String cclassTrib) {
        return this.listaCstIbsCbs.stream().flatMap(cst -> cst.getClassificacoesTributarias().stream().map(classTrib -> new AbstractMap.SimpleEntry<CstDTO, ClassificacaoTributariaDTO>((CstDTO)cst, (ClassificacaoTributariaDTO)classTrib))).filter(entry -> ((ClassificacaoTributariaDTO)entry.getValue()).getCClassTrib().equals(cclassTrib)).findFirst();
    }

    private void validaClassTrib(String cclassTrib) throws NfeException {
        if (this.classTribIbsCbs == null) {
            throw new NfeException("CClassTrib inv\u00e1lido ou n\u00e3o encontrado: " + cclassTrib);
        }
        if (this.documento.equals((Object)DocumentoEnum.NFE) && Boolean.FALSE.equals(this.classTribIbsCbs.getIndNFe())) {
            throw new NfeException("CClassTrib n\u00e3o pode ser utilizado para NFe: " + cclassTrib);
        }
        if (this.documento.equals((Object)DocumentoEnum.NFCE) && Boolean.FALSE.equals(this.classTribIbsCbs.getIndNFCe())) {
            throw new NfeException("CClassTrib n\u00e3o pode ser utilizado para NFCe: " + cclassTrib);
        }
        if (Boolean.TRUE.equals(this.classTribIbsCbs.getIndTribRegular()) && this.classTribIbsCbsTribRegular == null) {
            throw new NfeException("Obrigat\u00f3rio informar Tributa\u00e7\u00e3o Regular para CClassTrib: " + cclassTrib);
        }
    }

    private TCIBS.GIBSUF criarGIBSUF() {
        return this.criarGrupoImposto(this.pAliqIbsUf, this.classTribIbsCbs.getPRedIBS(), TCIBS.GIBSUF::new, TCIBS.GIBSUF::setPIBSUF, TCIBS.GIBSUF::setGRed, TCIBS.GIBSUF::setVIBSUF);
    }

    private TCIBS.GIBSMun criarGIBSMun() {
        return this.criarGrupoImposto(this.pAliqIbsMun, this.classTribIbsCbs.getPRedIBS(), TCIBS.GIBSMun::new, TCIBS.GIBSMun::setPIBSMun, TCIBS.GIBSMun::setGRed, TCIBS.GIBSMun::setVIBSMun);
    }

    private TCIBS.GCBS criarGCBS() {
        return this.criarGrupoImposto(this.pAliqCbs, this.classTribIbsCbs.getPRedCBS(), TCIBS.GCBS::new, TCIBS.GCBS::setPCBS, TCIBS.GCBS::setGRed, TCIBS.GCBS::setVCBS);
    }

    private <T> T criarGrupoImposto(BigDecimal aliqPadrao, BigDecimal percentualReducao, GrupoImpostoFactory<T> factory, AliquotaSetter<T> aliqSetter, RedutorSetter<T> redSetter, ValorSetter<T> valorSetter) {
        T grupo = factory.create();
        BigDecimal aliq = Boolean.TRUE.equals(this.classTribIbsCbs.getIndTribRegular()) ? BigDecimal.ZERO : ObjetoUtil.getOrZero(aliqPadrao);
        aliqSetter.set(grupo, ObjetoUtil.getValor4Casas(aliq));
        BigDecimal percentRed = ObjetoUtil.getOrZero(percentualReducao);
        BigDecimal aliqEfet = aliq;
        if (Boolean.TRUE.equals(this.cstIbsCbs.getIndRedAliq()) && percentRed.compareTo(BigDecimal.ZERO) > 0 && Boolean.FALSE.equals(this.classTribIbsCbs.getIndTribRegular())) {
            TRed gRed = IbsCbsUtil.criarRedutor(percentRed, aliq);
            redSetter.set(grupo, gRed);
            aliqEfet = new BigDecimal(gRed.getPAliqEfet());
        }
        BigDecimal valor = this.calcularValorImposto(aliqEfet);
        valorSetter.set(grupo, ObjetoUtil.getValor2Casas(valor));
        return grupo;
    }

    private BigDecimal calcularValorImposto(BigDecimal aliquota) {
        return this.baseCalculo.multiply(aliquota.divide(CEM, 5, RoundingMode.HALF_UP));
    }

    private TTribRegular criarGTribRegular() {
        TTribRegular gTribRegular = new TTribRegular();
        gTribRegular.setCSTReg(this.cstIbsCbsTribRegular.getCst());
        gTribRegular.setCClassTribReg(this.classTribIbsCbsTribRegular.getCClassTrib());
        this.configurarTributoRegular(gTribRegular, this.pAliqIbsUf, TTribRegular::setPAliqEfetRegIBSUF, TTribRegular::setVTribRegIBSUF);
        this.configurarTributoRegular(gTribRegular, this.pAliqIbsMun, TTribRegular::setPAliqEfetRegIBSMun, TTribRegular::setVTribRegIBSMun);
        this.configurarTributoRegular(gTribRegular, this.pAliqCbs, TTribRegular::setPAliqEfetRegCBS, TTribRegular::setVTribRegCBS);
        return gTribRegular;
    }

    private void configurarTributoRegular(TTribRegular gTribRegular, BigDecimal aliquota, BiConsumer<TTribRegular, String> aliqSetter, BiConsumer<TTribRegular, String> valorSetter) {
        BigDecimal pAliqEfet = ObjetoUtil.getOrZero(aliquota);
        aliqSetter.accept(gTribRegular, ObjetoUtil.getValor4Casas(pAliqEfet));
        BigDecimal valor = this.calcularValorImposto(pAliqEfet);
        valorSetter.accept(gTribRegular, ObjetoUtil.getValor2Casas(valor));
    }

    private static TRed criarRedutor(BigDecimal percentualReducao, BigDecimal aliqOriginal) {
        TRed gRed = new TRed();
        gRed.setPRedAliq(ObjetoUtil.getValor4Casas(percentualReducao));
        BigDecimal aliqEfet = aliqOriginal.multiply(BigDecimal.ONE.subtract(percentualReducao.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP)));
        gRed.setPAliqEfet(ObjetoUtil.getValor4Casas(aliqEfet));
        return gRed;
    }

    private void calcularBaseCalculoIBSCBS(TNFe.InfNFe.Det det) {
        BigDecimal vProd = ObjetoUtil.getBigDecimalOrZero(det.getProd().getVProd());
        BigDecimal vFrete = ObjetoUtil.getBigDecimalOrZero(det.getProd().getVFrete());
        BigDecimal vSeg = ObjetoUtil.getBigDecimalOrZero(det.getProd().getVSeg());
        BigDecimal vOutro = ObjetoUtil.getBigDecimalOrZero(det.getProd().getVOutro());
        BigDecimal vDesc = ObjetoUtil.getBigDecimalOrZero(det.getProd().getVDesc());
        List<JAXBElement<?>> impostos = det.getImposto().getContent();
        this.baseCalculo = vProd.add(vFrete).add(vSeg).add(vOutro).subtract(vDesc).subtract(XmlImpostoUtil.getVPIS(impostos)).subtract(XmlImpostoUtil.getVCOFINS(impostos)).subtract(XmlImpostoUtil.getVICMS(impostos)).subtract(XmlImpostoUtil.getVICMSUFDest(impostos)).subtract(XmlImpostoUtil.getVFCP(impostos)).subtract(XmlImpostoUtil.getVFCPUFDest(impostos)).subtract(XmlImpostoUtil.getVICMSMono(impostos)).subtract(XmlImpostoUtil.getVISSQN(impostos));
    }

    public BigDecimal calculaVnfTot(String vnf) {
        return new BigDecimal(vnf).add(this.mapTotais.getOrDefault(TOTAL_IBS_UF, BigDecimal.ZERO)).add(this.mapTotais.getOrDefault(TOTAL_IBS_MUN, BigDecimal.ZERO)).add(this.mapTotais.getOrDefault(TOTAL_CBS, BigDecimal.ZERO));
    }

    public TIBSCBSMonoTot preencheTotaisIbsCsb() {
        TIBSCBSMonoTot totalIbsCbs = new TIBSCBSMonoTot();
        totalIbsCbs.setVBCIBSCBS(ObjetoUtil.getValor2Casas(this.mapTotais.getOrDefault(TOTAL_BC_IBS_CBS, BigDecimal.ZERO)));
        totalIbsCbs.setGIBS(this.criarTotaisIBS());
        totalIbsCbs.setGCBS(this.criarTotaisCBS());
        return totalIbsCbs;
    }

    private TIBSCBSMonoTot.GIBS criarTotaisIBS() {
        TIBSCBSMonoTot.GIBS gIbs = new TIBSCBSMonoTot.GIBS();
        gIbs.setGIBSUF(this.criarGIBSUFTotal());
        gIbs.setGIBSMun(this.criarGIBSMunTotal());
        BigDecimal totalIBS = this.mapTotais.getOrDefault(TOTAL_IBS_UF, BigDecimal.ZERO).add(this.mapTotais.getOrDefault(TOTAL_IBS_MUN, BigDecimal.ZERO));
        gIbs.setVIBS(ObjetoUtil.getValor2Casas(totalIBS));
        gIbs.setVCredPres("0.00");
        gIbs.setVCredPresCondSus("0.00");
        return gIbs;
    }

    private TIBSCBSMonoTot.GIBS.GIBSUF criarGIBSUFTotal() {
        TIBSCBSMonoTot.GIBS.GIBSUF gIbsUF = new TIBSCBSMonoTot.GIBS.GIBSUF();
        gIbsUF.setVDif("0.00");
        gIbsUF.setVDevTrib("0.00");
        gIbsUF.setVIBSUF(ObjetoUtil.getValor2Casas(this.mapTotais.getOrDefault(TOTAL_IBS_UF, BigDecimal.ZERO)));
        return gIbsUF;
    }

    private TIBSCBSMonoTot.GIBS.GIBSMun criarGIBSMunTotal() {
        TIBSCBSMonoTot.GIBS.GIBSMun gIbsMun = new TIBSCBSMonoTot.GIBS.GIBSMun();
        gIbsMun.setVDif("0.00");
        gIbsMun.setVDevTrib("0.00");
        gIbsMun.setVIBSMun(ObjetoUtil.getValor2Casas(this.mapTotais.getOrDefault(TOTAL_IBS_MUN, BigDecimal.ZERO)));
        return gIbsMun;
    }

    private TIBSCBSMonoTot.GCBS criarTotaisCBS() {
        TIBSCBSMonoTot.GCBS gCbs = new TIBSCBSMonoTot.GCBS();
        gCbs.setVDif("0.00");
        gCbs.setVDevTrib("0.00");
        gCbs.setVCBS(ObjetoUtil.getValor2Casas(this.mapTotais.getOrDefault(TOTAL_CBS, BigDecimal.ZERO)));
        gCbs.setVCredPres("0.00");
        gCbs.setVCredPresCondSus("0.00");
        return gCbs;
    }

    @FunctionalInterface
    private static interface ValorSetter<T> {
        public void set(T var1, String var2);
    }

    @FunctionalInterface
    private static interface RedutorSetter<T> {
        public void set(T var1, TRed var2);
    }

    @FunctionalInterface
    private static interface AliquotaSetter<T> {
        public void set(T var1, String var2);
    }

    @FunctionalInterface
    private static interface GrupoImpostoFactory<T> {
        public T create();
    }
}

