/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.schema_4.enviNFe.TNFe;
import java.math.BigDecimal;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class XmlImpostoUtil {
    private XmlImpostoUtil() {
    }

    public static BigDecimal getVPIS(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.PIS)) continue;
            TNFe.InfNFe.Det.Imposto.PIS pis = (TNFe.InfNFe.Det.Imposto.PIS)elem.getValue();
            if (pis.getPISAliq() != null && pis.getPISAliq().getVPIS() != null) {
                return new BigDecimal(pis.getPISAliq().getVPIS());
            }
            if (pis.getPISQtde() != null && pis.getPISQtde().getVPIS() != null) {
                return new BigDecimal(pis.getPISQtde().getVPIS());
            }
            if (pis.getPISOutr() == null || pis.getPISOutr().getVPIS() == null) continue;
            return new BigDecimal(pis.getPISOutr().getVPIS());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVCOFINS(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.COFINS)) continue;
            TNFe.InfNFe.Det.Imposto.COFINS cof = (TNFe.InfNFe.Det.Imposto.COFINS)elem.getValue();
            if (cof.getCOFINSAliq() != null && cof.getCOFINSAliq().getVCOFINS() != null) {
                return new BigDecimal(cof.getCOFINSAliq().getVCOFINS());
            }
            if (cof.getCOFINSQtde() != null && cof.getCOFINSQtde().getVCOFINS() != null) {
                return new BigDecimal(cof.getCOFINSQtde().getVCOFINS());
            }
            if (cof.getCOFINSOutr() == null || cof.getCOFINSOutr().getVCOFINS() == null) continue;
            return new BigDecimal(cof.getCOFINSOutr().getVCOFINS());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVICMS(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.ICMS)) continue;
            TNFe.InfNFe.Det.Imposto.ICMS icms = (TNFe.InfNFe.Det.Imposto.ICMS)elem.getValue();
            if (icms.getICMS00() != null && icms.getICMS00().getVICMS() != null) {
                return new BigDecimal(icms.getICMS00().getVICMS());
            }
            if (icms.getICMS10() != null && icms.getICMS10().getVICMS() != null) {
                return new BigDecimal(icms.getICMS10().getVICMS());
            }
            if (icms.getICMS20() != null && icms.getICMS20().getVICMS() != null) {
                return new BigDecimal(icms.getICMS20().getVICMS());
            }
            if (icms.getICMS51() != null && icms.getICMS51().getVICMS() != null) {
                return new BigDecimal(icms.getICMS51().getVICMS());
            }
            if (icms.getICMS90() != null && icms.getICMS90().getVICMS() != null) {
                return new BigDecimal(icms.getICMS90().getVICMS());
            }
            if (icms.getICMSSN900() == null || icms.getICMSSN900().getVICMS() == null) continue;
            return new BigDecimal(icms.getICMSSN900().getVICMS());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVICMSUFDest(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            TNFe.InfNFe.Det.Imposto.ICMSUFDest icmsUfDest;
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.ICMSUFDest) || (icmsUfDest = (TNFe.InfNFe.Det.Imposto.ICMSUFDest)elem.getValue()).getVICMSUFDest() == null) continue;
            return new BigDecimal(icmsUfDest.getVICMSUFDest());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVFCP(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.ICMS)) continue;
            TNFe.InfNFe.Det.Imposto.ICMS icms = (TNFe.InfNFe.Det.Imposto.ICMS)elem.getValue();
            if (icms.getICMS00() != null && icms.getICMS00().getVFCP() != null) {
                return new BigDecimal(icms.getICMS00().getVFCP());
            }
            if (icms.getICMS10() != null && icms.getICMS10().getVFCP() != null) {
                return new BigDecimal(icms.getICMS10().getVFCP());
            }
            if (icms.getICMS20() != null && icms.getICMS20().getVFCP() != null) {
                return new BigDecimal(icms.getICMS20().getVFCP());
            }
            if (icms.getICMS51() != null && icms.getICMS51().getVFCP() != null) {
                return new BigDecimal(icms.getICMS51().getVFCP());
            }
            if (icms.getICMS90() == null || icms.getICMS90().getVFCP() == null) continue;
            return new BigDecimal(icms.getICMS90().getVFCP());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVFCPUFDest(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            TNFe.InfNFe.Det.Imposto.ICMSUFDest icmsUfDest;
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.ICMSUFDest) || (icmsUfDest = (TNFe.InfNFe.Det.Imposto.ICMSUFDest)elem.getValue()).getVFCPUFDest() == null) continue;
            return new BigDecimal(icmsUfDest.getVFCPUFDest());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVICMSMono(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.ICMS)) continue;
            TNFe.InfNFe.Det.Imposto.ICMS icms = (TNFe.InfNFe.Det.Imposto.ICMS)elem.getValue();
            if (icms.getICMS02() != null && icms.getICMS02().getVICMSMono() != null) {
                return new BigDecimal(icms.getICMS02().getVICMSMono());
            }
            if (icms.getICMS15() != null && icms.getICMS15().getVICMSMono() != null) {
                return new BigDecimal(icms.getICMS15().getVICMSMono());
            }
            if (icms.getICMS53() == null || icms.getICMS53().getVICMSMono() == null) continue;
            return new BigDecimal(icms.getICMS53().getVICMSMono());
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getVISSQN(List<JAXBElement<?>> impostos) {
        for (JAXBElement<?> elem : impostos) {
            TNFe.InfNFe.Det.Imposto.ISSQN issqn;
            if (!(elem.getValue() instanceof TNFe.InfNFe.Det.Imposto.ISSQN) || (issqn = (TNFe.InfNFe.Det.Imposto.ISSQN)elem.getValue()).getVISSQN() == null) continue;
            return new BigDecimal(issqn.getVISSQN());
        }
        return BigDecimal.ZERO;
    }
}

