/*
 * Decompiled with CFR 0.152.
 */
package br.com.softwareexpress.sitef;

import br.com.softwareexpress.sitef.ICliSiTefListener;
import br.com.softwareexpress.sitef.JCliSiTefI;
import br.com.softwareexpress.sitef.modules.Barcode;
import br.com.softwareexpress.sitef.modules.FuncoesInternas;
import br.com.softwareexpress.sitef.modules.IBarcode;
import br.com.softwareexpress.sitef.modules.IPinPad;
import br.com.softwareexpress.sitef.modules.ISPTrans;
import br.com.softwareexpress.sitef.modules.ISocioTorcedor;
import br.com.softwareexpress.sitef.modules.IVidalink;
import br.com.softwareexpress.sitef.modules.PinPad;
import br.com.softwareexpress.sitef.modules.SPTrans;
import br.com.softwareexpress.sitef.modules.SocioTorcedor;
import br.com.softwareexpress.sitef.modules.Vidalink;

public class CliSiTef {
    public static final int CONFIG_OK = 0;
    public static final int CONFIG_ERROR_INVALID_SITEF_ADDRESS = 1;
    public static final int CONFIG_ERROR_INVALID_STORE_ID = 2;
    public static final int CONFIG_ERROR_INVALID_TERMINAL_ID = 3;
    public static final int CONFIG_ERROR_MISSING_COLLECT_FUNCTION = 4;
    public static final int CONFIG_ERROR_MISSING_RECEIVE_FUNCTION = 5;
    public static final int CONFIG_ERROR_TCPIP_SETUP = 6;
    public static final int CONFIG_ERROR_OUT_OF_MEMORY = 7;
    public static final int CONFIG_ERROR_CLISITEF_LIBRARY_NOT_FOUND = 8;
    public static final int CONFIG_ERROR_MAX_SITEF_IP_REACHED = 9;
    public static final int CONFIG_ERROR_INITIALIZING_FILES = 10;
    public static final int CONFIG_ERROR_INVALID_FIELD = 11;
    public static final int CONFIG_ERROR_SECURE_MODE = 12;
    public static final int CONFIG_ERROR_INVALID_PATH = 13;
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR_MODULE_NOT_INITIALIZED = -1;
    public static final int STATUS_ERROR_ABORTED_BY_OPERATOR = -2;
    public static final int STATUS_ERROR_INVALID_FUNCTION_CODE = -3;
    public static final int STATUS_ERROR_OUT_OF_MEMORY = -4;
    public static final int STATUS_ERROR_SITEF_SERVER_OFFLINE = -5;
    public static final int STATUS_ERROR_ABORTED_BY_CUSTOMER = -6;
    public static final int STATUS_ERROR_TLS = -7;
    public static final int STATUS_ERROR_FUNCTION_NOT_AVAILABLE = -8;
    public static final int STATUS_ERROR_INVALID_FUNCTION_CALL = -9;
    public static final int STATUS_ERROR_MISSING_PARAMETER = -10;
    public static final int STATUS_ERROR_MISSING_AMOUNT = -11;
    public static final int STATUS_ERROR_INTERACTIVE_PROCESS = -12;
    public static final int STATUS_ERROR_ABORTED_BY_APPLICATION = -15;
    public static final int STATUS_ERROR_INVALID_PARAMETER = -20;
    public static final int STATUS_ERROR_PINPAD_FORBIDDEN_WORD = -21;
    public static final int STATUS_ERROR_PINPAD_DEVICE = -43;
    public static final int FUNCTION_NOT_DEFINED = 0;
    public static final int FUNCTION_DEBIT = 2;
    public static final int FUNCTION_CREDIT = 3;
    public static final int FUNCTION_CPF_SEARCH = 61;
    public static final int FUNCTION_MANAGEMENT_MENU = 110;
    public static final int FUNCTION_COMMUNICATION_TEST = 111;
    public static final int FUNCTION_REPRINT_MENU = 112;
    public static final int FUNCTION_REPRINT_SPECIFIC_RECEIPT = 113;
    public static final int FUNCTION_REPRINT_LAST_RECEIPT = 114;
    public static final int FUNCTION_REFUND = 200;
    public static final int FUNCTION_PINPAD_INFORMATION = 775;
    private JCliSiTefI jclisitefi = new JCliSiTefI();
    private ICliSiTefListener listener;
    private FuncoesInternas funcInternas;
    public IPinPad pinpad;
    public IBarcode barcode;
    public ISocioTorcedor socioTorcedor;
    public IVidalink vidalink;
    public ISPTrans sptrans;
    private String currentFiscalDoc = null;
    private String currentFiscalDate = null;
    private String currentFiscalTime = null;

    public CliSiTef() {
        this(null);
    }

    private void criaObjetos() {
        this.funcInternas = new FuncoesInternas(this.jclisitefi, this.listener);
        this.pinpad = new PinPad(this.jclisitefi, this.funcInternas);
        this.barcode = new Barcode(this.jclisitefi);
        this.socioTorcedor = new SocioTorcedor(this.jclisitefi, this.funcInternas);
        this.sptrans = new SPTrans(this.jclisitefi);
        this.vidalink = new Vidalink(this.jclisitefi, this.funcInternas);
    }

    public CliSiTef(ICliSiTefListener iCliSiTefListener) {
        this.listener = iCliSiTefListener;
        this.criaObjetos();
    }

    public void setListener(ICliSiTefListener iCliSiTefListener) {
        this.listener = iCliSiTefListener;
        this.criaObjetos();
    }

    public int configure(String string, String string2, String string3) {
        return this.jclisitefi.configuraIntSiTefInterativo(string, string2, string3);
    }

    public int configure(String string, String string2, String string3, String string4) {
        return this.jclisitefi.configuraIntSiTefInterativoEx(string, string2, string3, string4 == null ? "" : string4);
    }

    public synchronized int startTransaction(int n, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        if (this.listener == null) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n2 = this.jclisitefi.iniciaFuncaoSiTefInterativo(n, string, string2, string3, string4, string5, string6 == null ? "" : string6);
        if (n2 == 10000) {
            this.currentFiscalDoc = string2;
            this.currentFiscalDate = string3;
            this.currentFiscalTime = string4;
            n2 = this.funcInternas.processoIterativo(n2);
        }
        return n2;
    }

    public synchronized int startBillPayment(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (this.listener == null) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n = this.jclisitefi.correspondenteBancarioSiTefInterativo(string, string2, string3, string4, string5 == null ? "" : string5);
        if (n == 10000) {
            this.currentFiscalDoc = string;
            this.currentFiscalDate = string2;
            this.currentFiscalTime = string3;
            n = this.funcInternas.processoIterativo(n);
        }
        return n;
    }

    @Deprecated
    public synchronized int startSelfServiceTransaction(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        if (this.listener == null) {
            throw new Exception("Listener not set through addCliSiTefListener().");
        }
        int n2 = this.jclisitefi.iniciaFuncaoAASiTefInterativo(n, string, string2, string3, string4, string5, string6 == null ? "" : string6, string7);
        if (n2 == 10000) {
            this.currentFiscalDoc = string2;
            this.currentFiscalDate = string3;
            this.currentFiscalTime = string4;
            n2 = this.funcInternas.processoIterativo(n2);
        }
        return n2;
    }

    public synchronized int finishTransaction(boolean bl) throws Exception {
        if (this.currentFiscalDoc == null || this.currentFiscalDate == null || this.currentFiscalTime == null) {
            throw new Exception("Last transaction made not found.");
        }
        int n = this.jclisitefi.finalizaFuncaoSiTefInterativo((short)(bl ? 1 : 0), this.currentFiscalDoc, this.currentFiscalDate, this.currentFiscalTime, "");
        n = this.funcInternas.processoIterativo(n);
        return n;
    }

    public synchronized int finishTransaction(boolean bl, String string, String string2, String string3) {
        int n = this.jclisitefi.finalizaFuncaoSiTefInterativo((short)(bl ? 1 : 0), string, string2, string3, "");
        n = this.funcInternas.processoIterativo(n);
        return n;
    }

    public int getQttPendingTransactions() throws Exception {
        if (this.currentFiscalDoc == null || this.currentFiscalDate == null) {
            throw new Exception("No transaction done previously.");
        }
        return this.jclisitefi.obtemQuantidadeTransacoesPendentes(this.currentFiscalDate, this.currentFiscalDoc);
    }

    public String getVersion() throws Exception {
        int n = this.jclisitefi.obtemVersao();
        if (n != 0) {
            throw new Exception("getVersion returned [" + n + "].");
        }
        return this.jclisitefi.getVersaoCliSiTef() + "/" + this.jclisitefi.getVersaoCliSiTefI();
    }

    public int submitPendingMessages() {
        return this.jclisitefi.descarregaMensagens();
    }

    public int getSettings(int n, String string) {
        return this.jclisitefi.obtemParametrosSiTef(n, string);
    }

    public int loadTranslationFile(String string) throws UnsatisfiedLinkError {
        return this.jclisitefi.carregaArquivosTraducao(string, string);
    }
}

