/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe;

import br.com.swconsultoria.mdfe.AssinaturaMdfe;
import br.com.swconsultoria.mdfe.ValidarMDFe;
import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TEvento;
import br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TRetEvento;
import br.com.swconsultoria.mdfe.util.ObjetoMdfeUtil;
import br.com.swconsultoria.mdfe.util.WebServiceMdfeUtil;
import br.com.swconsultoria.mdfe.util.XmlMdfeUtil;
import br.com.swconsultoria.mdfe.wsdl.MDFeRecepcaoEvento.MDFeRecepcaoEventoStub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class EventoMdfe {
    private static final Logger log = Logger.getLogger(EventoMdfe.class.getName());

    private EventoMdfe() {
    }

    static TRetEvento cancelar(ConfiguracoesMDFe configuracoes, TEvento evento2, boolean validar) throws MdfeException {
        try {
            String xml = XmlMdfeUtil.objectMdfeToXml(evento2);
            xml = EventoMdfe.evento(configuracoes, xml, validar);
            return XmlMdfeUtil.xmlToObject(xml, TRetEvento.class);
        }
        catch (JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    static br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TRetEvento incluirCondutor(ConfiguracoesMDFe configuracoes, br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TEvento evento2, boolean validar) throws MdfeException {
        try {
            String xml = XmlMdfeUtil.objectMdfeToXml(evento2);
            xml = EventoMdfe.evento(configuracoes, xml, validar);
            return XmlMdfeUtil.xmlToObject(xml, br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TRetEvento.class);
        }
        catch (JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    static br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TRetEvento incluirDFe(ConfiguracoesMDFe configuracoes, br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TEvento evento2, boolean validar) throws MdfeException {
        try {
            String xml = XmlMdfeUtil.objectMdfeToXml(evento2);
            xml = EventoMdfe.evento(configuracoes, xml, validar);
            return XmlMdfeUtil.xmlToObject(xml, br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TRetEvento.class);
        }
        catch (JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    static br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TRetEvento encerrar(ConfiguracoesMDFe configuracoes, br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TEvento evento2, boolean validar) throws MdfeException {
        try {
            String xml = XmlMdfeUtil.objectMdfeToXml(evento2);
            xml = EventoMdfe.evento(configuracoes, xml, validar);
            return XmlMdfeUtil.xmlToObject(xml, br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TRetEvento.class);
        }
        catch (JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    static br.com.swconsultoria.mdfe.schema_300.evPagtoOperMDFe.TRetEvento eventoPagamentoOper(ConfiguracoesMDFe configuracoes, br.com.swconsultoria.mdfe.schema_300.evPagtoOperMDFe.TEvento evento2, boolean validar) throws MdfeException {
        try {
            String xml = XmlMdfeUtil.objectMdfeToXml(evento2);
            xml = EventoMdfe.evento(configuracoes, xml, validar);
            return XmlMdfeUtil.xmlToObject(xml, br.com.swconsultoria.mdfe.schema_300.evPagtoOperMDFe.TRetEvento.class);
        }
        catch (JAXBException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    static String evento(ConfiguracoesMDFe configuracoes, String xml, boolean valida) throws MdfeException {
        try {
            String erros;
            xml = AssinaturaMdfe.assinar(configuracoes, xml, "eventoMDFe");
            if (valida && !ObjetoMdfeUtil.isEmpty(erros = ValidarMDFe.validaXml(configuracoes, xml, "MDFeRecepcaoEvento"))) {
                throw new MdfeException("Erro Na Valida\u00e7\u00e3o do Xml: " + erros);
            }
            log.info("[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            MDFeRecepcaoEventoStub.MdfeDadosMsg dadosMsg = new MDFeRecepcaoEventoStub.MdfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            MDFeRecepcaoEventoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeRecepcaoEventoStub.MdfeCabecMsg();
            mdfeCabecMsg.setCUF(String.valueOf(configuracoes.getEstado().getCodigoUF()));
            mdfeCabecMsg.setVersaoDados("3.00");
            MDFeRecepcaoEventoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeRecepcaoEventoStub.MdfeCabecMsgE();
            mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
            MDFeRecepcaoEventoStub stub = new MDFeRecepcaoEventoStub(WebServiceMdfeUtil.getUrl(configuracoes, "MDFeRecepcaoEvento"));
            return stub.mdfeRecepcaoEvento(dadosMsg, mdfeCabecMsgE).getExtraElement().toString();
        }
        catch (RemoteException | XMLStreamException e) {
            throw new MdfeException(e.getMessage());
        }
    }
}

