/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe;

import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.util.Valida;
import java.io.File;

class ValidarMDFe
extends Valida {
    ValidarMDFe() {
    }

    static String validaXml(ConfiguracoesMDFe configuracoes, String xml, String tipo) throws MdfeException {
        System.setProperty("jdk.xml.maxOccurLimit", "99999");
        switch (tipo) {
            case "MDFeStatusServico": {
                xsd = configuracoes.getPastaSchemas() + "/" + "consStatServMDFe_v3.00";
                break;
            }
            case "MDFeRecepcaoSinc": {
                xsd = configuracoes.getPastaSchemas() + "/" + "mdfe_v3.00";
                break;
            }
            case "MDFeRecepcaoEvento": {
                xsd = configuracoes.getPastaSchemas() + "/" + "eventoMDFe_v3.00";
                break;
            }
            case "cancelar": {
                xsd = configuracoes.getPastaSchemas() + "/" + "evCancMDFe_v3.00";
                break;
            }
            case "encerrar": {
                xsd = configuracoes.getPastaSchemas() + "/" + "evEncMDFe_v3.00";
                break;
            }
            case "incluir_condutor": {
                xsd = configuracoes.getPastaSchemas() + "/" + "evIncCondutorMDFe_v3.00";
                break;
            }
            case "incluir_dfe": {
                xsd = configuracoes.getPastaSchemas() + "/" + "evInclusaoDFeMDFe_v3.00";
                break;
            }
            case "MDFeConsNaoEnc": {
                xsd = configuracoes.getPastaSchemas() + "/" + "consMDFeNaoEnc_v3.00";
                break;
            }
            case "MDFeConsulta": {
                xsd = configuracoes.getPastaSchemas() + "/" + "consSitMDFe_v3.00";
                break;
            }
            default: {
                throw new MdfeException("N\u00e3o Encontrado XSD para:" + tipo);
            }
        }
        xsd = xsd + ".xsd";
        if (!new File(xsd).exists()) {
            throw new MdfeException("Schema Nfe n\u00e3o Localizado: " + xsd);
        }
        ValidarMDFe validar = new ValidarMDFe();
        String errosValidacao = validar.validateXml(xml, xsd);
        return errosValidacao;
    }
}

