/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe.util;

import br.com.swconsultoria.mdfe.dom.enuns.EstadosEnum;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class ChaveMdfeUtil {
    private String cDv;
    private String chave;

    public ChaveMdfeUtil(EstadosEnum estado, String cnpj, int serie, int numeroDfe, String tipoEmissao, String codigoDfe, LocalDateTime dataEmissao) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyMM");
        String cUf = estado.getCodigoUF();
        String aamm = dataEmissao.format(formatter);
        String serie1 = ChaveMdfeUtil.completarComZerosAEsquerda(String.valueOf(serie), 3);
        String nDfe = ChaveMdfeUtil.completarComZerosAEsquerda(String.valueOf(numeroDfe), 9);
        String cDfe = ChaveMdfeUtil.completarComZerosAEsquerda(codigoDfe, 8);
        cnpj = cnpj.length() < 14 ? "000" + cnpj : cnpj;
        this.chave = cUf + aamm + cnpj + "58" + serie1 + nDfe + tipoEmissao + cDfe;
        this.cDv = String.valueOf(ChaveMdfeUtil.modulo11(this.chave));
    }

    private static int modulo11(String chave) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < chave.length(); ++i) {
            total += (chave.charAt(chave.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        return resto == 0 || resto == 1 ? 0 : 11 - resto;
    }

    private static String completarComZerosAEsquerda(String value, int length) {
        int tam = value.length();
        StringBuilder result = new StringBuilder(value);
        for (int i = tam; i < length; ++i) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public String getChaveMDFe() {
        return "MDFe" + this.chave + this.cDv;
    }

    public String getDigitoVerificador() {
        return this.cDv;
    }
}

