/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe.util;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.CertificadoService;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.util.ObjetoUtil;
import java.io.InputStream;

public class ConfiguracaoMdfeUtil {
    public static ConfiguracoesMDFe iniciaConfiguracoes(ConfiguracoesMDFe configuracoesMdfe) throws MdfeException {
        return ConfiguracaoMdfeUtil.iniciaConfiguracoes(configuracoesMdfe, null);
    }

    public static ConfiguracoesMDFe iniciaConfiguracoes(ConfiguracoesMDFe configuracoesMdfe, String cpfCnpj) throws MdfeException {
        ObjetoUtil.verifica(configuracoesMdfe).orElseThrow(() -> new MdfeException("Configura\u00e7\u00f5es n\u00e3o foram criadas"));
        try {
            if (!configuracoesMdfe.getCertificado().isValido()) {
                throw new CertificadoException("Certificado vencido ou inv\u00e1lido.");
            }
            if (configuracoesMdfe.isValidacaoDocumento() && cpfCnpj != null && !configuracoesMdfe.getCertificado().getCnpjCpf().substring(0, 8).equals(cpfCnpj.substring(0, 8))) {
                throw new CertificadoException("Documento do Certificado(" + configuracoesMdfe.getCertificado().getCnpjCpf() + ") n\u00e3o equivale ao Documento do Emissor(" + cpfCnpj + ")");
            }
            if (ObjetoUtil.verifica(configuracoesMdfe.getCacert()).isPresent()) {
                CertificadoService.inicializaCertificado((Certificado)configuracoesMdfe.getCertificado(), (InputStream)configuracoesMdfe.getCacert());
            } else {
                CertificadoService.inicializaCertificado((Certificado)configuracoesMdfe.getCertificado());
            }
        }
        catch (CertificadoException e) {
            throw new MdfeException(e.getMessage());
        }
        return configuracoesMdfe;
    }
}

