/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe.util;

import br.com.swconsultoria.certificado.Certificado;
import br.com.swconsultoria.certificado.CertificadoService;
import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.mdfe.dom.ConfiguracoesMDFe;
import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.util.ObjetoUtil;
import br.com.swconsultoria.mdfe.util.WebServiceMdfeUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.util.Base64;
import java.util.Collection;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public final class ObjetoMdfeUtil {
    private ObjetoMdfeUtil() {
    }

    public static <T> Element objectToElement(Object objeto, Class<T> classe, String qName) throws MdfeException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            JAXB.marshal((Object)new JAXBElement(new QName(qName), classe, objeto), (Result)new DOMResult(document));
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new MdfeException("Erro Ao Converter Objeto em Elemento: " + e.getMessage());
        }
    }

    public static <T> T elementToObject(Element element, Class<T> classe) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classe});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Node)element, classe).getValue();
    }

    public static String elementToString(Element element) {
        DOMImplementationLS lsImpl = (DOMImplementationLS)element.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(element);
    }

    public static Boolean equalsNull(Object object) {
        return object == null;
    }

    public static Boolean differentNull(Object object) {
        return object != null;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        String s = String.valueOf(obj).trim();
        return s.length() == 0 || s.equalsIgnoreCase("null");
    }

    public static Boolean equalsNull(Collection collection) {
        return collection == null;
    }

    public static Boolean differentNull(Collection collection) {
        return collection != null;
    }

    public static Boolean isEmpty(Collection collection) {
        return collection.isEmpty();
    }

    public static Boolean isNotEmpty(Collection collection) {
        return !collection.isEmpty();
    }

    public static String criaQRCode(String chave, ConfiguracoesMDFe configuracoesMDFe) throws MdfeException {
        StringBuilder qrCode = new StringBuilder();
        qrCode.append(WebServiceMdfeUtil.getUrl(configuracoesMDFe, "QR_Code"));
        qrCode.append("?chMDFe=");
        qrCode.append(chave);
        qrCode.append("&tpAmb=");
        qrCode.append(configuracoesMDFe.getAmbiente().getCodigo());
        if (chave.charAt(34) == '2') {
            qrCode.append("&sign=");
            try {
                qrCode.append(ObjetoMdfeUtil.assinaSign(chave, configuracoesMDFe.getCertificado()));
            }
            catch (Exception e) {
                throw new MdfeException("Erro ao assinar Chave contingencia: " + e.getMessage());
            }
        }
        return qrCode.toString();
    }

    private static String assinaSign(String id, Certificado certificado) throws NoSuchAlgorithmException, CertificadoException, UnrecoverableEntryException, KeyStoreException, InvalidKeyException, SignatureException {
        KeyStore keyStore = CertificadoService.getKeyStore((Certificado)certificado);
        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(certificado.getNome(), new KeyStore.PasswordProtection(ObjetoUtil.verifica(certificado.getSenha()).orElse("").toCharArray()));
        byte[] data = id.getBytes(StandardCharsets.UTF_8);
        Signature sig = Signature.getInstance("SHA1WithRSA");
        sig.initSign(pkEntry.getPrivateKey());
        sig.update(data);
        byte[] signatureBytes = sig.sign();
        return Base64.getEncoder().encodeToString(signatureBytes).replace("&#13;", "").replace("\r\n", "").replace("\n", "").replace(System.lineSeparator(), "");
    }
}

