/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.mdfe.util;

import br.com.swconsultoria.mdfe.exception.MdfeException;
import br.com.swconsultoria.mdfe.schema_100.DistDFeInt.DistDFeInt;
import br.com.swconsultoria.mdfe.schema_300.consMDFeNaoEnc.TConsMDFeNaoEnc;
import br.com.swconsultoria.mdfe.schema_300.consReciMDFe.TConsReciMDFe;
import br.com.swconsultoria.mdfe.schema_300.consSitMDFe.TConsSitMDFe;
import br.com.swconsultoria.mdfe.schema_300.consStatServMDFe.ObjectFactory;
import br.com.swconsultoria.mdfe.schema_300.consStatServMDFe.TConsStatServ;
import br.com.swconsultoria.mdfe.schema_300.enviMDFe.TEnviMDFe;
import br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TProcEvento;
import br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TRetEvento;
import br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TEvento;
import br.com.swconsultoria.mdfe.schema_300.mdfe.TProtMDFe;
import br.com.swconsultoria.mdfe.schema_300.mdfe.TRetMDFe;
import br.com.swconsultoria.mdfe.schema_300.procMDFe.MdfeProc;
import br.com.swconsultoria.mdfe.schema_300.procMDFe.TMDFe;
import br.com.swconsultoria.mdfe.schema_300.retConsMDFeNaoEnc.TRetConsMDFeNaoEnc;
import br.com.swconsultoria.mdfe.schema_300.retConsReciMDFe.TRetConsReciMDFe;
import br.com.swconsultoria.mdfe.schema_300.retConsSitMDFe.TRetConsSitMDFe;
import br.com.swconsultoria.mdfe.schema_300.retConsStatServMDFe.TRetConsStatServ;
import br.com.swconsultoria.mdfe.schema_300.retEnviMDFe.TRetEnviMDFe;
import br.com.swconsultoria.mdfe.util.ObjetoMdfeUtil;
import br.com.swconsultoria.mdfe.util.XsdUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XmlMdfeUtil {
    private static final String OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL = "Objeto n\u00e3o mapeado no XmlMdfeUtil:";

    private XmlMdfeUtil() {
    }

    public static <T> T xmlToObject(String xml, Class<T> classe) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classe});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xml)), classe).getValue();
    }

    public static String leXml(String arquivo) throws MdfeException {
        StringBuilder xml = new StringBuilder();
        try {
            String linha;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arquivo), StandardCharsets.UTF_8));
            while ((linha = in.readLine()) != null) {
                xml.append(linha);
            }
            in.close();
        }
        catch (IOException e) {
            throw new MdfeException("Ler Xml: " + e.getMessage());
        }
        return xml.toString();
    }

    public static String objectMdfeToXml(Object obj) throws JAXBException, MdfeException {
        Object element;
        JAXBContext context;
        block20 : switch (obj.getClass().getSimpleName()) {
            case "TMDFe": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.mdfe.schema_300.enviMDFe.TMDFe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.enviMDFe.TMDFe.class});
                        element = XsdUtil.mdfe.createMdfe((br.com.swconsultoria.mdfe.schema_300.enviMDFe.TMDFe)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.mdfe.TMDFe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.mdfe.TMDFe.class});
                        element = new br.com.swconsultoria.mdfe.schema_300.mdfe.ObjectFactory().createMDFe((br.com.swconsultoria.mdfe.schema_300.mdfe.TMDFe)obj);
                        break block20;
                    }
                }
                throw new MdfeException(OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL + obj.getClass().getName());
            }
            case "TEnviMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TEnviMDFe.class});
                element = new br.com.swconsultoria.mdfe.schema_300.enviMDFe.ObjectFactory().createEnviMDFe((TEnviMDFe)obj);
                break;
            }
            case "TConsStatServ": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsStatServ.class});
                element = new ObjectFactory().createConsStatServMDFe((TConsStatServ)obj);
                break;
            }
            case "TConsSitMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsSitMDFe.class});
                element = new br.com.swconsultoria.mdfe.schema_300.consSitMDFe.ObjectFactory().createConsSitMDFe((TConsSitMDFe)obj);
                break;
            }
            case "TConsReciMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsReciMDFe.class});
                element = new br.com.swconsultoria.mdfe.schema_300.consReciMDFe.ObjectFactory().createConsReciMDFe((TConsReciMDFe)obj);
                break;
            }
            case "TConsMDFeNaoEnc": {
                context = JAXBContext.newInstance((Class[])new Class[]{TConsMDFeNaoEnc.class});
                element = new br.com.swconsultoria.mdfe.schema_300.consMDFeNaoEnc.ObjectFactory().createConsMDFeNaoEnc((TConsMDFeNaoEnc)obj);
                break;
            }
            case "MdfeProc": {
                context = JAXBContext.newInstance((Class[])new Class[]{MdfeProc.class});
                element = XsdUtil.mdfeProc.createProcMdfe((MdfeProc)obj);
                break;
            }
            case "TProtMDFe": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.mdfe.schema_300.retConsReciMDFe.TProtMDFe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.retConsReciMDFe.TProtMDFe.class});
                        element = XsdUtil.mdfeProt.createProtMdfe((br.com.swconsultoria.mdfe.schema_300.retConsReciMDFe.TProtMDFe)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.mdfe.TProtMDFe": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TProtMDFe.class});
                        element = XsdUtil.mdfeProt.createProtMdfe((TProtMDFe)obj);
                        break block20;
                    }
                }
                throw new MdfeException(OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL + obj.getClass().getName());
            }
            case "TRetEnviMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetEnviMDFe.class});
                element = new br.com.swconsultoria.mdfe.schema_300.retEnviMDFe.ObjectFactory().createRetEnviMDFe((TRetEnviMDFe)obj);
                break;
            }
            case "TRetConsReciMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetConsReciMDFe.class});
                element = new br.com.swconsultoria.mdfe.schema_300.retConsReciMDFe.ObjectFactory().createRetConsReciMDFe((TRetConsReciMDFe)obj);
                break;
            }
            case "TRetConsMDFeNaoEnc": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetConsMDFeNaoEnc.class});
                element = new br.com.swconsultoria.mdfe.schema_300.retConsMDFeNaoEnc.ObjectFactory().createRetConsMDFeNaoEnc((TRetConsMDFeNaoEnc)obj);
                break;
            }
            case "TRetConsSitMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetConsSitMDFe.class});
                element = new br.com.swconsultoria.mdfe.schema_300.retConsSitMDFe.ObjectFactory().createRetConsSitMDFe((TRetConsSitMDFe)obj);
                break;
            }
            case "DistDFeInt": {
                context = JAXBContext.newInstance((Class[])new Class[]{DistDFeInt.class});
                element = XsdUtil.distDFe.createDistDFe((DistDFeInt)obj);
                break;
            }
            case "TRetMDFe": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetMDFe.class});
                element = XsdUtil.retMdfe.createRetMdfe((TRetMDFe)obj);
                break;
            }
            case "TRetConsStatServ": {
                context = JAXBContext.newInstance((Class[])new Class[]{TRetConsStatServ.class});
                element = XsdUtil.retStatus.createRetMdfe((TRetConsStatServ)obj);
                break;
            }
            case "TEvento": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TEvento.class});
                        element = XsdUtil.evento.createEvent((br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TEvento.class});
                        element = XsdUtil.evento.createEvent((br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TEvento.class});
                        element = XsdUtil.evento.createEvent((TEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TEvento.class});
                        element = XsdUtil.evento.createEvent((br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evPagtoOperMDFe.TEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evPagtoOperMDFe.TEvento.class});
                        element = XsdUtil.evento.createEvent((br.com.swconsultoria.mdfe.schema_300.evPagtoOperMDFe.TEvento)obj);
                        break block20;
                    }
                }
                throw new MdfeException(OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL + obj.getClass().getName());
            }
            case "TRetEvento": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TRetEvento.class});
                        element = XsdUtil.retEvento.createTRetEvent((TRetEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TRetEvento.class});
                        element = XsdUtil.retEvento.createTRetEvent((br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TRetEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TRetEvento.class});
                        element = XsdUtil.retEvento.createTRetEvent((br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TRetEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TRetEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TRetEvento.class});
                        element = XsdUtil.retEvento.createTRetEvent((br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TRetEvento)obj);
                        break block20;
                    }
                }
                throw new MdfeException(OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL + obj.getClass().getName());
            }
            case "TProcEvento": {
                switch (obj.getClass().getName()) {
                    case "br.com.swconsultoria.mdfe.schema_300.evCancMDFe.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{TProcEvento.class});
                        element = XsdUtil.procEvento.createProcEvent((TProcEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TProcEvento.class});
                        element = XsdUtil.procEvento.createProcEvent((br.com.swconsultoria.mdfe.schema_300.evEncMDFe.TProcEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TProcEvento.class});
                        element = XsdUtil.procEvento.createProcEvent((br.com.swconsultoria.mdfe.schema_300.evIncCondutorMDF.TProcEvento)obj);
                        break block20;
                    }
                    case "br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TProcEvento": {
                        context = JAXBContext.newInstance((Class[])new Class[]{br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TProcEvento.class});
                        element = XsdUtil.procEvento.createProcEvent((br.com.swconsultoria.mdfe.schema_300.evIncDFeMDFe.TProcEvento)obj);
                        break block20;
                    }
                }
                throw new MdfeException(OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL + obj.getClass().getName());
            }
            default: {
                throw new MdfeException(OBJETO_N\u00c3O_MAPEADO_NO_XML_MDFE_UTIL + obj.getClass().getName());
            }
        }
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        marshaller.marshal(element, (Writer)sw);
        return XmlMdfeUtil.replacesMdfe("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sw.toString());
    }

    public static String gZipToXml(byte[] conteudo) throws IOException {
        String line;
        if (conteudo == null || conteudo.length == 0) {
            return "";
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));
        StringBuilder outStr = new StringBuilder();
        while ((line = bf.readLine()) != null) {
            outStr.append(line);
        }
        return outStr.toString();
    }

    public static String criaMdfeProc(TEnviMDFe enviMdfe, Object retorno) throws JAXBException, MdfeException {
        MdfeProc mdfeProc2 = new MdfeProc();
        mdfeProc2.setVersao("3.00");
        mdfeProc2.setMDFe(XmlMdfeUtil.xmlToObject(XmlMdfeUtil.objectMdfeToXml(enviMdfe.getMDFe()), TMDFe.class));
        mdfeProc2.setProtMDFe(XmlMdfeUtil.xmlToObject(XmlMdfeUtil.objectMdfeToXml(retorno), br.com.swconsultoria.mdfe.schema_300.procMDFe.TProtMDFe.class));
        return XmlMdfeUtil.objectMdfeToXml(mdfeProc2);
    }

    public static String criaMdfeProc(br.com.swconsultoria.mdfe.schema_300.mdfe.TMDFe mdfe2, Object retorno) throws JAXBException, MdfeException {
        MdfeProc mdfeProc2 = new MdfeProc();
        mdfeProc2.setVersao("3.00");
        mdfeProc2.setMDFe(XmlMdfeUtil.xmlToObject(XmlMdfeUtil.objectMdfeToXml(mdfe2), TMDFe.class));
        mdfeProc2.setProtMDFe(XmlMdfeUtil.xmlToObject(XmlMdfeUtil.objectMdfeToXml(retorno), br.com.swconsultoria.mdfe.schema_300.procMDFe.TProtMDFe.class));
        return XmlMdfeUtil.objectMdfeToXml(mdfeProc2);
    }

    private static String replacesMdfe(String xml) {
        return xml.replace("ns2:", "").replace("ns3:", "").replace("&lt;", "<").replace("&gt;", ">").replace("<Signature>", "<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">").replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "").replace(" xmlns:ns3=\"http://www.portalfiscal.inf.br/mdfe\"", "").replace(" xmlns:ns2=\"http://www.portalfiscal.inf.br/mdfe\"", "").replace(" xmlns=\"\"", "");
    }

    public static String dataMDFe(LocalDateTime dataASerFormatada) throws MdfeException {
        return XmlMdfeUtil.dataMDFe(dataASerFormatada, ZoneId.systemDefault());
    }

    public static String dataMDFe(LocalDateTime dataASerFormatada, ZoneId zoneId) throws MdfeException {
        try {
            GregorianCalendar calendar = GregorianCalendar.from(dataASerFormatada.atZone(ObjetoMdfeUtil.isEmpty(zoneId) ? ZoneId.of("Brazil/East") : zoneId));
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlCalendar.setMillisecond(Integer.MIN_VALUE);
            return xmlCalendar.toString();
        }
        catch (DatatypeConfigurationException e) {
            throw new MdfeException(e.getMessage());
        }
    }

    public static int modulo11(String chave) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < chave.length(); ++i) {
            total += (chave.charAt(chave.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        return resto == 0 || resto == 1 ? 0 : 11 - resto;
    }

    public static byte[] gZip(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(str.getBytes(StandardCharsets.UTF_8));
        gzip.flush();
        gzip.close();
        return obj.toByteArray();
    }
}

