/*
 * Decompiled with CFR 0.152.
 */
package com.acbr;

import com.acbr.ACBrLibBase;
import com.acbr.ACBrSessao;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class ACBrLibConfigBase<TLib extends ACBrLibBase> {
    protected TLib parent;
    protected ACBrSessao sessaoConfig;
    protected String subName;

    protected ACBrLibConfigBase(TLib acbrlib, ACBrSessao sessao) {
        this.parent = acbrlib;
        this.sessaoConfig = sessao;
    }

    private String getPropertyName(String propertyName) {
        if ("".equals(this.subName)) {
            return propertyName;
        }
        return this.subName + "." + propertyName;
    }

    protected String getProperty(String propertyName) throws Exception {
        return ((ACBrLibBase)this.parent).configLerValor(this.sessaoConfig, this.getPropertyName(propertyName));
    }

    protected void setProperty(String propertyName, String value) throws Exception {
        ((ACBrLibBase)this.parent).configGravarValor(this.sessaoConfig, this.getPropertyName(propertyName), value);
    }

    protected int getIntProperty(String propertyName) throws Exception {
        String value = this.getProperty(propertyName);
        return Integer.parseInt(value);
    }

    protected void setIntProperty(String propertyName, int value) throws Exception {
        String svalue = String.valueOf(value);
        this.setProperty(propertyName, svalue);
    }

    protected boolean getBoolProperty(String propertyName) throws Exception {
        String value = this.getProperty(propertyName);
        return Boolean.parseBoolean(value);
    }

    protected void setBoolProperty(String propertyName, boolean value) throws Exception {
        String svalue = value ? "1" : "0";
        this.setProperty(propertyName, svalue);
    }

    protected Date getDateProperty(String propertyName) throws Exception {
        String value = this.getProperty(propertyName);
        SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
        return formato.parse(value);
    }

    protected void setDateProperty(String propertyName, Date value) throws Exception {
        SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
        String svalue = formato.format(value);
        this.setProperty(propertyName, svalue);
    }
}

