/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.efd.icms.util;

import br.com.swconsultoria.efd.icms.exception.EfdException;
import br.com.swconsultoria.efd.icms.registros.EfdIcms;
import java.io.File;
import java.io.FileWriter;
import java.time.LocalDate;
import java.util.Collection;

public final class Util {
    private static final LocalDate dataVersao2018 = LocalDate.of(2017, 12, 31);
    private static final LocalDate dataVersao2019 = LocalDate.of(2018, 12, 31);
    private static final LocalDate dataVersao2020 = LocalDate.of(2019, 12, 31);
    private static final LocalDate dataVersao2021 = LocalDate.of(2020, 12, 31);
    private static final LocalDate dataVersao2022 = LocalDate.of(2021, 12, 31);
    private static final LocalDate dataVersao2023 = LocalDate.of(2022, 12, 31);
    private static final LocalDate dataVersao2024 = LocalDate.of(2023, 12, 31);
    private static final LocalDate dataVersao2025 = LocalDate.of(2024, 12, 31);

    private Util() {
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        String s = String.valueOf(obj).trim();
        return s.length() == 0 || s.equalsIgnoreCase("null");
    }

    public static String preencheRegistro(String string) {
        return Util.isEmpty(string) ? "" : string;
    }

    public static boolean versao2018(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2018);
    }

    public static boolean versao2019(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2019);
    }

    public static boolean versao2020(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2020);
    }

    public static boolean versao2021(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2021);
    }

    public static boolean versao2022(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2022);
    }

    public static boolean versao2023(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2023);
    }

    public static boolean versao2024(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2024);
    }

    public static boolean versao2025(String dataStr) {
        return Util.strToDate(dataStr).isAfter(dataVersao2025);
    }

    private static LocalDate strToDate(String dataStr) {
        return LocalDate.of(Integer.parseInt(dataStr.substring(4, 8)), Integer.parseInt(dataStr.substring(2, 4)), Integer.parseInt(dataStr.substring(0, 2)));
    }

    public static void criarPastaArquivo(String pasta, String arquivo, String conteudo) throws EfdException {
        File folder = new File(pasta);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            FileWriter fileWriter = new FileWriter(new File(pasta + "/" + arquivo));
            fileWriter.write(conteudo);
            fileWriter.close();
        }
        catch (Exception e) {
            throw new EfdException("Erro ao Criar Arquivo " + e.getMessage());
        }
    }

    public static String getCodVersao(EfdIcms efdIcms) {
        if (Util.versao2025(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "019";
        }
        if (Util.versao2024(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "018";
        }
        if (Util.versao2023(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "017";
        }
        if (Util.versao2022(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "016";
        }
        if (Util.versao2021(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "015";
        }
        if (Util.versao2020(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "014";
        }
        if (Util.versao2019(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "013";
        }
        if (Util.versao2018(efdIcms.getBloco0().getRegistro0000().getDt_ini())) {
            return "012";
        }
        return "ERRO_COD_VERSAO";
    }
}

