/*
 * Decompiled with CFR 0.152.
 */
package jnafilechooser.demo;

import com.sun.jna.Platform;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jnafilechooser.api.WindowsFileChooser;
import jnafilechooser.api.WindowsFolderBrowser;

public class NativePorcelainDemo {
    public static void main(String[] args) throws Exception {
        if (!Platform.isWindows()) {
            System.err.println("Sorry, this only works on Windows");
            JOptionPane.showMessageDialog(null, "Sorry this only works on Windows", "OS not supported", 0);
            System.exit(1);
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        final JFrame frame = new JFrame(NativePorcelainDemo.class.getName());
        JPanel content = new JPanel(new FlowLayout(1, 8, 8));
        JButton chooseFile = new JButton("Choose File");
        JButton chooseDir = new JButton("Choose Folder");
        content.add(chooseFile);
        content.add(chooseDir);
        chooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowsFileChooser fc = new WindowsFileChooser();
                fc.setDefaultFilename("Filechooser Demo.txt");
                fc.setTitle("Filechooser Demo");
                fc.addFilter("All Files", new String[]{"*"});
                fc.addFilter("Pictures", new String[]{"jpg", "jpeg", "gif", "bmp", "png"});
                fc.addFilter("Text Files", new String[]{"txt", "log", "nfo", "xml"});
                if (fc.showOpenDialog((Window)frame)) {
                    File f = fc.getSelectedFile();
                    JOptionPane.showMessageDialog(frame, f.getAbsolutePath(), "Selection", 1);
                }
            }
        });
        chooseDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowsFolderBrowser fb = new WindowsFolderBrowser();
                File dir = fb.showDialog((Window)frame);
                if (dir != null) {
                    JOptionPane.showMessageDialog(frame, dir.getAbsolutePath(), "Selection", 1);
                }
            }
        });
        frame.setContentPane(content);
        frame.pack();
        frame.setSize(frame.getWidth() * 2, frame.getHeight());
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

