/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.Assinar;
import br.com.swconsultoria.cte.Validar;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.enviCTe.TEnviCTe;
import br.com.swconsultoria.cte.schema_300.retEnviCTe.TRetEnviCTe;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import br.com.swconsultoria.cte.wsdl.CteRecepcao.CteRecepcaoStub;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class EnvioCte {
    EnvioCte() {
    }

    static TEnviCTe montaCte(ConfiguracoesCte config, TEnviCTe enviCTe, boolean valida) throws CteException {
        try {
            String xml = XmlCteUtil.objectToXml(enviCTe);
            xml = Assinar.assinaCte(config, xml, AssinaturaEnum.CTE);
            xml = xml.replaceAll(System.lineSeparator(), "");
            LoggerUtil.log(EnvioCte.class, "[XML-ASSINADO]: " + xml);
            if (valida) {
                new Validar().validaXml(config, xml, ServicosEnum.ENVIO_CTE);
            }
            return XmlCteUtil.xmlToObject(xml, TEnviCTe.class);
        }
        catch (Exception e) {
            throw new CteException(e.getMessage());
        }
    }

    static TRetEnviCTe enviaCte(ConfiguracoesCte config, TEnviCTe enviCTe) throws CteException {
        try {
            String xml = XmlCteUtil.objectToXml(enviCTe);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            if (config.getEstado().equals((Object)EstadosEnum.PR) || config.getEstado().equals((Object)EstadosEnum.MT) || config.getEstado().equals((Object)EstadosEnum.MS)) {
                Iterator children = ome.getChildrenWithLocalName("CTe");
                while (children.hasNext()) {
                    OMElement omElement = (OMElement)children.next();
                    if (omElement == null || !"CTe".equals(omElement.getLocalName())) continue;
                    omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/cte", null);
                }
            }
            LoggerUtil.log(EnvioCte.class, "[XML-ENVIO]: " + xml);
            CteRecepcaoStub.CteDadosMsg dadosMsg = new CteRecepcaoStub.CteDadosMsg();
            dadosMsg.setExtraElement(ome);
            CteRecepcaoStub.CteCabecMsg cteCabecMsg = new CteRecepcaoStub.CteCabecMsg();
            cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
            cteCabecMsg.setVersaoDados("3.00");
            CteRecepcaoStub.CteCabecMsgE cteCabecMsgE = new CteRecepcaoStub.CteCabecMsgE();
            cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
            CteRecepcaoStub stub = new CteRecepcaoStub(WebServiceCteUtil.getUrl(config, ServicosEnum.ENVIO_CTE));
            CteRecepcaoStub.CteRecepcaoLoteResult result = stub.cteRecepcaoLote(dadosMsg, cteCabecMsgE);
            return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetEnviCTe.class);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }
}

