/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte;

import br.com.swconsultoria.cte.Assinar;
import br.com.swconsultoria.cte.Validar;
import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.schema_300.cteOS.TCTeOS;
import br.com.swconsultoria.cte.schema_300.retCTeOS.TRetCTeOS;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.WebServiceCteUtil;
import br.com.swconsultoria.cte.util.XmlCteUtil;
import br.com.swconsultoria.cte.wsdl.CteRecepcaoOS.CteRecepcaoOSStub;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class EnvioCteOS {
    EnvioCteOS() {
    }

    static TCTeOS montaCteOS(ConfiguracoesCte config, TCTeOS enviCTe, boolean valida) throws CteException {
        try {
            String xml = XmlCteUtil.objectToXml(enviCTe);
            xml = Assinar.assinaCte(config, xml, AssinaturaEnum.CTE_OS);
            xml = xml.replaceAll(System.lineSeparator(), "");
            LoggerUtil.log(EnvioCteOS.class, "[XML-ASSINADO]: " + xml);
            if (valida) {
                new Validar().validaXml(config, xml, ServicosEnum.ENVIO_CTE_OS);
            }
            return XmlCteUtil.xmlToObject(xml, TCTeOS.class);
        }
        catch (JAXBException e) {
            throw new CteException(e.getMessage());
        }
    }

    static TRetCTeOS enviaCteOS(ConfiguracoesCte config, TCTeOS enviCTe) throws CteException {
        try {
            String xml = XmlCteUtil.objectToXml(enviCTe);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            if (config.getEstado().equals((Object)EstadosEnum.PR) || config.getEstado().equals((Object)EstadosEnum.MT) || config.getEstado().equals((Object)EstadosEnum.MS)) {
                Iterator children = ome.getChildrenWithLocalName("CTe");
                while (children.hasNext()) {
                    OMElement omElement = (OMElement)children.next();
                    if (omElement == null || !"CTe".equals(omElement.getLocalName())) continue;
                    omElement.addAttribute("xmlns", "http://www.portalfiscal.inf.br/cte", null);
                }
            }
            LoggerUtil.log(EnvioCteOS.class, "[XML-ENVIO]: " + ome);
            CteRecepcaoOSStub.CteDadosMsg dadosMsg = new CteRecepcaoOSStub.CteDadosMsg();
            dadosMsg.setExtraElement(ome);
            CteRecepcaoOSStub.CteCabecMsg cteCabecMsg = new CteRecepcaoOSStub.CteCabecMsg();
            cteCabecMsg.setCUF(String.valueOf(config.getEstado().getCodigoUF()));
            cteCabecMsg.setVersaoDados("3.00");
            CteRecepcaoOSStub.CteCabecMsgE cteCabecMsgE = new CteRecepcaoOSStub.CteCabecMsgE();
            cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
            CteRecepcaoOSStub stub = new CteRecepcaoOSStub(WebServiceCteUtil.getUrl(config, ServicosEnum.ENVIO_CTE_OS));
            CteRecepcaoOSStub.CteRecepcaoOSResult result = stub.cteRecepcaoOS(dadosMsg, cteCabecMsgE);
            return XmlCteUtil.xmlToObject(result.getExtraElement().toString(), TRetCTeOS.class);
        }
        catch (RemoteException | JAXBException | XMLStreamException e) {
            throw new CteException(e.getMessage());
        }
    }
}

