/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.util;

import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class ChaveUtil {
    private String cDv;
    private String chave;

    public ChaveUtil(EstadosEnum estado, String cnpj, String modelo, int serie, int numeroNf, String tipoEmissao, String codigoNf, LocalDateTime dataEmissao) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyMM");
        String cUf = estado.getCodigoUF();
        String aamm = dataEmissao.format(formatter);
        String serie1 = ChaveUtil.completarComZerosAEsquerda(String.valueOf(serie), 3);
        String nNf = ChaveUtil.completarComZerosAEsquerda(String.valueOf(numeroNf), 9);
        String cNf = ChaveUtil.completarComZerosAEsquerda(codigoNf, 8);
        cnpj = cnpj.length() < 14 ? "000" + cnpj : cnpj;
        this.chave = cUf + aamm + cnpj + modelo + serie1 + nNf + tipoEmissao + cNf;
        this.cDv = String.valueOf(ChaveUtil.modulo11(this.chave));
    }

    public String getChaveCT() {
        return "CTe" + this.chave + this.cDv;
    }

    public String getDigitoVerificador() {
        return this.cDv;
    }

    private static int modulo11(String chave) {
        int total = 0;
        int peso = 2;
        for (int i = 0; i < chave.length(); ++i) {
            total += (chave.charAt(chave.length() - 1 - i) - 48) * peso;
            if (++peso != 10) continue;
            peso = 2;
        }
        int resto = total % 11;
        return resto == 0 || resto == 1 ? 0 : 11 - resto;
    }

    public static String completarComZerosAEsquerda(String value, int length) {
        int tam = value.length();
        StringBuilder result = new StringBuilder(value);
        for (int i = tam; i < length; ++i) {
            result.insert(0, "0");
        }
        return result.toString();
    }
}

