/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.cte.util;

import br.com.swconsultoria.cte.dom.ConfiguracoesCte;
import br.com.swconsultoria.cte.dom.enuns.AmbienteEnum;
import br.com.swconsultoria.cte.dom.enuns.EstadosEnum;
import br.com.swconsultoria.cte.dom.enuns.ServicosEnum;
import br.com.swconsultoria.cte.exception.CteException;
import br.com.swconsultoria.cte.util.LoggerUtil;
import br.com.swconsultoria.cte.util.ObjetoCTeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.ini4j.Wini;

public class WebServiceCteUtil {
    public static String getUrl(ConfiguracoesCte config, ServicosEnum servico) throws CteException {
        try {
            InputStream is;
            String secao = "CTe_" + (Object)((Object)config.getEstado()) + "_" + (config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "H" : "P");
            if (ObjetoCTeUtil.verifica(config.getArquivoWebService()).isPresent()) {
                File arquivo = new File(config.getArquivoWebService());
                if (!arquivo.exists()) {
                    throw new FileNotFoundException("Arquivo WebService" + config.getArquivoWebService() + " n\u00e3o encontrado");
                }
                is = new FileInputStream(arquivo);
            } else {
                is = WebServiceCteUtil.class.getResourceAsStream("/WebServicesCte.ini");
            }
            Wini ini = new Wini();
            ini.getConfig().setLowerCaseOption(true);
            ini.load(is);
            is.close();
            String url = ini.get((Object)secao, (Object)"usar");
            if (!(config.getEstado().equals((Object)EstadosEnum.MG) || config.getEstado().equals((Object)EstadosEnum.MS) || config.getEstado().equals((Object)EstadosEnum.MT) || config.getEstado().equals((Object)EstadosEnum.SP) || config.getEstado().equals((Object)EstadosEnum.PR))) {
                secao = url;
            }
            if (servico.equals((Object)ServicosEnum.DISTRIBUICAO_DFE)) {
                secao = "CTe_AN_" + (config.getAmbiente().equals((Object)AmbienteEnum.HOMOLOGACAO) ? "H" : "P");
            }
            url = ini.get((Object)secao, (Object)servico.getServico().toLowerCase());
            ObjetoCTeUtil.verifica(url).orElseThrow(() -> new CteException("WebService de " + (Object)((Object)servico) + " n\u00e3o encontrado para " + config.getEstado().getNome()));
            LoggerUtil.log(WebServiceCteUtil.class, "[URL]: " + (Object)((Object)servico) + ": " + url);
            return url;
        }
        catch (IOException e) {
            throw new CteException(e.getMessage());
        }
    }
}

