/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.banrisul_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoBanrisulAPI
implements Configuracao {
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    private String caminhoCertificado;
    @NotNull
    private String senhaCertificado;
    @NotEmpty
    private String urlBaseProducao = "?";
    @NotEmpty
    private String urlBaseHomologacao = "https://ww20.banrisul.com.br/boc/link/Bocswsxn_CobrancaOnlineWS.asmx";
    private final String arquivoJasper = "BoletoBanrisul";
    private final String logo = "LogoBanrisul.jpg";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    @NotEmpty
    public String getURLBase() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlBaseProducao : this.urlBaseHomologacao;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoBanrisul.jasper");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoBanrisul.jpg");
            imageLogo = new ImageIcon(IOUtils.toByteArray(inputStreamLogo)).getImage();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("beneficiario.agencia", "beneficiario.conta", "beneficiario.digitoConta", "beneficiario.documento", "nossoNumero", "pagador.nome", "pagador.documento", "pagador.codigo", "pagador.endereco.logradouro", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cep", "pagador.endereco.cidade", "pagador.endereco.uf", "valorBoleto", "dataVencimento", "beneficiario", "pagador");
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getCaminhoCertificado() {
        return this.caminhoCertificado;
    }

    @NotNull
    public String getSenhaCertificado() {
        return this.senhaCertificado;
    }

    public String getUrlBaseProducao() {
        return this.urlBaseProducao;
    }

    public String getUrlBaseHomologacao() {
        return this.urlBaseHomologacao;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setCaminhoCertificado(String caminhoCertificado) {
        this.caminhoCertificado = caminhoCertificado;
    }

    public void setSenhaCertificado(@NotNull String senhaCertificado) {
        this.senhaCertificado = senhaCertificado;
    }

    public void setUrlBaseProducao(String urlBaseProducao) {
        this.urlBaseProducao = urlBaseProducao;
    }

    public void setUrlBaseHomologacao(String urlBaseHomologacao) {
        this.urlBaseHomologacao = urlBaseHomologacao;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

