/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.inter_api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Token {
    private String access_token;
    private String token_type;
    private Long expires_in;
    private Long refresh_expires_in;
    private String scope;
    @JsonIgnore
    private LocalDateTime dtExp;

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public String getToken_type() {
        return this.token_type;
    }

    public void setToken_type(String token_type) {
        this.token_type = token_type;
    }

    public Long getExpires_in() {
        return this.expires_in;
    }

    public void setExpires_in(Long expires_in) {
        this.expires_in = expires_in;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public LocalDateTime getDtExp() {
        return this.dtExp;
    }

    public void setDtExp(LocalDateTime dtExp) {
        this.dtExp = dtExp;
    }

    public Long getRefresh_expires_in() {
        return this.refresh_expires_in;
    }

    public void setRefresh_expires_in(Long refresh_expires_in) {
        this.refresh_expires_in = refresh_expires_in;
    }

    public Token create(String jsonToken) {
        JsonObject json = JsonParser.parseString(jsonToken).getAsJsonObject();
        this.access_token = json.get("access_token").getAsString();
        this.expires_in = Long.valueOf(json.get("expires_in").toString());
        JsonElement refreshNode = json.get("refresh_expires_in");
        if (refreshNode != null) {
            this.refresh_expires_in = Long.valueOf(json.get("refresh_expires_in").toString());
        }
        this.scope = json.get("scope").toString();
        this.token_type = json.get("token_type").toString();
        LocalDateTime localDateTime = LocalDateTime.now();
        LocalDateTime plusNanos = localDateTime.plusSeconds(this.expires_in);
        this.setDtExp(plusNanos);
        return this;
    }

    public boolean expired() {
        if (this.getDtExp() != null) {
            return this.getDtExp().isBefore(LocalDateTime.now());
        }
        return true;
    }

    public static class TpScopeBuilder {
        private List<TpScope> listTpScope = new ArrayList<TpScope>();

        public TpScopeBuilder todos() {
            this.listTpScope = Arrays.asList(TpScope.values());
            return this;
        }

        public TpScopeBuilder addScope(TpScope tpScope) {
            this.listTpScope.add(tpScope);
            return this;
        }

        public String build() {
            StringBuilder scopes = new StringBuilder();
            this.listTpScope.forEach(scope -> scopes.append(scope.getDescricao()).append(" "));
            return scopes.toString().trim();
        }
    }

    public static enum TpScopeSicoob {
        COBRANCA_BOLETOS_CONSULTAR("cobranca_boletos_consultar"),
        COBRANCA_BOLETOS_INCLUIR("cobranca_boletos_incluir"),
        COBRANCA_BOLETOS_PAGADOR("cobranca_boletos_pagador"),
        PAGAMENTO_BOLETO_WRITE("cobranca_boletos_descontos"),
        PAGAMENTO_BOLETO_READ("cobranca_boletos_abatimentos"),
        PAGAMENTO_DARF_WRITE("cobranca_boletos_valor_nominal"),
        COBRANCA_BOLETOS_SEU_NUMERO("cobranca_boletos_seu_numero"),
        COBRANCA_BOLETOS_ESPECIE_DOCUMENTO("cobranca_boletos_especie_documento"),
        COBRANCA_BOLETOS_BAIXA("cobranca_boletos_baixa"),
        COBRANCA_BOLETOS_RATEIO_CREDITO("cobranca_boletos_rateio_credito"),
        COBRANCA_PAGADORES("cobranca_pagadores"),
        COBRANCA_BOLETOS_NEGATIVACOES_INCLUIR("cobranca_boletos_negativacoes_incluir"),
        COBRANCA_BOLETOS_NEGATIVACOES_ALTERAR("cobranca_boletos_negativacoes_alterar"),
        COBRANCA_BOLETOS_NEGATIVACOES_BAIXAR("cobranca_boletos_negativacoes_baixar"),
        COBRANCA_BOLETOS_PROTESTOS_INCLUIR("cobranca_boletos_protestos_incluir"),
        COBRANCA_BOLETOS_PROTESTOS_ALTERAR("cobranca_boletos_protestos_alterar"),
        COBRANCA_BOLETOS_PROTESTOS_DESISTIR("cobranca_boletos_protestos_desistir"),
        COBRANCA_BOLETOS_SOLICITACAO_MOVIMENTACAO_INCLUIR("cobranca_boletos_solicitacao_movimentacao_incluir"),
        COBRANCA_BOLETOS_SOLICITACAO_MOVIMENTACAO_CONSULTAR("cobranca_boletos_solicitacao_movimentacao_consultar"),
        COBRANCA_BOLETOS_SOLICITACAO_MOVIMENTACAO_DOWNLOAD("cobranca_boletos_solicitacao_movimentacao_download"),
        COBRANCA_BOLETOS_PRORROGACOES_DATA_VENCIMENTO("cobranca_boletos_prorrogacoes_data_vencimento"),
        COBRANCA_BOLETOS_PRORROGACOES_DATA_LIMITE_PAGAMENTO("cobranca_boletos_prorrogacoes_data_limite_pagamento"),
        COBRANCA_BOLETOS_ENCARGOS_MULTAS("cobranca_boletos_encargos_multas"),
        COBRANCA_BOLETOS_ENCARGOS_JUROS_MORA("cobranca_boletos_encargos_juros_mora"),
        COBRANCA_BOLETOS_PIX("cobranca_boletos_pix"),
        COBRANCA_BOLETOS_FAIXA_NN_DISPONIVEIS("cobranca_boletos_faixa_nn_disponiveis");

        private final String descricao;

        private TpScopeSicoob(String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String todos() {
            StringBuilder scopes = new StringBuilder();
            Arrays.asList(TpScopeSicoob.values()).forEach(scope -> scopes.append(scope.getDescricao()).append(" "));
            return scopes.toString().trim();
        }
    }

    public static enum TpScope {
        EXTRATO_READ("extrato.read"),
        BOLETO_COBRANCA_READ("boleto-cobranca.read"),
        BOLETO_COBRANCA_WRITE("boleto-cobranca.write"),
        PAGAMENTO_BOLETO_WRITE("pagamento-boleto.write"),
        PAGAMENTO_BOLETO_READ("pagamento-boleto.read"),
        PAGAMENTO_DARF_WRITE("pagamento-darf.write");

        private final String descricao;

        private TpScope(String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return this.descricao;
        }
    }
}

