/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.itau_api;

import br.com.java_brasil.boleto.model.Configuracao;
import br.com.java_brasil.boleto.model.enums.AmbienteEnum;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;

public class ConfiguracaoItauAPI
implements Configuracao {
    @NotEmpty
    private String clientId;
    @NotEmpty
    private String clientSecret;
    @NotEmpty
    private String caminhoCertificado;
    @NotEmpty
    private String senhaCertificado;
    @NotNull
    private AmbienteEnum ambiente;
    @NotEmpty
    private String urlRegistroBoletoHomologacao = "https://devportal.itau.com.br/sandboxapi/pix_recebimentos_conciliacoes_v2_ext/v2/boletos_pix";
    @NotEmpty
    private String urlRegistroBoletoProducao = "https://secure.api.itau/pix_recebimentos_conciliacoes/v2/boletos_pix";
    @NotEmpty
    private String urlTokenHomologacao = "https://devportal.itau.com.br/api/jwt";
    @NotEmpty
    private String urlTokenProducao = "https://sts.itau.com.br/api/oauth/token";
    private String token;
    private LocalDateTime expiracaoToken;
    private final String arquivoJasper = "BoletoItau";
    private final String logo = "LogoItau.png";
    private InputStream modeloImpressaoBoleto;
    private HashMap<String, Object> parametrosImpressaoBoleto = new HashMap();

    public String getURLToken() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlTokenProducao : this.urlTokenHomologacao;
    }

    public String getURLRegistroBoleto() {
        return this.ambiente.equals((Object)AmbienteEnum.PRODUCAO) ? this.urlRegistroBoletoProducao : this.urlRegistroBoletoHomologacao;
    }

    public HashMap<String, Object> getParametrosImpressaoBoleto() {
        return this.parametrosImpressaoBoleto;
    }

    public void setModeloImpressaoBoleto(InputStream modeloImpressaoBoleto) {
        this.modeloImpressaoBoleto = modeloImpressaoBoleto;
    }

    @Override
    public InputStream modeloImpressaoBoleto() {
        if (this.modeloImpressaoBoleto == null) {
            try {
                this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoItau.jasper");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.modeloImpressaoBoleto;
    }

    @Override
    public void usarModeloImpressaoBoletoCarne() {
        try {
            this.modeloImpressaoBoleto = this.getClass().getResourceAsStream("/impressao/BoletoCarne.jasper");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public HashMap<String, Object> parametrosImpressaoBoleto() {
        Image imageLogo = null;
        try {
            InputStream inputStreamLogo = this.getClass().getResourceAsStream("/logo/LogoItau.png");
            imageLogo = new ImageIcon(IOUtils.toByteArray(inputStreamLogo)).getImage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.parametrosImpressaoBoleto.put("LogoBanco", imageLogo);
        this.parametrosImpressaoBoleto.put("REPORT_LOCALE", new Locale("pt", "BR"));
        return this.parametrosImpressaoBoleto;
    }

    @Override
    public List<String> camposObrigatoriosBoleto() {
        return Arrays.asList("beneficiario", "beneficiario.agencia", "beneficiario.conta", "beneficiario.digitoConta", "beneficiario.carteira", "valorBoleto", "dataVencimento", "dataEmissao", "especieDocumento", "numeroBoleto", "pagador", "pagador.nome", "pagador.documento", "pagador.endereco", "pagador.endereco.logradouro", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf", "pagador.endereco.cep", "beneficiario.documento");
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getCaminhoCertificado() {
        return this.caminhoCertificado;
    }

    public String getSenhaCertificado() {
        return this.senhaCertificado;
    }

    @NotNull
    public AmbienteEnum getAmbiente() {
        return this.ambiente;
    }

    public String getUrlRegistroBoletoHomologacao() {
        return this.urlRegistroBoletoHomologacao;
    }

    public String getUrlRegistroBoletoProducao() {
        return this.urlRegistroBoletoProducao;
    }

    public String getUrlTokenHomologacao() {
        return this.urlTokenHomologacao;
    }

    public String getUrlTokenProducao() {
        return this.urlTokenProducao;
    }

    public String getToken() {
        return this.token;
    }

    public LocalDateTime getExpiracaoToken() {
        return this.expiracaoToken;
    }

    public String getArquivoJasper() {
        return this.arquivoJasper;
    }

    public String getLogo() {
        return this.logo;
    }

    public InputStream getModeloImpressaoBoleto() {
        return this.modeloImpressaoBoleto;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setCaminhoCertificado(String caminhoCertificado) {
        this.caminhoCertificado = caminhoCertificado;
    }

    public void setSenhaCertificado(String senhaCertificado) {
        this.senhaCertificado = senhaCertificado;
    }

    public void setAmbiente(@NotNull AmbienteEnum ambiente) {
        this.ambiente = ambiente;
    }

    public void setUrlRegistroBoletoHomologacao(String urlRegistroBoletoHomologacao) {
        this.urlRegistroBoletoHomologacao = urlRegistroBoletoHomologacao;
    }

    public void setUrlRegistroBoletoProducao(String urlRegistroBoletoProducao) {
        this.urlRegistroBoletoProducao = urlRegistroBoletoProducao;
    }

    public void setUrlTokenHomologacao(String urlTokenHomologacao) {
        this.urlTokenHomologacao = urlTokenHomologacao;
    }

    public void setUrlTokenProducao(String urlTokenProducao) {
        this.urlTokenProducao = urlTokenProducao;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setExpiracaoToken(LocalDateTime expiracaoToken) {
        this.expiracaoToken = expiracaoToken;
    }

    public void setParametrosImpressaoBoleto(HashMap<String, Object> parametrosImpressaoBoleto) {
        this.parametrosImpressaoBoleto = parametrosImpressaoBoleto;
    }
}

