/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.pjbank_api;

import br.com.java_brasil.boleto.service.bancos.pjbank_api.ConfiguracaoPjBankAPI;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankException;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankExceptionHandler;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class PJBankClient {
    private String absolutePath;

    public PJBankClient(String endPoint) {
        if (StringUtils.isBlank(endPoint)) {
            throw new IllegalArgumentException("Endpoint n\u00e3o informado");
        }
        this.absolutePath = ConfiguracaoPjBankAPI.getApiBaseUrl().concat(endPoint);
        System.setProperty("jsse.enableSNIExtension", "true");
    }

    public HttpGet getHttpGetClient() {
        HttpGet client = new HttpGet(this.absolutePath);
        client.addHeader("Accept", "application/json");
        client.addHeader("Content-Type", "application/json");
        client.addHeader("Source", "java-sdk");
        return client;
    }

    public HttpPost getHttpPostClient() {
        HttpPost client = new HttpPost(this.absolutePath);
        client.addHeader("Accept", "application/json");
        client.addHeader("Content-Type", "application/json");
        client.addHeader("Source", "java-sdk");
        return client;
    }

    public HttpPut getHttpPutClient() {
        HttpPut client = new HttpPut(this.absolutePath);
        client.addHeader("Accept", "application/json");
        client.addHeader("Content-Type", "application/json");
        client.addHeader("Source", "java-sdk");
        return client;
    }

    public HttpDelete getHttpDeleteClient() {
        HttpDelete client = new HttpDelete(this.absolutePath);
        client.addHeader("Accept", "application/json");
        client.addHeader("Content-Type", "application/json");
        client.addHeader("Source", "java-sdk");
        return client;
    }

    private HttpClient getHttpClient() {
        try {
            SSLContext sslContext = SSLContexts.custom().build();
            SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
            return HttpClients.custom().setSSLSocketFactory(f).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return HttpClientBuilder.create().build();
        }
    }

    public HttpResponse doRequest(HttpRequestBase httpRequestClient) throws IOException, PJBankException {
        HttpClient client = this.getHttpClient();
        HttpResponse response = client.execute(httpRequestClient);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw PJBankExceptionHandler.handleFromJSONResponse(EntityUtils.toString(response.getEntity()), response.getStatusLine().getStatusCode());
        }
        return response;
    }
}

