/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.pjbank_api.recebimento;

import br.com.java_brasil.boleto.service.bancos.pjbank_api.PJBankClient;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.auth.PJBankAuthenticatedService;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.exceptions.PJBankException;
import br.com.java_brasil.boleto.service.bancos.pjbank_api.models.recebimento.Carne;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CarneManager
extends PJBankAuthenticatedService {
    private String endPoint = "recebimentos/{{credencial}}";

    public CarneManager(String credencial, String chave) {
        super(credencial, chave);
        this.endPoint = this.endPoint.replace("{{credencial}}", credencial);
    }

    public Carne carne(Carne carne) throws IOException, PJBankException {
        PJBankClient client = new PJBankClient(this.endPoint.concat("/transacoes/lotes"));
        HttpPost httpPost = client.getHttpPostClient();
        httpPost.addHeader("x-chave", this.chave);
        JSONObject params = new JSONObject();
        params.put("formato", "carne");
        params.put("pedido_numero", new JSONArray((Collection<?>)carne.getPedidoNumero()));
        httpPost.setEntity(new StringEntity(params.toString(), StandardCharsets.UTF_8));
        String response = EntityUtils.toString(client.doRequest(httpPost).getEntity());
        JSONObject responseObject = new JSONObject(response);
        carne.setLinkBoleto(responseObject.getString("linkBoleto"));
        return carne;
    }
}

