/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.safe2pay_api.model;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.ConfiguracaoSafe2PayAPI;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.cancelamento.BoletoSafe2PayAPICancelarResponse;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.consulta.BoletoSafe2PayAPIConsultaResponse;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.envio.BoletoSafe2PayAPIEnvioResponse;
import br.com.java_brasil.boleto.service.bancos.safe2pay_api.model.envio.Payment;
import br.com.java_brasil.boleto.util.BoletoUtil;

public class BoletoSafe2PayModelConverter {
    public static Payment montaEnviarBoletoRequest(BoletoModel boletoModel, ConfiguracaoSafe2PayAPI configuracaoSafe2PayAPI) {
        boolean sandbox = configuracaoSafe2PayAPI.isSandbox();
        Payment payment = new Payment(boletoModel, sandbox);
        return payment;
    }

    public static BoletoModel montaEnviarBoletoResponse(BoletoModel boletoModel, BoletoSafe2PayAPIEnvioResponse response) {
        boletoModel.setNumeroBoleto(response.getResponseDetail().getIdTransaction());
        boletoModel.setCodRetorno(response.getResponseDetail().getStatus());
        boletoModel.setMensagemRetorno(response.getResponseDetail().getMessage());
        boletoModel.setCodigoBarras(response.getResponseDetail().getBarcode());
        boletoModel.setUrlPdf(response.getResponseDetail().getBankSlipUrl());
        boletoModel.setSituacao(BoletoSafe2PayModelConverter.converteStatusSituacao(response.getResponseDetail().getStatus()));
        return boletoModel;
    }

    public static BoletoModel montaConsultarBoletoResponse(BoletoModel boletoModel, BoletoSafe2PayAPIConsultaResponse response) {
        boletoModel.setNumeroBoleto(response.getResponseDetail().getIdTransaction());
        boletoModel.setCodRetorno(response.getResponseDetail().getStatus());
        boletoModel.setMensagemRetorno(response.getResponseDetail().getMessage());
        boletoModel.setSituacao(BoletoSafe2PayModelConverter.converteStatusSituacao(response.getResponseDetail().getStatus()));
        boletoModel.setUrlPdf(response.getResponseDetail().getPaymentObject().getBankSlipUrl());
        boletoModel.setCodigoBarras(response.getResponseDetail().getPaymentObject().getBarcode());
        boletoModel.setDataVencimento(BoletoUtil.formataStringPadraoYYYYMMDDParaLocalDate(response.getResponseDetail().getPaymentObject().getDueDate().replace("-", "")));
        return boletoModel;
    }

    public static BoletoModel montaBaixaBoletoResponse(BoletoModel boletoModel, BoletoSafe2PayAPICancelarResponse response) {
        return boletoModel;
    }

    private static SituacaoEnum converteStatusSituacao(String status) {
        if (status != null && (status.equals("7") || status.equals("11") || status.equals("12"))) {
            return SituacaoEnum.BAIXADO;
        }
        if (status != null && status.equals("3")) {
            return SituacaoEnum.LIQUIDADO;
        }
        return SituacaoEnum.EM_ABERTO;
    }

    public static Payment montaAlterarBoletoRequest(BoletoModel boletoModel) {
        Payment payment = new Payment(boletoModel.getNumeroBoleto(), boletoModel.getDataVencimento(), 1);
        return payment;
    }
}

