/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicoob_api.model;

import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.enums.SituacaoEnum;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.ConfiguracaoSicoobAPI;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobBeneficiarioFinal;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobBoleto;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobMensagensInstrucao;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobPagador;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobResultado;
import br.com.java_brasil.boleto.service.bancos.sicoob_api.model.BoletoSicoobStatus;
import br.com.java_brasil.boleto.util.BoletoUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class BoletoSicoobModelConverter {
    public static BoletoModel montaBoletoResponse(BoletoModel boletoModel, BoletoSicoobBoleto boletoResponse) {
        boletoModel.setCodigoBarras(boletoResponse.getCodigoBarras());
        boletoModel.setLinhaDigitavel(boletoResponse.getLinhaDigitavel());
        boletoModel.setImpressaoBase64(boletoResponse.getPdfBoleto());
        boletoModel.setNossoNumero(boletoResponse.getNossoNumero() + "");
        if (StringUtils.isBlank(boletoResponse.getSituacaoBoleto())) {
            boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
        } else {
            switch (boletoResponse.getSituacaoBoleto()) {
                case "Em Aberto": {
                    boletoModel.setSituacao(SituacaoEnum.EM_ABERTO);
                    break;
                }
                case "Baixado": {
                    boletoModel.setSituacao(SituacaoEnum.BAIXADO);
                    break;
                }
                case "Liquidado": {
                    boletoModel.setSituacao(SituacaoEnum.LIQUIDADO);
                }
            }
        }
        return boletoModel;
    }

    public static BoletoSicoobBoleto montaBoletoRequest(BoletoModel boletoModel, ConfiguracaoSicoobAPI configuracaoSicoobAPI) {
        BoletoSicoobBoleto boleto = new BoletoSicoobBoleto();
        boleto.setNumeroContrato(configuracaoSicoobAPI.getNumeroContrato());
        boleto.setModalidade(1);
        boleto.setNumeroContaCorrente(Integer.valueOf(configuracaoSicoobAPI.getContaCorrente()));
        boleto.setEspecieDocumento(boletoModel.getEspecieDocumento());
        boleto.setDataEmissao(BoletoUtil.getDataFormatoYYYYMMDD(LocalDate.now()) + "T00:00:00-03:00");
        boleto.setSeuNumero(Integer.valueOf(boletoModel.getNumeroBoleto()));
        boleto.setIdentificacaoEmissaoBoleto(2);
        boleto.setValor(boletoModel.getValorBoleto().setScale(2, RoundingMode.HALF_UP));
        boleto.setDataVencimento(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataVencimento()) + "T00:00:00-03:00");
        boleto.setNumeroParcela(Optional.ofNullable(boleto.getNumeroParcela()).orElse(1));
        boleto.setGerarPdf(true);
        boleto.setIdentificacaoDistribuicaoBoleto(2);
        boleto.setTipoDesconto(32);
        boleto.setMensagensInstrucao(BoletoSicoobModelConverter.toBoletoSicoobMsgInstrucao(boletoModel.getInstrucoes()));
        BoletoSicoobModelConverter.preenchedadosPagador(boletoModel, boleto);
        BoletoSicoobModelConverter.preecheDadosBeneficiario(boletoModel, boleto);
        BoletoSicoobModelConverter.preencheDadosJuros(boletoModel, boleto);
        BoletoSicoobModelConverter.preencheDadosMulta(boletoModel, boleto);
        BoletoSicoobModelConverter.preencheDesconto(boletoModel, boleto);
        return boleto;
    }

    private static BoletoSicoobMensagensInstrucao toBoletoSicoobMsgInstrucao(List<InformacaoModel> listInfModel) {
        if (listInfModel != null && !listInfModel.isEmpty()) {
            BoletoSicoobMensagensInstrucao bolInst = new BoletoSicoobMensagensInstrucao();
            bolInst.setTipoInstrucao(1);
            bolInst.setMensagens(new ArrayList<String>());
            listInfModel.stream().forEach(infModel -> bolInst.getMensagens().add(infModel.getInformacao()));
            return bolInst;
        }
        return null;
    }

    private static void preencheDesconto(BoletoModel boletoModel, BoletoSicoobBoleto boleto) {
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorDescontos())) {
            boleto.setTipoDesconto(1);
            boleto.setValorPrimeiroDesconto(boletoModel.getValorDescontos().setScale(2, RoundingMode.HALF_UP));
            boleto.setDataPrimeiroDesconto(BoletoUtil.getDataFormatoDDMMYYYY(boletoModel.getDataVencimento()) + "T00:00:00-03:00");
        } else {
            boleto.setTipoDesconto(0);
        }
    }

    private static void preecheDadosBeneficiario(BoletoModel boletoModel, BoletoSicoobBoleto boletoRequest) {
        BoletoSicoobBeneficiarioFinal beneficiario = new BoletoSicoobBeneficiarioFinal();
        beneficiario.setNumeroCpfCnpj(boletoModel.getBeneficiario().getDocumento());
        beneficiario.setNome(boletoModel.getBeneficiario().getNomeBeneficiario());
        boletoRequest.setBeneficiarioFinal(beneficiario);
    }

    private static void preenchedadosPagador(BoletoModel boletoModel, BoletoSicoobBoleto boletoRequest) {
        BoletoSicoobPagador pagador = new BoletoSicoobPagador();
        pagador.setNumeroCpfCnpj(boletoModel.getPagador().getDocumento());
        pagador.setNome(BoletoUtil.limitarTamanhoString(boletoModel.getPagador().getNome(), 50));
        pagador.setEndereco(boletoModel.getPagador().getEndereco().getLogradouro());
        pagador.setBairro(boletoModel.getPagador().getEndereco().getBairro());
        pagador.setCidade(boletoModel.getPagador().getEndereco().getCidade());
        pagador.setCep(boletoModel.getPagador().getEndereco().getCep());
        pagador.setUf(boletoModel.getPagador().getEndereco().getUf());
        pagador.setEmail(StringUtils.isNotBlank(boletoModel.getPagador().getEmail()) ? Collections.singletonList(boletoModel.getPagador().getEmail()) : null);
        boletoRequest.setPagador(pagador);
    }

    private static void preencheDadosJuros(BoletoModel boletoModel, BoletoSicoobBoleto boletoRequest) {
        switch (boletoModel.getTipoJuros()) {
            case ISENTO: {
                boletoRequest.setTipoJurosMora(3);
                boletoRequest.setValorJurosMora(null);
                break;
            }
            case PERCENTUAL_MENSAL: {
                boletoRequest.setTipoJurosMora(2);
                boletoRequest.setValorJurosMora(boletoModel.getPercentualJuros().setScale(2, RoundingMode.HALF_UP));
                boletoRequest.setDataJurosMora(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataJuros()) + "T00:00:00-03:00");
                break;
            }
            case VALOR_DIA: {
                boletoRequest.setTipoJurosMora(1);
                boletoRequest.setValorJurosMora(boletoModel.getValorAcrescimos().setScale(2, RoundingMode.HALF_UP));
                boletoRequest.setDataJurosMora(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataJuros()) + "T00:00:00-03:00");
            }
        }
    }

    private static void preencheDadosMulta(BoletoModel boletoModel, BoletoSicoobBoleto boletoRequest) {
        switch (boletoModel.getTipoMulta()) {
            case ISENTO: {
                boletoRequest.setTipoMulta(0);
                boletoRequest.setValorMulta(null);
                break;
            }
            case VALOR: {
                boletoRequest.setTipoMulta(1);
                boletoRequest.setValorMulta(boletoModel.getValorMulta().setScale(2, RoundingMode.HALF_UP));
                boletoRequest.setDataMulta(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataMulta()) + "T00:00:00-03:00");
                break;
            }
            case PERCENTUAL: {
                boletoRequest.setTipoMulta(2);
                boletoRequest.setValorMulta(boletoModel.getPercentualMulta().setScale(2, RoundingMode.HALF_UP));
                boletoRequest.setDataMulta(BoletoUtil.getDataFormatoYYYYMMDD(boletoModel.getDataMulta()) + "T00:00:00-03:00");
            }
        }
    }

    public static String patchBaixa(BoletoModel bolModel, ConfiguracaoSicoobAPI cfg) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode jsonObj = mapper.createObjectNode();
        jsonObj.put("numeroContrato", cfg.getNumeroContrato() + "");
        jsonObj.put("modalidade", 1);
        jsonObj.put("nossoNumero", bolModel.getNossoNumero());
        return mapper.writeValueAsString(Collections.singletonList(jsonObj));
    }

    public static List<BoletoSicoobResultado> resultadoBaixa(JsonNode resultadoNode) {
        JsonNode resultadoList = resultadoNode.get("resultado");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<BoletoSicoobResultado> listSicoobResutado = new ArrayList<BoletoSicoobResultado>();
        Spliterator<JsonNode> spliterator = resultadoList.spliterator();
        spliterator.forEachRemaining(jsonNodeResultado -> {
            try {
                JsonNode status = jsonNodeResultado.get("status");
                BoletoSicoobResultado bolSiccobRes = new BoletoSicoobResultado();
                bolSiccobRes.setStatus(mapper.readValue(status.toString(), BoletoSicoobStatus.class));
                JsonNode baixa = jsonNodeResultado.get("boleto");
                bolSiccobRes.setBoleto(mapper.readValue(baixa.toString(), BoletoSicoobBoleto.class));
                listSicoobResutado.add(bolSiccobRes);
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(BoletoSicoobModelConverter.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        return listSicoobResutado;
    }
}

