/*
 * Decompiled with CFR 0.152.
 */
package br.com.java_brasil.boleto.service.bancos.sicredi_cnab400;

import br.com.java_brasil.boleto.exception.BoletoException;
import br.com.java_brasil.boleto.model.Beneficiario;
import br.com.java_brasil.boleto.model.BoletoController;
import br.com.java_brasil.boleto.model.BoletoModel;
import br.com.java_brasil.boleto.model.InformacaoModel;
import br.com.java_brasil.boleto.model.Pagador;
import br.com.java_brasil.boleto.model.RemessaRetornoModel;
import br.com.java_brasil.boleto.model.enums.TipoDescontoEnum;
import br.com.java_brasil.boleto.model.enums.TipoJurosEnum;
import br.com.java_brasil.boleto.service.bancos.sicredi_cnab400.SicrediUtil;
import br.com.java_brasil.boleto.util.BoletoUtil;
import br.com.java_brasil.boleto.util.JasperUtil;
import br.com.java_brasil.boleto.util.ValidaUtils;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import javax.print.PrintService;
import javax.swing.ImageIcon;
import lombok.NonNull;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class BancoSicrediCnab400
extends BoletoController {
    @Override
    public JasperPrint imprimirBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        return this.imprimirBoleto(Collections.singletonList(boletoModel));
    }

    @Override
    public JasperPrint imprimirBoleto(@NonNull List<BoletoModel> boletos) {
        if (boletos == null) {
            throw new NullPointerException("boletos is marked non-null but is null");
        }
        try {
            boletos.forEach(this::preparaValidaBoletoImpressao);
            return JasperUtil.geraJasperPrint(this.getConfiguracao().modeloImpressaoBoleto(), this.getConfiguracao().parametrosImpressaoBoleto(), boletos);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoByte(@NonNull List<BoletoModel> boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            return JasperUtil.geraBytesRelatorio(jasperPrint);
        }
        catch (Exception e) {
            throw new BoletoException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] imprimirBoletoBanco(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("N\u00e3o implementado!");
    }

    @Override
    public void imprimirBoletoJasperDesktop(@NonNull BoletoModel boletoModel, boolean diretoImpressora, PrintService printService) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        try {
            JasperPrint jasperPrint = this.imprimirBoleto(boletoModel);
            JasperUtil.geraRelatorioDesktop(jasperPrint, diretoImpressora, printService);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BoletoException(e.getMessage());
        }
    }

    @Override
    public BoletoModel enviarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel alterarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel consultarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public BoletoModel baixarBoleto(@NonNull BoletoModel boletoModel) {
        if (boletoModel == null) {
            throw new NullPointerException("boletoModel is marked non-null but is null");
        }
        throw new BoletoException("Esta fun\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel para este banco.");
    }

    @Override
    public String gerarArquivoRemessa(@NonNull List<RemessaRetornoModel> remessaRetornoModel) {
        if (remessaRetornoModel == null) {
            throw new NullPointerException("remessaRetornoModel is marked non-null but is null");
        }
        return this.gerarArquivo(remessaRetornoModel);
    }

    @Override
    public List<RemessaRetornoModel> importarArquivoRetorno(@NonNull String arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("arquivo is marked non-null but is null");
        }
        return this.importarArquivo(arquivo);
    }

    public String gerarArquivo(List<RemessaRetornoModel> list) {
        list.forEach(boleto -> ValidaUtils.validaBoletoModel(boleto.getBoleto(), this.getConfiguracao().camposObrigatoriosBoleto()));
        Integer contador = 1;
        StringBuilder linhaArquivo = new StringBuilder();
        linhaArquivo.append("0");
        linhaArquivo.append("1");
        linhaArquivo.append("REMESSA");
        linhaArquivo.append("01");
        linhaArquivo.append("COBRANCA");
        linhaArquivo.append(StringUtils.rightPad("", 7, ' '));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 5, '0'));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getDocumento(), 14, '0'));
        linhaArquivo.append(StringUtils.repeat(" ", 31));
        linhaArquivo.append("748");
        linhaArquivo.append(StringUtils.rightPad("SICREDI", 15, ' '));
        linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "yyyyMMdd"));
        linhaArquivo.append(StringUtils.repeat(" ", 8));
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getNumeroRemessa(), 7, '0'));
        linhaArquivo.append(StringUtils.repeat(" ", 273));
        linhaArquivo.append("2.00");
        linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, '0'));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        Integer n = contador;
        Integer n2 = contador = Integer.valueOf(contador + 1);
        for (RemessaRetornoModel boleto2 : list) {
            linhaArquivo.append("1");
            linhaArquivo.append("A");
            linhaArquivo.append("A");
            linhaArquivo.append(boleto2.getBoleto().getTipoImpressao());
            linhaArquivo.append(" ");
            linhaArquivo.append("H");
            linhaArquivo.append(StringUtils.repeat(" ", 10));
            linhaArquivo.append("A");
            linhaArquivo.append(boleto2.getBoleto().getTipoDesconto().equals((Object)TipoDescontoEnum.VALOR_FIXO) ? "A" : "B");
            linhaArquivo.append(boleto2.getBoleto().getTipoJuros().equals((Object)TipoJurosEnum.VALOR_DIA) ? "A" : "B");
            linhaArquivo.append(StringUtils.repeat(" ", 28));
            linhaArquivo.append(boleto2.getBoleto().getNossoNumero() + boleto2.getBoleto().getDigitoNossoNumero());
            linhaArquivo.append(StringUtils.repeat(" ", 6));
            linhaArquivo.append(BoletoUtil.getDataFormato(LocalDate.now(), "yyyyMMdd"));
            linhaArquivo.append(boleto2.getInstrucao().equals("31") ? boleto2.getCampoAlterado() : " ");
            linhaArquivo.append(boleto2.getPostagemTitulo());
            linhaArquivo.append(" ");
            linhaArquivo.append(boleto2.getImpressaoTitulo());
            if (boleto2.getBoleto().getTipoImpressao().equals("B")) {
                linhaArquivo.append(StringUtils.leftPad(String.valueOf(boleto2.getBoleto().getNumeroDaParcelaCarne()), 2, '0'));
                linhaArquivo.append(StringUtils.leftPad(String.valueOf(boleto2.getBoleto().getNumeroTotalDeParcelasCarne()), 2, '0'));
            } else {
                linhaArquivo.append("00");
                linhaArquivo.append("00");
            }
            linhaArquivo.append(StringUtils.repeat(" ", 4));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos(), 2, 10));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualMulta(), 2, 4));
            linhaArquivo.append(StringUtils.repeat(" ", 12));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getInstrucao(), 2, '0'));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNumeroDocumento(), 10, '0'));
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataVencimento(), "ddMMyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorBoleto(), 2, 13));
            linhaArquivo.append(StringUtils.repeat(" ", 2));
            linhaArquivo.append(StringUtils.repeat(" ", 7));
            linhaArquivo.append(boleto2.getBoleto().getEspecieDocumento());
            linhaArquivo.append(boleto2.getBoleto().isAceite() ? "S" : "N");
            linhaArquivo.append(BoletoUtil.getDataFormato(boleto2.getBoleto().getDataEmissao(), "ddMMyy"));
            linhaArquivo.append(boleto2.getBoleto().isProtesto() ? "06" : "00");
            linhaArquivo.append(StringUtils.leftPad(String.valueOf(boleto2.getBoleto().getDiasProtesto()), 2, '0'));
            BigDecimal valorPercentualJuros = boleto2.getBoleto().getValorPercentualJuros();
            if (boleto2.getBoleto().getTipoJuros().equals((Object)TipoJurosEnum.PERCENTUAL_MENSAL) && BoletoUtil.isNotNullEMaiorQZero(valorPercentualJuros)) {
                valorPercentualJuros = valorPercentualJuros.divide(BigDecimal.valueOf(30L), MathContext.DECIMAL32);
            }
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(valorPercentualJuros, 2, 13));
            linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto() == null ? "000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto(), "ddMMyy"));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos(), 2, 13));
            linhaArquivo.append(boleto2.getBoleto().isNegativacaoAutomatica() ? "06" : "00");
            linhaArquivo.append(StringUtils.leftPad(String.valueOf(boleto2.getBoleto().getNumeroDiasNegativacao()), 2, '0'));
            linhaArquivo.append(StringUtils.repeat("0", 9));
            linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorDeducoes(), 2, 13));
            linhaArquivo.append(boleto2.getBoleto().getPagador().isClienteCpf() ? "1" : "2");
            linhaArquivo.append("0");
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getPagador().getDocumento(), 14, "0"));
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(boleto2.getBoleto().getPagador().getNome(), 40), 40, " "));
            StringBuilder enderecoCompletoPagador = new StringBuilder();
            enderecoCompletoPagador.append(Optional.ofNullable(boleto2.getBoleto().getPagador().getEndereco().getLogradouro()).orElse(""));
            enderecoCompletoPagador.append(" ");
            enderecoCompletoPagador.append(Optional.ofNullable(boleto2.getBoleto().getPagador().getEndereco().getNumero()).orElse(""));
            enderecoCompletoPagador.append(" ");
            enderecoCompletoPagador.append(Optional.ofNullable(boleto2.getBoleto().getPagador().getEndereco().getComplemento()).orElse(""));
            enderecoCompletoPagador.append(" - ");
            enderecoCompletoPagador.append(Optional.ofNullable(boleto2.getBoleto().getPagador().getEndereco().getCidade()).orElse(""));
            enderecoCompletoPagador.append("/");
            enderecoCompletoPagador.append(Optional.ofNullable(boleto2.getBoleto().getPagador().getEndereco().getUf()).orElse(""));
            linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(enderecoCompletoPagador.toString(), 40), 40, " "));
            linhaArquivo.append(StringUtils.leftPad(Optional.ofNullable(boleto2.getBoleto().getPagador().getCodigoNoBanco()).orElse(""), 5, "0"));
            linhaArquivo.append(StringUtils.repeat("0", 6));
            linhaArquivo.append(" ");
            linhaArquivo.append(BoletoUtil.manterApenasNumeros(boleto2.getBoleto().getPagador().getEndereco().getCep()));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getPagador().getCodigo(), 5, "0"));
            if (boleto2.getBoleto().getBeneficiarioFinal() != null) {
                linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getBeneficiarioFinal().getDocumento(), 14, "0"));
                linhaArquivo.append(StringUtils.rightPad(BoletoUtil.limitarTamanhoString(boleto2.getBoleto().getBeneficiarioFinal().getNome(), 41), 41, " "));
            } else {
                linhaArquivo.append(StringUtils.repeat(" ", 14));
                linhaArquivo.append(StringUtils.repeat(" ", 41));
            }
            linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            Integer n3 = contador;
            contador = contador + 1;
            Object object = contador;
            if (boleto2.getBoleto().getInstrucoes() != null && !boleto2.getBoleto().getInstrucoes().isEmpty()) {
                Serializable instrucao2;
                linhaArquivo.append("2");
                linhaArquivo.append(StringUtils.repeat(" ", 11));
                linhaArquivo.append(boleto2.getBoleto().getNossoNumero() + boleto2.getBoleto().getDigitoNossoNumero());
                int contadorInstrucao = 0;
                for (Serializable instrucao2 : boleto2.getBoleto().getInstrucoes()) {
                    linhaArquivo.append(StringUtils.rightPad(instrucao2.getInformacao(), 80, " "));
                    if (++contadorInstrucao < 4) continue;
                    break;
                }
                for (int i = contadorInstrucao; i < 4; ++i) {
                    linhaArquivo.append(StringUtils.repeat(" ", 80));
                }
                linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNumeroDocumento(), 10, '0'));
                linhaArquivo.append(StringUtils.repeat(" ", 43));
                linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
                linhaArquivo.append('\r');
                linhaArquivo.append('\n');
                Integer i = contador;
                contador = contador + 1;
                instrucao2 = contador;
            }
            if (boleto2.getBoleto().getDescricoes() != null && !boleto2.getBoleto().getDescricoes().isEmpty()) {
                linhaArquivo.append("5");
                linhaArquivo.append("E");
                linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 5, '0'));
                linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNumeroDocumento(), 10, '0'));
                linhaArquivo.append(" ");
                linhaArquivo.append("A");
                int contadorInformativo = 0;
                for (InformacaoModel informacao : boleto2.getBoleto().getDescricoes()) {
                    linhaArquivo.append(StringUtils.leftPad(String.valueOf(++contadorInformativo), 2, '0'));
                    linhaArquivo.append(StringUtils.rightPad(informacao.getInformacao(), 80, " "));
                    if (contadorInformativo < 4) continue;
                    break;
                }
                for (int i = contadorInformativo; i < 4; ++i) {
                    linhaArquivo.append(StringUtils.leftPad(String.valueOf(i), 2, '0'));
                    linhaArquivo.append(StringUtils.repeat(" ", 80));
                }
                linhaArquivo.append(StringUtils.repeat(" ", 47));
                linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
                linhaArquivo.append('\r');
                linhaArquivo.append('\n');
                object = contador;
                Integer n4 = contador = Integer.valueOf(contador + 1);
            }
            if (BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualDescontos()) && (BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualDescontos2()) || BoletoUtil.isNotNullEMaiorQZero(boleto2.getBoleto().getValorPercentualDescontos3()))) {
                linhaArquivo.append("7");
                linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNossoNumero() + boleto2.getBoleto().getDigitoNossoNumero(), 15, ' '));
                linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNumeroDocumento(), 10, '0'));
                linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getPagador().getDocumento(), 14, "0"));
                if (boleto2.getBoleto().getBeneficiarioFinal() != null) {
                    linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getBeneficiarioFinal().getDocumento(), 14, "0"));
                } else {
                    linhaArquivo.append(StringUtils.repeat(" ", 14));
                }
                linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto2() == null ? "000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto2(), "ddMMyy"));
                linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos2(), 2, 13));
                linhaArquivo.append(boleto2.getBoleto().getDataLimiteParaDesconto3() == null ? "000000" : BoletoUtil.getDataFormato(boleto2.getBoleto().getDataLimiteParaDesconto3(), "ddMMyy"));
                linhaArquivo.append(BoletoUtil.formatarValorSemPonto(boleto2.getBoleto().getValorPercentualDescontos3(), 2, 13));
                linhaArquivo.append(StringUtils.repeat(" ", 302));
                linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
                linhaArquivo.append('\r');
                linhaArquivo.append('\n');
                n3 = contador;
                contador = contador + 1;
                object = contador;
            }
            if (StringUtils.isBlank(boleto2.getBoleto().getPixTxidQrCode())) continue;
            linhaArquivo.append("8");
            linhaArquivo.append(StringUtils.rightPad(boleto2.getBoleto().getNossoNumero() + boleto2.getBoleto().getDigitoNossoNumero(), 15, ' '));
            linhaArquivo.append(" ");
            linhaArquivo.append("H");
            linhaArquivo.append(StringUtils.repeat(" ", 12));
            linhaArquivo.append(StringUtils.leftPad(boleto2.getBoleto().getNumeroDocumento(), 10, '0'));
            linhaArquivo.append(StringUtils.rightPad(boleto2.getBoleto().getPixTxidQrCode(), 35, ' '));
            linhaArquivo.append(StringUtils.repeat(" ", 319));
            linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
            linhaArquivo.append('\r');
            linhaArquivo.append('\n');
            n3 = contador;
            contador = contador + 1;
            object = contador;
        }
        linhaArquivo.append("9");
        linhaArquivo.append("1");
        linhaArquivo.append("748");
        linhaArquivo.append(StringUtils.leftPad(list.get(0).getBoleto().getBeneficiario().getConta(), 5, '0'));
        linhaArquivo.append(StringUtils.repeat(" ", 384));
        linhaArquivo.append(StringUtils.leftPad(contador.toString(), 6, "0"));
        linhaArquivo.append('\r');
        linhaArquivo.append('\n');
        String arquivoRemessa = linhaArquivo.toString();
        StringBuilder sbRemessa = new StringBuilder();
        for (int i = 0; i < arquivoRemessa.length(); ++i) {
            char ch = arquivoRemessa.charAt(i);
            if (SicrediUtil.isASCIISicredi(ch)) {
                sbRemessa.append(ch);
                continue;
            }
            sbRemessa.append(' ');
        }
        return sbRemessa.toString();
    }

    private List<RemessaRetornoModel> importarArquivo(String arquivo) {
        ArrayList<RemessaRetornoModel> list = new ArrayList<RemessaRetornoModel>();
        String numeroRetorno = null;
        try (Scanner scanner = new Scanner(arquivo);){
            while (scanner.hasNextLine()) {
                String linha = scanner.nextLine();
                if (linha.length() <= 1) continue;
                if (linha.substring(0, 1).equals("0")) {
                    if (!linha.substring(1, 2).equals("2")) {
                        throw new BoletoException("Formato do aquivo inv\u00e1lido.");
                    }
                    if (!linha.substring(76, 79).equals("748")) {
                        throw new BoletoException("N\u00famero do Banco inv\u00e1lido.");
                    }
                    numeroRetorno = linha.substring(110, 117);
                }
                if (linha.substring(0, 1).equals("1")) {
                    RemessaRetornoModel remessaRetornoModel = new RemessaRetornoModel();
                    remessaRetornoModel.setBoleto(new BoletoModel());
                    remessaRetornoModel.getBoleto().setPagador(new Pagador());
                    remessaRetornoModel.getBoleto().setBeneficiario(new Beneficiario());
                    remessaRetornoModel.getBoleto().setCodRetorno(numeroRetorno);
                    remessaRetornoModel.getBoleto().getPagador().setCodigoNoBanco(linha.substring(14, 19));
                    remessaRetornoModel.getBoleto().getPagador().setCodigo(linha.substring(19, 24));
                    remessaRetornoModel.setBoletoDda(linha.substring(24, 25));
                    remessaRetornoModel.getBoleto().setNossoNumero(linha.substring(47, 56));
                    remessaRetornoModel.getBoleto().setDigitoNossoNumero(linha.substring(56, 57));
                    remessaRetornoModel.setOcorrencia(linha.substring(108, 110));
                    remessaRetornoModel.setDataOcorrencia(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(110, 116)));
                    remessaRetornoModel.getBoleto().setNumeroDocumento(linha.substring(116, 126));
                    remessaRetornoModel.getBoleto().setDataVencimento(BoletoUtil.formataStringPadraoDDMMYYParaLocalDate(linha.substring(146, 152)));
                    remessaRetornoModel.getBoleto().setValorBoleto(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(152, 165)));
                    remessaRetornoModel.setDespesaCobranca(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(175, 188)));
                    remessaRetornoModel.setDespesaCustasProtesto(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(188, 201)));
                    remessaRetornoModel.setAbatimentoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(227, 240)));
                    remessaRetornoModel.setDescontoConcedido(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(240, 253)));
                    remessaRetornoModel.setValorEfetivamentePago(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(253, 266)));
                    remessaRetornoModel.setJuroDeMora(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(266, 279)));
                    remessaRetornoModel.setMulta(BoletoUtil.stringSemPontoParaBigDecimal(linha.substring(279, 292)));
                    remessaRetornoModel.setConfirmacaoProtesto(linha.substring(294, 295));
                    remessaRetornoModel.setMotivoOcorrencia(linha.substring(318, 328));
                    remessaRetornoModel.setDataPrevisaoLancamento(BoletoUtil.formataStringPadraoYYYYMMDDParaLocalDate(linha.substring(328, 336)));
                    list.add(remessaRetornoModel);
                }
                if (!linha.substring(0, 1).equals("8")) continue;
                String nossoNumero = BoletoUtil.manterApenasNumeros(linha.substring(1, 16)).substring(0, 8);
                list.stream().filter(bol -> bol.getBoleto().getNossoNumero().equals(nossoNumero)).findFirst().ifPresent(boleto -> {
                    boleto.getBoleto().setPixTxidQrCode(linha.substring(20, 55));
                    boleto.getBoleto().setPixUrlQrCode(linha.substring(56, 133));
                    boleto.getBoleto().setPixCopiaCola(linha.substring(134, 390));
                });
            }
        }
        return list;
    }

    private HashMap<String, Object> getParametrosRelatorio() throws IOException {
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("REPORT_LOCALE", new Locale("pt", "BR"));
        InputStream inputStream = this.getClass().getResourceAsStream("/logo/LogoSicredi.jpg");
        Image image = new ImageIcon(IOUtils.toByteArray(inputStream)).getImage();
        parametros.put("LogoBanco", image);
        return parametros;
    }

    private void preparaValidaBoletoImpressao(BoletoModel boletoModel) {
        boletoModel.getBeneficiario().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiario().getDocumento()));
        boletoModel.getPagador().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getPagador().getDocumento()));
        if (boletoModel.getBeneficiarioFinal() != null) {
            boletoModel.getBeneficiarioFinal().setDocumento(BoletoUtil.formatarCnpjCpf(boletoModel.getBeneficiarioFinal().getDocumento()));
        }
        StringBuilder codigoBarras = new StringBuilder();
        codigoBarras.append("7489");
        codigoBarras.append("X");
        codigoBarras.append(SicrediUtil.fatorData(boletoModel.getDataVencimento()));
        codigoBarras.append(BoletoUtil.formatarValorSemPonto(boletoModel.getValorBoleto(), 2, 10));
        StringBuilder campoLivre = new StringBuilder();
        campoLivre.append("11");
        campoLivre.append(boletoModel.getNossoNumero() + boletoModel.getDigitoNossoNumero());
        campoLivre.append(StringUtils.leftPad(boletoModel.getBeneficiario().getAgencia(), 4, "0"));
        campoLivre.append(StringUtils.leftPad(boletoModel.getBeneficiario().getPostoDaAgencia(), 2, "0"));
        campoLivre.append(StringUtils.leftPad(boletoModel.getBeneficiario().getConta(), 5, '0'));
        campoLivre.append(BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorBoleto()) ? "10" : "00");
        Integer digitoCampoLivre = SicrediUtil.modulo11DvCampoLivre(campoLivre.toString());
        campoLivre.append(digitoCampoLivre);
        codigoBarras.append((CharSequence)campoLivre);
        Integer digitoVerificadorGeral = SicrediUtil.modulo11DvGeralSicredi(codigoBarras.toString().replace("X", ""));
        boletoModel.setCodigoBarras(codigoBarras.toString().replace("X", digitoVerificadorGeral.toString()));
        StringBuilder linhaParte1 = new StringBuilder();
        linhaParte1.append("7489");
        linhaParte1.append(campoLivre.toString().substring(0, 5));
        linhaParte1.append(SicrediUtil.modulo10Sicredi(linhaParte1.toString()));
        StringBuilder linhaParte2 = new StringBuilder();
        linhaParte2.append(campoLivre.toString().substring(5, 15));
        linhaParte2.append(SicrediUtil.modulo10Sicredi(linhaParte2.toString()));
        StringBuilder linhaParte3 = new StringBuilder();
        linhaParte3.append(campoLivre.substring(15, 25));
        linhaParte3.append(SicrediUtil.modulo10Sicredi(linhaParte3.toString()));
        StringBuilder linhaParte4 = new StringBuilder();
        linhaParte4.append(digitoVerificadorGeral);
        StringBuilder linhaParte5 = new StringBuilder();
        linhaParte5.append(codigoBarras.toString().substring(5, 19));
        StringBuilder linhaDigitavel = new StringBuilder();
        linhaDigitavel.append(linhaParte1.toString().substring(0, 5));
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte1.toString().substring(5, 10));
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte2.toString().substring(0, 5));
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte2.toString().substring(5, 11));
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte3.toString().substring(0, 5));
        linhaDigitavel.append(".");
        linhaDigitavel.append(linhaParte3.toString().substring(5, 11));
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte4.toString());
        linhaDigitavel.append("  ");
        linhaDigitavel.append(linhaParte5.toString());
        boletoModel.setLinhaDigitavel(linhaDigitavel.toString());
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualMulta())) {
            String instrucaoMulta = "APOS VENCIMENTO COBRAR MULTA DE " + BoletoUtil.formatarCasasDecimais(boletoModel.getValorPercentualMulta(), 2) + "%";
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoMulta));
        }
        if (BoletoUtil.isNotNullEMaiorQZero(boletoModel.getValorPercentualJuros())) {
            BigDecimal valorPercentualJuros = boletoModel.getValorPercentualJuros();
            BigDecimal valorMoraDia = boletoModel.getValorPercentualJuros();
            if (boletoModel.getTipoJuros().equals((Object)TipoJurosEnum.PERCENTUAL_MENSAL) && BoletoUtil.isNotNullEMaiorQZero(valorPercentualJuros)) {
                valorPercentualJuros = valorPercentualJuros.divide(BigDecimal.valueOf(30L), MathContext.DECIMAL32);
                valorMoraDia = boletoModel.getValorBoleto().multiply(valorPercentualJuros, MathContext.DECIMAL32);
                valorMoraDia = valorMoraDia.divide(BigDecimal.valueOf(100L), MathContext.DECIMAL32);
            }
            String instrucaoJuros = "APOS VENCIMENTO COBRAR MORA DIARIA DE R$ " + BoletoUtil.formatarCasasDecimais(valorMoraDia, 2);
            boletoModel.getInstrucoes().add(new InformacaoModel(instrucaoJuros));
        }
        this.validaDadosImpressao(boletoModel);
    }

    private void validaDadosImpressao(BoletoModel boleto) {
        ValidaUtils.validaBoletoModel(boleto, Arrays.asList("locaisDePagamento", "dataVencimento", "beneficiario.nomeBeneficiario", "beneficiario.documento", "beneficiario.agencia", "beneficiario.postoDaAgencia", "beneficiario.conta", "dataEmissao", "numeroDocumento", "especieDocumento", "aceite", "nossoNumero", "digitoNossoNumero", "especieMoeda", "valorBoleto", "pagador.nome", "pagador.documento", "pagador.endereco.logradouro", "pagador.endereco.cep", "linhaDigitavel", "codigoBarras", "pagador.endereco.numero", "pagador.endereco.bairro", "pagador.endereco.cidade", "pagador.endereco.uf"));
    }
}

